/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.jscode;

import com.helger.annotation.style.CodingStyleguideUnaware;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.html.js.IHasJSCode;
import com.helger.html.js.IJSWriterSettings;
import com.helger.html.jscode.AbstractJSStatement;
import com.helger.html.jscode.IJSExpression;
import com.helger.html.jscode.JSBlock;
import com.helger.html.jscode.JSExpr;
import com.helger.html.jscode.JSFormatter;
import com.helger.html.jscode.JSOp;
import com.helger.html.jscode.JSPrinter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public class JSConditional
extends AbstractJSStatement {
    private final IJSExpression m_aTest;
    private final JSBlock m_aThen = new JSBlock();
    private JSBlock m_aElse;

    public JSConditional(@Nonnull IJSExpression iJSExpression) {
        this.m_aTest = (IJSExpression)ValueEnforcer.notNull((Object)iJSExpression, (String)"Test");
    }

    public JSConditional(@Nonnull IJSExpression iJSExpression, @Nullable IHasJSCode iHasJSCode) {
        this(iJSExpression);
        if (iHasJSCode != null) {
            this.m_aThen.add(iHasJSCode);
        }
    }

    public JSConditional(@Nonnull IJSExpression iJSExpression, @Nullable IHasJSCode iHasJSCode, @Nullable IHasJSCode iHasJSCode2) {
        this(iJSExpression, iHasJSCode);
        if (iHasJSCode2 != null) {
            this._else().add(iHasJSCode2);
        }
    }

    @Nonnull
    public IJSExpression test() {
        return this.m_aTest;
    }

    @Nonnull
    @CodingStyleguideUnaware
    public final JSBlock _then() {
        return this.m_aThen;
    }

    @Nonnull
    @CodingStyleguideUnaware
    public final JSBlock _else() {
        if (this.m_aElse == null) {
            this.m_aElse = new JSBlock();
        }
        return this.m_aElse;
    }

    @Nonnull
    public JSConditional elseif(@Nonnull IJSExpression iJSExpression) {
        return this._else()._if(iJSExpression);
    }

    @Override
    public void state(@Nonnull JSFormatter jSFormatter) {
        if (this.m_aTest == JSExpr.TRUE) {
            this.m_aThen.generateBody(jSFormatter);
            return;
        }
        if (this.m_aTest == JSExpr.FALSE && this.m_aElse != null) {
            this.m_aElse.generateBody(jSFormatter);
            return;
        }
        if (JSOp.hasOperator(this.m_aTest)) {
            jSFormatter.plain("if").generatable(this.m_aTest);
        } else {
            jSFormatter.plain("if(").generatable(this.m_aTest).plain(')');
        }
        jSFormatter.generatable(this.m_aThen);
        if (this.m_aElse != null) {
            jSFormatter.plain("else").generatable(this.m_aElse);
        }
        jSFormatter.nl();
    }

    @Nullable
    public String getJSCode(@Nullable IJSWriterSettings iJSWriterSettings) {
        return JSPrinter.getAsString(iJSWriterSettings, this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        JSConditional jSConditional = (JSConditional)object;
        return this.m_aTest.equals(jSConditional.m_aTest) && this.m_aThen.equals(jSConditional.m_aThen) && EqualsHelper.equals((Object)this.m_aElse, (Object)jSConditional.m_aElse);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aTest).append((Object)this.m_aThen).append((Object)this.m_aElse).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("test", (Object)this.m_aTest).append("then", (Object)this.m_aThen).appendIfNotNull("else", (Object)this.m_aElse).getToString();
    }
}

