/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.jscode;

import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.cache.regex.RegExHelper;
import com.helger.html.js.IJSWriterSettings;
import com.helger.html.jscode.AbstractJSStatement;
import com.helger.html.jscode.JSFormatter;
import com.helger.html.jscode.JSPrinter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public class JSCommentSingleLine
extends AbstractJSStatement {
    private final String m_sComment;

    public JSCommentSingleLine(@Nonnull String string) {
        this.m_sComment = (String)ValueEnforcer.notNull((Object)string, (String)"Comment");
    }

    @Nonnull
    public String getComment() {
        return this.m_sComment;
    }

    @Override
    public void state(@Nonnull JSFormatter jSFormatter) {
        if (jSFormatter.getSettings().isGenerateComments()) {
            boolean bl = jSFormatter.getSettings().isIndentAndAlign();
            for (String string : RegExHelper.getSplitToArray((CharSequence)this.m_sComment, (String)"(\\r\\n|\\r|\\n)")) {
                if (bl) {
                    jSFormatter.plain("// ").plain(string).nl();
                    continue;
                }
                jSFormatter.plain("/*").plain(string).plain("*/");
            }
        }
    }

    @Nullable
    public String getJSCode(@Nullable IJSWriterSettings iJSWriterSettings) {
        return JSPrinter.getAsString(iJSWriterSettings, this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        JSCommentSingleLine jSCommentSingleLine = (JSCommentSingleLine)object;
        return this.m_sComment.equals(jSCommentSingleLine.m_sComment);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sComment).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("comment", (Object)this.m_sComment).getToString();
    }
}

