/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.jscode;

import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.html.js.IJSWriterSettings;
import com.helger.html.jscode.AbstractJSStatement;
import com.helger.html.jscode.IJSExpression;
import com.helger.html.jscode.JSBlock;
import com.helger.html.jscode.JSFormatter;
import com.helger.html.jscode.JSPrinter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public class JSCase
extends AbstractJSStatement {
    public static final boolean DEFAULT_DEFAULT_CASE = false;
    private final IJSExpression m_aLabel;
    private JSBlock m_aBody;
    private boolean m_bIsDefaultCase = false;

    public JSCase(@Nonnull IJSExpression iJSExpression) {
        this(iJSExpression, false);
    }

    public JSCase(@Nullable IJSExpression iJSExpression, boolean bl) {
        if (!bl && iJSExpression == null) {
            throw new IllegalArgumentException("Only the default case may not have a label!");
        }
        this.m_aLabel = iJSExpression;
        this.m_bIsDefaultCase = bl;
    }

    public boolean isDefaultCase() {
        return this.m_bIsDefaultCase;
    }

    @Nullable
    public IJSExpression label() {
        return this.m_aLabel;
    }

    @Nonnull
    public JSBlock body() {
        if (this.m_aBody == null) {
            this.m_aBody = new JSBlock(false, true);
        }
        return this.m_aBody;
    }

    @Override
    public void state(@Nonnull JSFormatter jSFormatter) {
        jSFormatter.indent();
        if (!this.m_bIsDefaultCase) {
            jSFormatter.plain("case ").generatable(this.m_aLabel).plain(':').nl();
        } else {
            jSFormatter.plain("default:").nl();
        }
        if (this.m_aBody != null) {
            jSFormatter.stmt(this.m_aBody);
        }
        jSFormatter.outdent();
    }

    @Nullable
    public String getJSCode(@Nullable IJSWriterSettings iJSWriterSettings) {
        return JSPrinter.getAsString(iJSWriterSettings, this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        JSCase jSCase = (JSCase)object;
        return EqualsHelper.equals((Object)this.m_aLabel, (Object)jSCase.m_aLabel) && EqualsHelper.equals((Object)this.m_aBody, (Object)jSCase.m_aBody) && this.m_bIsDefaultCase == jSCase.m_bIsDefaultCase;
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aLabel).append((Object)this.m_aBody).append(this.m_bIsDefaultCase).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).appendIfNotNull("label", (Object)this.m_aLabel).append("body", (Object)this.m_aBody).append("isDefaultCase", this.m_bIsDefaultCase).getToString();
    }
}

