/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.jscode;

import com.helger.annotation.style.CodingStyleguideUnaware;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.html.js.IHasJSCode;
import com.helger.html.js.IHasJSCodeWithSettings;
import com.helger.html.js.IJSWriterSettings;
import com.helger.html.jscode.AbstractJSBlock;
import com.helger.html.jscode.AbstractJSVariable;
import com.helger.html.jscode.IJSDeclaration;
import com.helger.html.jscode.IJSGeneratable;
import com.helger.html.jscode.IJSStatement;
import com.helger.html.jscode.JSBreak;
import com.helger.html.jscode.JSContinue;
import com.helger.html.jscode.JSFormatter;
import com.helger.html.jscode.JSLabel;
import com.helger.html.jscode.JSPrinter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public class JSBlock
extends AbstractJSBlock<JSBlock>
implements IJSGeneratable,
IJSStatement {
    public static final boolean DEFAULT_BRACES_REQUIRED = true;
    public static final boolean DEFAULT_INDENT_REQUIRED = true;
    public static final boolean DEFAULT_NEWLINE_AT_END = true;
    private boolean m_bBracesRequired;
    private boolean m_bIndentRequired;
    private boolean m_bNewLineAtEnd = true;

    public JSBlock() {
        this(true, true);
    }

    public JSBlock(boolean bl, boolean bl2) {
        this.m_bBracesRequired = bl;
        this.m_bIndentRequired = bl2;
    }

    public boolean bracesRequired() {
        return this.m_bBracesRequired;
    }

    public boolean indentRequired() {
        return this.m_bIndentRequired;
    }

    public boolean newlineAtEnd() {
        return this.m_bNewLineAtEnd;
    }

    @Nonnull
    public JSBlock newlineAtEnd(boolean bl) {
        this.m_bNewLineAtEnd = bl;
        return this;
    }

    @Override
    protected void onAddDeclaration(@Nonnull IJSDeclaration iJSDeclaration) {
        if (iJSDeclaration instanceof AbstractJSVariable) {
            this.m_bBracesRequired = true;
            this.m_bIndentRequired = true;
        }
    }

    @Nonnull
    @CodingStyleguideUnaware
    public JSBlock _break() {
        return this._break(null);
    }

    @Nonnull
    @CodingStyleguideUnaware
    public JSBlock _break(@Nullable JSLabel jSLabel) {
        this.addStatement(new JSBreak(jSLabel));
        return this;
    }

    @Nonnull
    @CodingStyleguideUnaware
    public JSBlock _continue() {
        return this._continue(null);
    }

    @Nonnull
    @CodingStyleguideUnaware
    public JSBlock _continue(@Nullable JSLabel jSLabel) {
        this.addStatement(new JSContinue(jSLabel));
        return this;
    }

    @Override
    public void generate(@Nonnull JSFormatter jSFormatter) {
        if (this.m_bBracesRequired) {
            jSFormatter.plain('{').nl();
        }
        if (this.m_bIndentRequired) {
            jSFormatter.indent();
        }
        this.generateBody(jSFormatter);
        if (this.m_bIndentRequired) {
            jSFormatter.outdent();
        }
        if (this.m_bBracesRequired) {
            jSFormatter.plain('}');
        }
    }

    void generateBody(@Nonnull JSFormatter jSFormatter) {
        for (IHasJSCode iHasJSCode : this.directMembers()) {
            if (iHasJSCode instanceof IJSDeclaration) {
                jSFormatter.decl((IJSDeclaration)iHasJSCode);
                continue;
            }
            if (iHasJSCode instanceof IJSStatement) {
                jSFormatter.stmt((IJSStatement)iHasJSCode);
                continue;
            }
            if (iHasJSCode instanceof IHasJSCodeWithSettings) {
                jSFormatter.plain(((IHasJSCodeWithSettings)iHasJSCode).getJSCode(jSFormatter.getSettings()));
                continue;
            }
            jSFormatter.plain(iHasJSCode.getJSCode());
        }
    }

    @Override
    public void state(@Nonnull JSFormatter jSFormatter) {
        jSFormatter.generatable(this);
        if (this.m_bBracesRequired && this.m_bNewLineAtEnd) {
            jSFormatter.nl();
        }
    }

    @Nullable
    public String getJSCode(@Nullable IJSWriterSettings iJSWriterSettings) {
        return JSPrinter.getAsString(iJSWriterSettings, this);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        JSBlock jSBlock = (JSBlock)object;
        return this.m_bBracesRequired == jSBlock.m_bBracesRequired && this.m_bIndentRequired == jSBlock.m_bIndentRequired && this.m_bNewLineAtEnd == jSBlock.m_bNewLineAtEnd;
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived((int)super.hashCode()).append(this.m_bBracesRequired).append(this.m_bIndentRequired).append(this.m_bNewLineAtEnd).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("bracesRequired", this.m_bBracesRequired).append("identRequired", this.m_bIndentRequired).append("newLineAtEnd", this.m_bNewLineAtEnd).getToString();
    }
}

