/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.jscode;

import com.helger.annotation.concurrent.Immutable;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.html.jscode.AbstractJSAtomNumeric;
import com.helger.html.jscode.JSFormatter;
import jakarta.annotation.Nonnull;

@Immutable
public class JSAtomDecimal
extends AbstractJSAtomNumeric {
    private final double m_dValue;

    public JSAtomDecimal(float f) {
        this.m_dValue = f;
    }

    public JSAtomDecimal(double d) {
        this.m_dValue = d;
    }

    @Override
    public boolean isDecimalValue() {
        return true;
    }

    @Override
    public double doubleValue() {
        return this.m_dValue;
    }

    @Override
    @Nonnull
    public AbstractJSAtomNumeric numericMinus() {
        return new JSAtomDecimal(-this.m_dValue);
    }

    @Override
    @Nonnull
    public AbstractJSAtomNumeric numericIncr() {
        return new JSAtomDecimal(this.m_dValue + 1.0);
    }

    @Override
    @Nonnull
    public AbstractJSAtomNumeric numericDecr() {
        return new JSAtomDecimal(this.m_dValue - 1.0);
    }

    @Override
    @Nonnull
    public AbstractJSAtomNumeric numericPlus(@Nonnull AbstractJSAtomNumeric abstractJSAtomNumeric) {
        return new JSAtomDecimal(this.m_dValue + abstractJSAtomNumeric.doubleValue());
    }

    @Override
    @Nonnull
    public AbstractJSAtomNumeric numericMinus(@Nonnull AbstractJSAtomNumeric abstractJSAtomNumeric) {
        return new JSAtomDecimal(this.m_dValue - abstractJSAtomNumeric.doubleValue());
    }

    @Override
    @Nonnull
    public AbstractJSAtomNumeric numericMul(@Nonnull AbstractJSAtomNumeric abstractJSAtomNumeric) {
        return new JSAtomDecimal(this.m_dValue * abstractJSAtomNumeric.doubleValue());
    }

    @Override
    @Nonnull
    public AbstractJSAtomNumeric numericDiv(@Nonnull AbstractJSAtomNumeric abstractJSAtomNumeric) {
        return new JSAtomDecimal(this.m_dValue / abstractJSAtomNumeric.doubleValue());
    }

    @Override
    @Nonnull
    public AbstractJSAtomNumeric numericMod(@Nonnull AbstractJSAtomNumeric abstractJSAtomNumeric) {
        return new JSAtomDecimal(this.m_dValue % abstractJSAtomNumeric.doubleValue());
    }

    public double getContainedValue() {
        return this.m_dValue;
    }

    @Override
    public void generate(@Nonnull JSFormatter jSFormatter) {
        jSFormatter.plain(Double.toString(this.m_dValue));
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        JSAtomDecimal jSAtomDecimal = (JSAtomDecimal)object;
        return EqualsHelper.equals((double)this.m_dValue, (double)jSAtomDecimal.m_dValue);
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived((int)super.hashCode()).append(this.m_dValue).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("value", this.m_dValue).getToString();
    }
}

