/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.jscode;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.html.jscode.AbstractJSExpression;
import com.helger.html.jscode.JSFormatter;
import jakarta.annotation.Nonnull;

@Immutable
public class JSAtom
extends AbstractJSExpression {
    private final String m_sAtom;

    public JSAtom(@Nonnull @Nonempty String string) {
        this.m_sAtom = (String)ValueEnforcer.notEmpty((CharSequence)string, (String)"Atom");
    }

    @Nonnull
    @Nonempty
    public String getContainedAtom() {
        return this.m_sAtom;
    }

    @Override
    public void generate(@Nonnull JSFormatter jSFormatter) {
        jSFormatter.plain(this.m_sAtom);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        JSAtom jSAtom = (JSAtom)object;
        return this.m_sAtom.equals(jSAtom.m_sAtom);
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived((int)super.hashCode()).append((Object)this.m_sAtom).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("atom", (Object)this.m_sAtom).getToString();
    }
}

