/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.jscode;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.iface.IHasSize;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsLinkedHashMap;
import com.helger.collection.commons.ICommonsOrderedMap;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.render.HCRenderer;
import com.helger.html.js.JSMarshaller;
import com.helger.html.jscode.AbstractJSExpression;
import com.helger.html.jscode.IJSExpression;
import com.helger.html.jscode.IJSGeneratable;
import com.helger.html.jscode.JSAtom;
import com.helger.html.jscode.JSExpr;
import com.helger.html.jscode.JSFormatter;
import com.helger.json.IJson;
import com.helger.json.IJsonObject;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Map;
import java.util.function.BooleanSupplier;
import java.util.function.DoublePredicate;
import java.util.function.Function;
import java.util.function.IntPredicate;
import java.util.function.LongPredicate;
import java.util.function.Predicate;

public class JSAssocArray
extends AbstractJSExpression
implements IHasSize {
    public static final boolean DEFAULT_FORCE_QUOTING_NAMES = false;
    private ICommonsOrderedMap<IJSExpression, IJSExpression> m_aExprs;
    private boolean m_bForceQuotingNames = false;

    public boolean isForceQuotingNames() {
        return this.m_bForceQuotingNames;
    }

    @Nonnull
    public JSAssocArray setForceQuotingNames(boolean bl) {
        this.m_bForceQuotingNames = bl;
        return this;
    }

    @Nonnull
    public final IJSExpression getKey(@Nonnull String string) {
        if (!this.m_bForceQuotingNames && JSMarshaller.isJSIdentifier((String)string)) {
            return new JSAtom(string);
        }
        return JSExpr.lit(string);
    }

    @Nonnegative
    public int size() {
        return this.m_aExprs == null ? 0 : this.m_aExprs.size();
    }

    public boolean isEmpty() {
        return this.m_aExprs == null || this.m_aExprs.isEmpty();
    }

    public boolean isNotEmpty() {
        return this.m_aExprs != null && this.m_aExprs.isNotEmpty();
    }

    @Nonnull
    public JSAssocArray add(@Nonnull String string, boolean bl) {
        return this.add(string, (IJSExpression)JSExpr.lit(bl));
    }

    @Nonnull
    public JSAssocArray add(@Nonnull String string, char c) {
        return this.add(string, (IJSExpression)JSExpr.lit(c));
    }

    @Nonnull
    public JSAssocArray add(@Nonnull String string, double d) {
        return this.add(string, (IJSExpression)JSExpr.lit(d));
    }

    @Nonnull
    public JSAssocArray add(@Nonnull String string, float f) {
        return this.add(string, (IJSExpression)JSExpr.lit(f));
    }

    @Nonnull
    public JSAssocArray add(@Nonnull String string, int n) {
        return this.add(string, (IJSExpression)JSExpr.lit(n));
    }

    @Nonnull
    public JSAssocArray add(@Nonnull String string, long l) {
        return this.add(string, (IJSExpression)JSExpr.lit(l));
    }

    @Nonnull
    public JSAssocArray add(@Nonnull String string, @Nullable BigDecimal bigDecimal) {
        return this.add(string, bigDecimal == null ? JSExpr.NULL : JSExpr.lit(bigDecimal));
    }

    @Nonnull
    public JSAssocArray add(@Nonnull String string, @Nullable BigInteger bigInteger) {
        return this.add(string, bigInteger == null ? JSExpr.NULL : JSExpr.lit(bigInteger));
    }

    @Nonnull
    public JSAssocArray add(@Nonnull String string, @Nullable String string2) {
        return this.add(string, string2 == null ? JSExpr.NULL : JSExpr.lit(string2));
    }

    @Nonnull
    public JSAssocArray addIfNotNull(@Nonnull String string, @Nullable String string2) {
        if (string2 != null) {
            return this.add(string, (IJSExpression)JSExpr.lit(string2));
        }
        return this;
    }

    @Nonnull
    public JSAssocArray add(@Nonnull String string, @Nullable IJson iJson) {
        return this.add(string, iJson == null ? JSExpr.NULL : JSExpr.json(iJson));
    }

    @Nonnull
    public JSAssocArray add(@Nonnull String string, @Nullable IHCNode iHCNode) {
        return this.add(string, iHCNode == null ? null : HCRenderer.getAsHTMLStringWithoutNamespaces((IHCNode)iHCNode));
    }

    @Nonnull
    public JSAssocArray addAllStrings(@Nullable Map<String, String> map) {
        if (map != null) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                this.add(entry.getKey(), entry.getValue());
            }
        }
        return this;
    }

    @Nonnull
    public JSAssocArray addAll(@Nullable Map<String, IJSExpression> map) {
        if (map != null) {
            for (Map.Entry<String, IJSExpression> entry : map.entrySet()) {
                this.add(entry.getKey(), entry.getValue());
            }
        }
        return this;
    }

    @Nonnull
    public <T> JSAssocArray addAll(@Nonnull Iterable<? extends T> iterable, @Nonnull Function<? super T, String> function, @Nonnull Function<? super T, IJSExpression> function2) {
        for (T t : iterable) {
            this.add(function.apply(t), function2.apply(t));
        }
        return this;
    }

    @Nonnull
    public JSAssocArray add(@Nonnull String string, @Nonnull IJSExpression iJSExpression) {
        return this.add(this.getKey(string), iJSExpression);
    }

    @Nonnull
    public <T extends IJSExpression> JSAssocArray addIf(@Nonnull String string, @Nonnull T t, @Nonnull BooleanSupplier booleanSupplier) {
        if (booleanSupplier.getAsBoolean()) {
            return this.add(this.getKey(string), t);
        }
        return this;
    }

    @Nonnull
    public <T extends IJSExpression> JSAssocArray addIf(@Nonnull String string, @Nonnull T t, @Nonnull Predicate<? super T> predicate) {
        if (predicate.test(t)) {
            return this.add(this.getKey(string), t);
        }
        return this;
    }

    @Nonnull
    public JSAssocArray addIf(@Nonnull String string, int n, @Nonnull IntPredicate intPredicate) {
        if (intPredicate.test(n)) {
            return this.add(string, n);
        }
        return this;
    }

    @Nonnull
    public JSAssocArray addIf(@Nonnull String string, long l, @Nonnull LongPredicate longPredicate) {
        if (longPredicate.test(l)) {
            return this.add(string, l);
        }
        return this;
    }

    @Nonnull
    public JSAssocArray addIf(@Nonnull String string, double d, @Nonnull DoublePredicate doublePredicate) {
        if (doublePredicate.test(d)) {
            return this.add(string, d);
        }
        return this;
    }

    @Nonnull
    public JSAssocArray add(@Nonnull IJSExpression iJSExpression, @Nonnull IJSExpression iJSExpression2) {
        ValueEnforcer.notNull((Object)iJSExpression, (String)"Key");
        ValueEnforcer.notNull((Object)iJSExpression2, (String)"Value");
        if (this.m_aExprs == null) {
            this.m_aExprs = new CommonsLinkedHashMap();
        }
        this.m_aExprs.put((Object)iJSExpression, (Object)iJSExpression2);
        return this;
    }

    @Nonnull
    public JSAssocArray addAll(@Nonnull IJsonObject iJsonObject) {
        for (Map.Entry entry : iJsonObject) {
            this.add((String)entry.getKey(), JSExpr.json((IJson)entry.getValue()));
        }
        return this;
    }

    @Nonnull
    public JSAssocArray remove(@Nonnull String string) {
        if (this.m_aExprs != null) {
            this.remove(this.getKey(string));
        }
        return this;
    }

    @Nonnull
    public JSAssocArray remove(@Nullable IJSExpression iJSExpression) {
        if (this.m_aExprs != null) {
            this.m_aExprs.remove((Object)iJSExpression);
        }
        return this;
    }

    @Nullable
    public IJSExpression get(@Nullable String string) {
        if (string == null) {
            return null;
        }
        return this.get(this.getKey(string));
    }

    @Nullable
    public IJSExpression get(@Nullable IJSExpression iJSExpression) {
        if (this.m_aExprs == null) {
            return null;
        }
        return (IJSExpression)this.m_aExprs.get((Object)iJSExpression);
    }

    @Nullable
    public IJSExpression computeIfAbsent(@Nullable String string, @Nonnull Function<IJSExpression, IJSExpression> function) {
        if (string == null) {
            return null;
        }
        return this.computeIfAbsent(this.getKey(string), function);
    }

    @Nullable
    public IJSExpression computeIfAbsent(@Nullable IJSExpression iJSExpression, @Nonnull Function<IJSExpression, IJSExpression> function) {
        if (this.m_aExprs == null) {
            this.m_aExprs = new CommonsLinkedHashMap();
        }
        return (IJSExpression)this.m_aExprs.computeIfAbsent((Object)iJSExpression, function);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedMap<IJSExpression, IJSExpression> getAll() {
        return new CommonsLinkedHashMap(this.m_aExprs);
    }

    @Override
    public void generate(@Nonnull JSFormatter jSFormatter) {
        jSFormatter.plain('{');
        if (this.m_aExprs != null && this.m_aExprs.isNotEmpty()) {
            jSFormatter.nl().indent();
            boolean bl = true;
            for (Map.Entry entry : this.m_aExprs.entrySet()) {
                if (bl) {
                    bl = false;
                } else {
                    jSFormatter.plain(',').nl();
                }
                jSFormatter.generatable((IJSGeneratable)entry.getKey()).plain(':').generatable((IJSGeneratable)entry.getValue());
            }
            jSFormatter.nl().outdent();
        }
        jSFormatter.plain('}');
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        JSAssocArray jSAssocArray = (JSAssocArray)object;
        return EqualsHelper.equals(this.m_aExprs, jSAssocArray.m_aExprs);
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived((int)super.hashCode()).append(this.m_aExprs).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("Exprs", this.m_aExprs).append("ForceQuotingNames", this.m_bForceQuotingNames).getToString();
    }
}

