/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.jscode;

import com.helger.annotation.Nonempty;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.html.js.IJSWriterSettings;
import com.helger.html.jscode.AbstractJSExpression;
import com.helger.html.jscode.IJSAssignmentTarget;
import com.helger.html.jscode.IJSExpression;
import com.helger.html.jscode.IJSStatement;
import com.helger.html.jscode.JSFormatter;
import com.helger.html.jscode.JSPrinter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public class JSAssignment
extends AbstractJSExpression
implements IJSStatement {
    private final IJSAssignmentTarget m_aLhs;
    private final String m_sOp;
    private final IJSExpression m_aRhs;

    public JSAssignment(@Nonnull IJSAssignmentTarget iJSAssignmentTarget, @Nonnull @Nonempty String string, @Nonnull IJSExpression iJSExpression) {
        this.m_aLhs = (IJSAssignmentTarget)ValueEnforcer.notNull((Object)iJSAssignmentTarget, (String)"Lhs");
        this.m_sOp = (String)ValueEnforcer.notEmpty((CharSequence)string, (String)"Operator");
        this.m_aRhs = (IJSExpression)ValueEnforcer.notNull((Object)iJSExpression, (String)"Rhs");
    }

    @Nonnull
    public IJSAssignmentTarget lhs() {
        return this.m_aLhs;
    }

    @Nonnull
    @Nonempty
    public String operator() {
        return this.m_sOp;
    }

    @Nonnull
    public IJSExpression rhs() {
        return this.m_aRhs;
    }

    @Override
    public void generate(@Nonnull JSFormatter jSFormatter) {
        jSFormatter.generatable(this.m_aLhs).plain(this.m_sOp).generatable(this.m_aRhs);
    }

    @Override
    public void state(@Nonnull JSFormatter jSFormatter) {
        jSFormatter.generatable(this).plain(';').nl();
    }

    @Override
    @Nonnull
    public String getJSCode(@Nullable IJSWriterSettings iJSWriterSettings) {
        return JSPrinter.getAsString(iJSWriterSettings, this);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        JSAssignment jSAssignment = (JSAssignment)object;
        return this.m_aLhs.equals(jSAssignment.m_aLhs) && this.m_sOp.equals(jSAssignment.m_sOp) && this.m_aRhs.equals(jSAssignment.m_aRhs);
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived((int)super.hashCode()).append((Object)this.m_aLhs).append((Object)this.m_sOp).append((Object)this.m_aRhs).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("lhs", (Object)this.m_aLhs).append("op", (Object)this.m_sOp).append("rhs", (Object)this.m_aRhs).getToString();
    }
}

