/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.jscode;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.trait.IGenericImplTrait;
import com.helger.collection.commons.ICommonsList;
import com.helger.html.EHTMLElement;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.render.HCRenderer;
import com.helger.html.jscode.IJSExpression;
import com.helger.html.jscode.IJSStatement;
import com.helger.html.jscode.JSExpr;
import com.helger.json.IJson;
import com.helger.xml.microdom.IMicroQName;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.math.BigDecimal;
import java.math.BigInteger;

public interface IJSInvocation<IMPLTYPE extends IJSInvocation<IMPLTYPE>>
extends IJSExpression,
IJSStatement,
IGenericImplTrait<IMPLTYPE> {
    @Nonnull
    public IMPLTYPE arg(@Nonnull IJSExpression var1);

    @Nonnull
    default public IMPLTYPE arg(boolean bl) {
        return this.arg(JSExpr.lit(bl));
    }

    @Nonnull
    default public IMPLTYPE arg(char c) {
        return this.arg(JSExpr.lit(c));
    }

    @Nonnull
    default public IMPLTYPE arg(double d) {
        return this.arg(JSExpr.lit(d));
    }

    @Nonnull
    default public IMPLTYPE arg(float f) {
        return this.arg(JSExpr.lit(f));
    }

    @Nonnull
    default public IMPLTYPE arg(int n) {
        return this.arg(JSExpr.lit(n));
    }

    @Nonnull
    default public IMPLTYPE arg(long l) {
        return this.arg(JSExpr.lit(l));
    }

    @Nonnull
    default public IMPLTYPE argOrNull(@Nullable IJSExpression iJSExpression) {
        return iJSExpression == null ? this.argNull() : this.arg(iJSExpression);
    }

    @Nonnull
    default public IMPLTYPE argOrNull(@Nullable Integer n) {
        return n == null ? this.argNull() : this.arg(n);
    }

    @Nonnull
    default public IMPLTYPE argOrNull(@Nullable Long l) {
        return l == null ? this.argNull() : this.arg(l);
    }

    @Nonnull
    default public IMPLTYPE arg(@Nullable String string) {
        return string == null ? this.argNull() : this.arg(JSExpr.lit(string));
    }

    @Nonnull
    default public IMPLTYPE arg(@Nullable IJson iJson) {
        return iJson == null ? this.argNull() : this.arg(JSExpr.json(iJson));
    }

    @Nonnull
    default public IMPLTYPE arg(@Nullable IMicroQName iMicroQName) {
        return iMicroQName == null ? this.argNull() : this.arg(JSExpr.lit(iMicroQName.getName()));
    }

    @Nonnull
    default public IMPLTYPE arg(@Nullable BigDecimal bigDecimal) {
        return bigDecimal == null ? this.argNull() : this.arg(JSExpr.lit(bigDecimal));
    }

    @Nonnull
    default public IMPLTYPE arg(@Nullable BigInteger bigInteger) {
        return bigInteger == null ? this.argNull() : this.arg(JSExpr.lit(bigInteger));
    }

    @Nonnull
    default public IMPLTYPE arg(EHTMLElement ... eHTMLElementArray) {
        if (eHTMLElementArray == null) {
            return this.argNull();
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (EHTMLElement eHTMLElement : eHTMLElementArray) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(eHTMLElement.getElementName());
        }
        return this.arg(stringBuilder.toString());
    }

    @Nonnull
    default public IMPLTYPE arg(@Nullable Iterable<EHTMLElement> iterable) {
        if (iterable == null) {
            return this.argNull();
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (EHTMLElement eHTMLElement : iterable) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(eHTMLElement.getElementName());
        }
        return this.arg(stringBuilder.toString());
    }

    @Nonnull
    default public IMPLTYPE arg(String ... stringArray) {
        if (stringArray == null) {
            return this.argNull();
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : stringArray) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(string);
        }
        return this.arg(stringBuilder.toString());
    }

    @Nonnull
    default public IMPLTYPE arg(@Nullable IHCNode iHCNode) {
        return iHCNode == null ? this.argNull() : this.arg(HCRenderer.getAsHTMLStringWithoutNamespaces((IHCNode)iHCNode));
    }

    @Nonnull
    default public IMPLTYPE argNull() {
        return this.arg(JSExpr.NULL);
    }

    @Nonnull
    default public IMPLTYPE argThis() {
        return this.arg(JSExpr.THIS);
    }

    @Nonnull
    default public IMPLTYPE argOrNull(@Nonnegative int n, @Nullable IJSExpression iJSExpression) {
        return iJSExpression == null ? this.argNull(n) : this.arg(n, iJSExpression);
    }

    @Nonnull
    public IMPLTYPE arg(@Nonnegative int var1, @Nonnull IJSExpression var2);

    @Nonnull
    default public IMPLTYPE arg(@Nonnegative int n, boolean bl) {
        return this.arg(n, JSExpr.lit(bl));
    }

    @Nonnull
    default public IMPLTYPE arg(@Nonnegative int n, char c) {
        return this.arg(n, JSExpr.lit(c));
    }

    @Nonnull
    default public IMPLTYPE arg(@Nonnegative int n, double d) {
        return this.arg(n, JSExpr.lit(d));
    }

    @Nonnull
    default public IMPLTYPE arg(@Nonnegative int n, float f) {
        return this.arg(n, JSExpr.lit(f));
    }

    @Nonnull
    default public IMPLTYPE arg(@Nonnegative int n, int n2) {
        return this.arg(n, JSExpr.lit(n2));
    }

    @Nonnull
    default public IMPLTYPE arg(@Nonnegative int n, long l) {
        return this.arg(n, JSExpr.lit(l));
    }

    @Nonnull
    default public IMPLTYPE arg(@Nonnegative int n, @Nullable Integer n2) {
        return n2 == null ? this.argNull(n) : this.arg(n, (int)n2);
    }

    @Nonnull
    default public IMPLTYPE arg(@Nonnegative int n, @Nullable Long l) {
        return l == null ? this.argNull(n) : this.arg(n, (long)l);
    }

    @Nonnull
    default public IMPLTYPE arg(@Nonnegative int n, @Nullable String string) {
        return string == null ? this.argNull(n) : this.arg(n, JSExpr.lit(string));
    }

    @Nonnull
    default public IMPLTYPE arg(@Nonnegative int n, @Nullable IJson iJson) {
        return iJson == null ? this.argNull(n) : this.arg(n, JSExpr.json(iJson));
    }

    @Nonnull
    default public IMPLTYPE argNull(@Nonnegative int n) {
        return this.arg(n, JSExpr.NULL);
    }

    @Nonnull
    default public IMPLTYPE argThis(@Nonnegative int n) {
        return this.arg(n, JSExpr.THIS);
    }

    @Nonnull
    default public IMPLTYPE args(@Nullable Iterable<? extends IJSExpression> iterable) {
        if (iterable != null) {
            for (IJSExpression iJSExpression : iterable) {
                this.arg(iJSExpression);
            }
        }
        return (IMPLTYPE)((IJSInvocation)this.thisAsT());
    }

    @Nonnull
    default public IMPLTYPE args(IJSExpression ... iJSExpressionArray) {
        if (iJSExpressionArray != null) {
            for (IJSExpression iJSExpression : iJSExpressionArray) {
                this.arg(iJSExpression);
            }
        }
        return (IMPLTYPE)((IJSInvocation)this.thisAsT());
    }

    @Nonnull
    default public IMPLTYPE argsOrNull(@Nullable Iterable<? extends IJSExpression> iterable) {
        if (iterable != null) {
            for (IJSExpression iJSExpression : iterable) {
                this.argOrNull(iJSExpression);
            }
        }
        return (IMPLTYPE)((IJSInvocation)this.thisAsT());
    }

    @Nonnull
    default public IMPLTYPE argssOrNull(IJSExpression ... iJSExpressionArray) {
        if (iJSExpressionArray != null) {
            for (IJSExpression iJSExpression : iJSExpressionArray) {
                this.argOrNull(iJSExpression);
            }
        }
        return (IMPLTYPE)((IJSInvocation)this.thisAsT());
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IJSExpression> args();

    @Nonnegative
    public int getArgCount();

    public boolean hasArgs();

    @Nullable
    public IJSExpression getArgAtIndex(int var1);

    @Nonnull
    public IMPLTYPE removeAllArgs();
}

