/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.jscode;

import com.helger.annotation.Nonempty;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.base.trait.IGenericImplTrait;
import com.helger.html.js.IJSWriterSettings;
import com.helger.html.js.JSMarshaller;
import com.helger.html.jscode.AbstractJSAssignmentTarget;
import com.helger.html.jscode.IJSDeclaration;
import com.helger.html.jscode.IJSExpression;
import com.helger.html.jscode.JSFormatter;
import com.helger.html.jscode.JSPrinter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public abstract class AbstractJSVariable<IMPLTYPE extends AbstractJSVariable<IMPLTYPE>>
extends AbstractJSAssignmentTarget
implements IJSDeclaration,
IGenericImplTrait<IMPLTYPE> {
    private final EJSVarMode m_eMode;
    private String m_sName;
    private IJSExpression m_aInit;

    protected AbstractJSVariable(@Nonnull EJSVarMode eJSVarMode, @Nonnull @Nonempty String string, @Nullable IJSExpression iJSExpression) {
        ValueEnforcer.notNull((Object)((Object)eJSVarMode), (String)"Mode");
        ValueEnforcer.isTrue(() -> JSMarshaller.isJSIdentifier((String)string), () -> "The name '" + string + "' is not a legal JS identifier!");
        this.m_eMode = eJSVarMode;
        this.m_sName = string;
        this.m_aInit = iJSExpression;
    }

    @Nonnull
    public final EJSVarMode getJSVarMode() {
        return this.m_eMode;
    }

    @Override
    @Nonnull
    @Nonempty
    public final String name() {
        return this.m_sName;
    }

    @Nonnull
    public IMPLTYPE name(@Nonnull @Nonempty String string) {
        if (!JSMarshaller.isJSIdentifier((String)string)) {
            throw new IllegalArgumentException("The name '" + string + "' is not a legal JS identifier!");
        }
        this.m_sName = string;
        return (IMPLTYPE)((AbstractJSVariable)this.thisAsT());
    }

    public final boolean hasInit() {
        return this.m_aInit != null;
    }

    @Nullable
    public final IJSExpression init() {
        return this.m_aInit;
    }

    @Nonnull
    public IMPLTYPE init(@Nullable IJSExpression iJSExpression) {
        this.m_aInit = iJSExpression;
        return (IMPLTYPE)((AbstractJSVariable)this.thisAsT());
    }

    public void bind(@Nonnull JSFormatter jSFormatter) {
        jSFormatter.plain(this.m_sName);
        if (this.m_aInit != null) {
            jSFormatter.plain('=').generatable(this.m_aInit);
        }
    }

    @Override
    public void declare(@Nonnull JSFormatter jSFormatter) {
        jSFormatter.plain(this.m_eMode.getCode());
        this.bind(jSFormatter);
        jSFormatter.plain(';').nl();
    }

    @Override
    public void generate(@Nonnull JSFormatter jSFormatter) {
        jSFormatter.plain(this.m_sName);
    }

    @Override
    @Nonnull
    public String getJSCode(@Nullable IJSWriterSettings iJSWriterSettings) {
        return JSPrinter.getAsString(iJSWriterSettings, this);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        AbstractJSVariable abstractJSVariable = (AbstractJSVariable)object;
        return this.m_eMode.equals((Object)abstractJSVariable.m_eMode) && EqualsHelper.equals((Object)this.m_sName, (Object)abstractJSVariable.m_sName) && EqualsHelper.equals((Object)this.m_aInit, (Object)abstractJSVariable.m_aInit);
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived((int)super.hashCode()).append((Object)this.m_eMode).append((Object)this.m_sName).append((Object)this.m_aInit).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("Mode", (Enum)this.m_eMode).append("Name", (Object)this.m_sName).appendIfNotNull("Init", (Object)this.m_aInit).getToString();
    }

    public static enum EJSVarMode {
        VAR("var "),
        LET("let "),
        CONST("const "),
        PARAM("");

        private final String m_sCode;

        private EJSVarMode(String string2) {
            this.m_sCode = string2;
        }

        @Nonnull
        public String getCode() {
            return this.m_sCode;
        }
    }
}

