/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.jscode;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.style.CodingStyleguideUnaware;
import com.helger.annotation.style.OverrideOnDemand;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.annotation.style.ReturnsMutableObject;
import com.helger.base.debug.GlobalDebug;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.lang.clazz.ClassHelper;
import com.helger.base.numeric.MathHelper;
import com.helger.base.state.EChange;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.base.trait.IGenericImplTrait;
import com.helger.collection.CollectionHelper;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.CommonsHashMap;
import com.helger.collection.commons.ICommonsList;
import com.helger.collection.commons.ICommonsMap;
import com.helger.html.js.CollectingJSCodeProvider;
import com.helger.html.js.IHasJSCode;
import com.helger.html.js.IHasJSCodeWithSettings;
import com.helger.html.jscode.AbstractJSClass;
import com.helger.html.jscode.AbstractJSType;
import com.helger.html.jscode.IJSAssignmentTarget;
import com.helger.html.jscode.IJSDeclaration;
import com.helger.html.jscode.IJSExpression;
import com.helger.html.jscode.IJSFunctionContainer;
import com.helger.html.jscode.IJSStatement;
import com.helger.html.jscode.JSAnonymousFunction;
import com.helger.html.jscode.JSBlock;
import com.helger.html.jscode.JSCommentSingleLine;
import com.helger.html.jscode.JSConditional;
import com.helger.html.jscode.JSConst;
import com.helger.html.jscode.JSDebugger;
import com.helger.html.jscode.JSDecrPostfix;
import com.helger.html.jscode.JSDecrPrefix;
import com.helger.html.jscode.JSDefinedClass;
import com.helger.html.jscode.JSDelete;
import com.helger.html.jscode.JSDoLoop;
import com.helger.html.jscode.JSExpr;
import com.helger.html.jscode.JSForIn;
import com.helger.html.jscode.JSForLoop;
import com.helger.html.jscode.JSFunction;
import com.helger.html.jscode.JSIncrPostfix;
import com.helger.html.jscode.JSIncrPrefix;
import com.helger.html.jscode.JSInvocation;
import com.helger.html.jscode.JSLabel;
import com.helger.html.jscode.JSLet;
import com.helger.html.jscode.JSMethod;
import com.helger.html.jscode.JSNameAlreadyExistsException;
import com.helger.html.jscode.JSPackage;
import com.helger.html.jscode.JSReturn;
import com.helger.html.jscode.JSSwitch;
import com.helger.html.jscode.JSThrow;
import com.helger.html.jscode.JSTryBlock;
import com.helger.html.jscode.JSVar;
import com.helger.html.jscode.JSWhileLoop;
import com.helger.json.IJson;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@CodingStyleguideUnaware
public abstract class AbstractJSBlock<IMPLTYPE extends AbstractJSBlock<IMPLTYPE>>
implements IJSFunctionContainer,
IGenericImplTrait<IMPLTYPE> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractJSBlock.class);
    private final ICommonsList<IHasJSCode> m_aObjs = new CommonsArrayList();
    private final ICommonsMap<String, IJSDeclaration> m_aDecls = new CommonsHashMap();
    private int m_nPos = 0;

    @Nonnull
    public EChange removeByName(String string) {
        IJSDeclaration iJSDeclaration = (IJSDeclaration)this.m_aDecls.remove((Object)string);
        if (iJSDeclaration == null) {
            return EChange.UNCHANGED;
        }
        this.m_aObjs.remove((Object)iJSDeclaration);
        return EChange.CHANGED;
    }

    @Nonnull
    @ReturnsMutableObject
    public ICommonsMap<String, IJSDeclaration> directDeclarations() {
        return this.m_aDecls;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IJSDeclaration> getAllDeclarations() {
        return this.m_aDecls.copyOfValues();
    }

    @Nullable
    public IJSDeclaration getDeclaration(@Nullable String string) {
        return (IJSDeclaration)this.m_aDecls.get((Object)string);
    }

    public boolean isDeclared(@Nullable String string) {
        return this.m_aDecls.containsKey((Object)string);
    }

    public boolean isEmpty() {
        return this.m_aObjs.isEmpty();
    }

    @Nonnegative
    public int memberCount() {
        return this.m_aObjs.size();
    }

    @Nonnull
    @ReturnsMutableObject(value="speed")
    final ICommonsList<IHasJSCode> directMembers() {
        return this.m_aObjs;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IHasJSCode> getAllMembers() {
        return (ICommonsList)this.m_aObjs.getClone();
    }

    @Nonnull
    public IMPLTYPE clear() {
        this.m_aObjs.clear();
        this.m_aDecls.clear();
        this.m_nPos = 0;
        return (IMPLTYPE)((AbstractJSBlock)this.thisAsT());
    }

    @OverrideOnDemand
    protected void onAddDeclaration(@Nonnull IJSDeclaration iJSDeclaration) {
    }

    @Nonnull
    public final <T extends IJSDeclaration> T addDeclaration(@Nonnull T t) {
        ValueEnforcer.notNull(t, (String)"Declaration");
        String string = t.name();
        IJSDeclaration iJSDeclaration = (IJSDeclaration)this.m_aDecls.get((Object)string);
        if (iJSDeclaration != null) {
            throw new JSNameAlreadyExistsException(iJSDeclaration);
        }
        this.m_aObjs.add(this.m_nPos, t);
        this.m_aDecls.put((Object)string, t);
        ++this.m_nPos;
        this.onAddDeclaration(t);
        return t;
    }

    @Nonnull
    public final <T extends IJSStatement> T addStatement(@Nonnull T t) {
        ValueEnforcer.notNull(t, (String)"Statement");
        this.m_aObjs.add(this.m_nPos, t);
        ++this.m_nPos;
        return t;
    }

    @Nonnegative
    public int pos() {
        return this.m_nPos;
    }

    @Nonnegative
    public int pos(@Nonnegative int n) {
        ValueEnforcer.isBetweenInclusive((int)n, (String)"NewPos", (int)0, (int)this.m_aObjs.size());
        int n2 = this.m_nPos;
        this.m_nPos = n;
        return n2;
    }

    @Nonnegative
    public int posEnd() {
        return this.pos(this.m_aObjs.size());
    }

    @Nonnull
    public JSDefinedClass _class(@Nonnull @Nonempty String string) {
        JSDefinedClass jSDefinedClass = new JSDefinedClass(string);
        return this.addDeclaration(jSDefinedClass);
    }

    @Nonnull
    public JSInvocation _new(@Nonnull AbstractJSType abstractJSType) {
        ValueEnforcer.notNull((Object)abstractJSType, (String)"Type");
        return abstractJSType._new();
    }

    @Override
    @Nonnull
    public JSFunction function(@Nonnull String string) {
        JSFunction jSFunction = new JSFunction(string);
        return this.addDeclaration(jSFunction);
    }

    @Nonnull
    public JSVar variable(@Nonnull @Nonempty String string) {
        return this.variable(string, (IJSExpression)null);
    }

    @Nonnull
    public JSVar variable(@Nonnull @Nonempty String string, boolean bl) {
        return this.variable(string, JSExpr.lit(bl));
    }

    @Nonnull
    public JSVar variable(@Nonnull @Nonempty String string, char c) {
        return this.variable(string, JSExpr.lit(c));
    }

    @Nonnull
    public JSVar variable(@Nonnull @Nonempty String string, double d) {
        return this.variable(string, JSExpr.lit(d));
    }

    @Nonnull
    public JSVar variable(@Nonnull @Nonempty String string, float f) {
        return this.variable(string, JSExpr.lit(f));
    }

    @Nonnull
    public JSVar variable(@Nonnull @Nonempty String string, int n) {
        return this.variable(string, JSExpr.lit(n));
    }

    @Nonnull
    public JSVar variable(@Nonnull @Nonempty String string, long l) {
        return this.variable(string, JSExpr.lit(l));
    }

    @Nonnull
    public JSVar variable(@Nonnull @Nonempty String string, @Nullable String string2) {
        return this.variable(string, string2 == null ? JSExpr.NULL : JSExpr.lit(string2));
    }

    @Nonnull
    public JSVar variable(@Nonnull @Nonempty String string, @Nullable IJSExpression iJSExpression) {
        JSVar jSVar = new JSVar(string, iJSExpression);
        return this.addDeclaration(jSVar);
    }

    @Nonnull
    public JSLet let(@Nonnull @Nonempty String string) {
        return this.let(string, (IJSExpression)null);
    }

    @Nonnull
    public JSLet let(@Nonnull @Nonempty String string, boolean bl) {
        return this.let(string, JSExpr.lit(bl));
    }

    @Nonnull
    public JSLet let(@Nonnull @Nonempty String string, char c) {
        return this.let(string, JSExpr.lit(c));
    }

    @Nonnull
    public JSLet let(@Nonnull @Nonempty String string, double d) {
        return this.let(string, JSExpr.lit(d));
    }

    @Nonnull
    public JSLet let(@Nonnull @Nonempty String string, float f) {
        return this.let(string, JSExpr.lit(f));
    }

    @Nonnull
    public JSLet let(@Nonnull @Nonempty String string, int n) {
        return this.let(string, JSExpr.lit(n));
    }

    @Nonnull
    public JSLet let(@Nonnull @Nonempty String string, long l) {
        return this.let(string, JSExpr.lit(l));
    }

    @Nonnull
    public JSLet let(@Nonnull @Nonempty String string, @Nullable String string2) {
        return this.let(string, string2 == null ? JSExpr.NULL : JSExpr.lit(string2));
    }

    @Nonnull
    public JSLet let(@Nonnull @Nonempty String string, @Nullable IJSExpression iJSExpression) {
        JSLet jSLet = new JSLet(string, iJSExpression);
        return this.addDeclaration(jSLet);
    }

    @Nonnull
    public JSConst _const(@Nonnull @Nonempty String string) {
        return this._const(string, (IJSExpression)null);
    }

    @Nonnull
    public JSConst _const(@Nonnull @Nonempty String string, boolean bl) {
        return this._const(string, JSExpr.lit(bl));
    }

    @Nonnull
    public JSConst _const(@Nonnull @Nonempty String string, char c) {
        return this._const(string, JSExpr.lit(c));
    }

    @Nonnull
    public JSConst _const(@Nonnull @Nonempty String string, double d) {
        return this._const(string, JSExpr.lit(d));
    }

    @Nonnull
    public JSConst _const(@Nonnull @Nonempty String string, float f) {
        return this._const(string, JSExpr.lit(f));
    }

    @Nonnull
    public JSConst _const(@Nonnull @Nonempty String string, int n) {
        return this._const(string, JSExpr.lit(n));
    }

    @Nonnull
    public JSConst _const(@Nonnull @Nonempty String string, long l) {
        return this._const(string, JSExpr.lit(l));
    }

    @Nonnull
    public JSConst _const(@Nonnull @Nonempty String string, @Nullable String string2) {
        return this._const(string, string2 == null ? JSExpr.NULL : JSExpr.lit(string2));
    }

    @Nonnull
    public JSConst _const(@Nonnull @Nonempty String string, @Nullable IJSExpression iJSExpression) {
        JSConst jSConst = new JSConst(string, iJSExpression);
        return this.addDeclaration(jSConst);
    }

    @Nonnull
    public JSInvocation invoke(@Nonnull JSAnonymousFunction jSAnonymousFunction) {
        ValueEnforcer.notNull((Object)jSAnonymousFunction, (String)"AnonFunction");
        return this.addStatement(jSAnonymousFunction.invoke());
    }

    @Nonnull
    public JSInvocation invoke(@Nonnull JSFunction jSFunction) {
        ValueEnforcer.notNull((Object)jSFunction, (String)"Function");
        return this.addStatement(jSFunction.invoke());
    }

    @Nonnull
    public JSInvocation invoke(@Nonnull @Nonempty String string) {
        JSInvocation jSInvocation = new JSInvocation(string);
        return this.addStatement(jSInvocation);
    }

    @Nonnull
    public JSInvocation invoke(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2) {
        JSInvocation jSInvocation = JSExpr.ref(string).invoke(string2);
        return this.addStatement(jSInvocation);
    }

    @Nonnull
    public JSInvocation invoke(@Nonnull @Nonempty String string, @Nonnull JSMethod jSMethod) {
        JSInvocation jSInvocation = JSExpr.ref(string).invoke(jSMethod);
        return this.addStatement(jSInvocation);
    }

    @Nonnull
    public JSInvocation invoke(@Nullable IJSExpression iJSExpression, @Nonnull @Nonempty String string) {
        JSInvocation jSInvocation = new JSInvocation(iJSExpression, string);
        return this.addStatement(jSInvocation);
    }

    @Nonnull
    public JSInvocation invoke(@Nullable IJSExpression iJSExpression, @Nonnull JSMethod jSMethod) {
        JSInvocation jSInvocation = new JSInvocation(iJSExpression, jSMethod);
        return this.addStatement(jSInvocation);
    }

    @Nonnull
    public JSInvocation staticInvoke(@Nullable AbstractJSClass abstractJSClass, @Nonnull String string) {
        JSInvocation jSInvocation = new JSInvocation(abstractJSClass, string);
        return this.addStatement(jSInvocation);
    }

    @Nonnull
    public JSInvocation staticInvoke(@Nullable AbstractJSClass abstractJSClass, @Nonnull JSMethod jSMethod) {
        JSInvocation jSInvocation = new JSInvocation(abstractJSClass, jSMethod);
        return this.addStatement(jSInvocation);
    }

    @Nonnull
    public IMPLTYPE assign(@Nonnull IJSAssignmentTarget iJSAssignmentTarget, boolean bl) {
        return this.assign(iJSAssignmentTarget, JSExpr.lit(bl));
    }

    @Nonnull
    public IMPLTYPE assign(@Nonnull IJSAssignmentTarget iJSAssignmentTarget, char c) {
        return this.assign(iJSAssignmentTarget, JSExpr.lit(c));
    }

    @Nonnull
    public IMPLTYPE assign(@Nonnull IJSAssignmentTarget iJSAssignmentTarget, double d) {
        return this.assign(iJSAssignmentTarget, JSExpr.lit(d));
    }

    @Nonnull
    public IMPLTYPE assign(@Nonnull IJSAssignmentTarget iJSAssignmentTarget, float f) {
        return this.assign(iJSAssignmentTarget, JSExpr.lit(f));
    }

    @Nonnull
    public IMPLTYPE assign(@Nonnull IJSAssignmentTarget iJSAssignmentTarget, int n) {
        return this.assign(iJSAssignmentTarget, JSExpr.lit(n));
    }

    @Nonnull
    public IMPLTYPE assign(@Nonnull IJSAssignmentTarget iJSAssignmentTarget, long l) {
        return this.assign(iJSAssignmentTarget, JSExpr.lit(l));
    }

    @Nonnull
    public IMPLTYPE assign(@Nonnull IJSAssignmentTarget iJSAssignmentTarget, @Nonnull String string) {
        return this.assign(iJSAssignmentTarget, string == null ? JSExpr.NULL : JSExpr.lit(string));
    }

    @Nonnull
    public IMPLTYPE assign(@Nonnull IJSAssignmentTarget iJSAssignmentTarget, @Nullable IJson iJson) {
        return this.assign(iJSAssignmentTarget, iJson == null ? JSExpr.NULL : JSExpr.json(iJson));
    }

    @Nonnull
    public IMPLTYPE assign(@Nonnull IJSAssignmentTarget iJSAssignmentTarget, @Nonnull IJSExpression iJSExpression) {
        this.addStatement(iJSAssignmentTarget.assign(iJSExpression));
        return (IMPLTYPE)((AbstractJSBlock)this.thisAsT());
    }

    @Nonnull
    public IMPLTYPE assignPlus(@Nonnull IJSAssignmentTarget iJSAssignmentTarget, char c) {
        return this.assignPlus(iJSAssignmentTarget, JSExpr.lit(c));
    }

    @Nonnull
    public IMPLTYPE assignPlus(@Nonnull IJSAssignmentTarget iJSAssignmentTarget, double d) {
        if (EqualsHelper.equals((double)d, (double)0.0)) {
            return (IMPLTYPE)((AbstractJSBlock)this.thisAsT());
        }
        if (d < 0.0) {
            return this.assignMinus(iJSAssignmentTarget, JSExpr.lit(MathHelper.abs((double)d)));
        }
        return this.assignPlus(iJSAssignmentTarget, JSExpr.lit(d));
    }

    @Nonnull
    public IMPLTYPE assignPlus(@Nonnull IJSAssignmentTarget iJSAssignmentTarget, float f) {
        if (EqualsHelper.equals((float)f, (float)0.0f)) {
            return (IMPLTYPE)((AbstractJSBlock)this.thisAsT());
        }
        if (f < 0.0f) {
            return this.assignMinus(iJSAssignmentTarget, JSExpr.lit(MathHelper.abs((float)f)));
        }
        return this.assignPlus(iJSAssignmentTarget, JSExpr.lit(f));
    }

    @Nonnull
    public IMPLTYPE assignPlus(@Nonnull IJSAssignmentTarget iJSAssignmentTarget, int n) {
        if (EqualsHelper.equals((int)n, (int)0)) {
            return (IMPLTYPE)((AbstractJSBlock)this.thisAsT());
        }
        if (n < 0) {
            return this.assignMinus(iJSAssignmentTarget, JSExpr.lit(MathHelper.abs((int)n)));
        }
        return this.assignPlus(iJSAssignmentTarget, JSExpr.lit(n));
    }

    @Nonnull
    public IMPLTYPE assignPlus(@Nonnull IJSAssignmentTarget iJSAssignmentTarget, long l) {
        if (EqualsHelper.equals((long)l, (long)0L)) {
            return (IMPLTYPE)((AbstractJSBlock)this.thisAsT());
        }
        if (l < 0L) {
            return this.assignMinus(iJSAssignmentTarget, JSExpr.lit(MathHelper.abs((long)l)));
        }
        return this.assignPlus(iJSAssignmentTarget, JSExpr.lit(l));
    }

    @Nonnull
    public IMPLTYPE assignPlus(@Nonnull IJSAssignmentTarget iJSAssignmentTarget, @Nonnull String string) {
        return this.assignPlus(iJSAssignmentTarget, JSExpr.lit(string));
    }

    @Nonnull
    public IMPLTYPE assignPlus(@Nonnull IJSAssignmentTarget iJSAssignmentTarget, @Nonnull IJSExpression iJSExpression) {
        this.addStatement(JSExpr.assignPlus(iJSAssignmentTarget, iJSExpression));
        return (IMPLTYPE)((AbstractJSBlock)this.thisAsT());
    }

    @Nonnull
    public IMPLTYPE assignMinus(@Nonnull IJSAssignmentTarget iJSAssignmentTarget, double d) {
        if (EqualsHelper.equals((double)d, (double)0.0)) {
            return (IMPLTYPE)((AbstractJSBlock)this.thisAsT());
        }
        return this.assignMinus(iJSAssignmentTarget, JSExpr.lit(d));
    }

    @Nonnull
    public IMPLTYPE assignMinus(@Nonnull IJSAssignmentTarget iJSAssignmentTarget, float f) {
        if (EqualsHelper.equals((float)f, (float)0.0f)) {
            return (IMPLTYPE)((AbstractJSBlock)this.thisAsT());
        }
        return this.assignMinus(iJSAssignmentTarget, JSExpr.lit(f));
    }

    @Nonnull
    public IMPLTYPE assignMinus(@Nonnull IJSAssignmentTarget iJSAssignmentTarget, int n) {
        if (EqualsHelper.equals((int)n, (int)0)) {
            return (IMPLTYPE)((AbstractJSBlock)this.thisAsT());
        }
        return this.assignMinus(iJSAssignmentTarget, JSExpr.lit(n));
    }

    @Nonnull
    public IMPLTYPE assignMinus(@Nonnull IJSAssignmentTarget iJSAssignmentTarget, long l) {
        if (EqualsHelper.equals((long)l, (long)0L)) {
            return (IMPLTYPE)((AbstractJSBlock)this.thisAsT());
        }
        return this.assignMinus(iJSAssignmentTarget, JSExpr.lit(l));
    }

    @Nonnull
    public IMPLTYPE assignMinus(@Nonnull IJSAssignmentTarget iJSAssignmentTarget, @Nonnull IJSExpression iJSExpression) {
        this.addStatement(JSExpr.assignMinus(iJSAssignmentTarget, iJSExpression));
        return (IMPLTYPE)((AbstractJSBlock)this.thisAsT());
    }

    @Nonnull
    public IMPLTYPE assignMultiply(@Nonnull IJSAssignmentTarget iJSAssignmentTarget, double d) {
        if (EqualsHelper.equals((double)d, (double)1.0)) {
            return (IMPLTYPE)((AbstractJSBlock)this.thisAsT());
        }
        return this.assignMultiply(iJSAssignmentTarget, JSExpr.lit(d));
    }

    @Nonnull
    public IMPLTYPE assignMultiply(@Nonnull IJSAssignmentTarget iJSAssignmentTarget, float f) {
        if (EqualsHelper.equals((float)f, (float)1.0f)) {
            return (IMPLTYPE)((AbstractJSBlock)this.thisAsT());
        }
        return this.assignMultiply(iJSAssignmentTarget, JSExpr.lit(f));
    }

    @Nonnull
    public IMPLTYPE assignMultiply(@Nonnull IJSAssignmentTarget iJSAssignmentTarget, int n) {
        if (EqualsHelper.equals((int)n, (int)1)) {
            return (IMPLTYPE)((AbstractJSBlock)this.thisAsT());
        }
        return this.assignMultiply(iJSAssignmentTarget, JSExpr.lit(n));
    }

    @Nonnull
    public IMPLTYPE assignMultiply(@Nonnull IJSAssignmentTarget iJSAssignmentTarget, long l) {
        if (EqualsHelper.equals((long)l, (long)1L)) {
            return (IMPLTYPE)((AbstractJSBlock)this.thisAsT());
        }
        return this.assignMultiply(iJSAssignmentTarget, JSExpr.lit(l));
    }

    @Nonnull
    public IMPLTYPE assignMultiply(@Nonnull IJSAssignmentTarget iJSAssignmentTarget, @Nonnull IJSExpression iJSExpression) {
        this.addStatement(JSExpr.assignMultiply(iJSAssignmentTarget, iJSExpression));
        return (IMPLTYPE)((AbstractJSBlock)this.thisAsT());
    }

    @Nonnull
    public IMPLTYPE assignDivide(@Nonnull IJSAssignmentTarget iJSAssignmentTarget, double d) {
        if (EqualsHelper.equals((double)d, (double)1.0)) {
            return (IMPLTYPE)((AbstractJSBlock)this.thisAsT());
        }
        return this.assignDivide(iJSAssignmentTarget, JSExpr.lit(d));
    }

    @Nonnull
    public IMPLTYPE assignDivide(@Nonnull IJSAssignmentTarget iJSAssignmentTarget, float f) {
        if (EqualsHelper.equals((float)f, (float)1.0f)) {
            return (IMPLTYPE)((AbstractJSBlock)this.thisAsT());
        }
        return this.assignDivide(iJSAssignmentTarget, JSExpr.lit(f));
    }

    @Nonnull
    public IMPLTYPE assignDivide(@Nonnull IJSAssignmentTarget iJSAssignmentTarget, int n) {
        if (EqualsHelper.equals((int)n, (int)1)) {
            return (IMPLTYPE)((AbstractJSBlock)this.thisAsT());
        }
        return this.assignDivide(iJSAssignmentTarget, JSExpr.lit(n));
    }

    @Nonnull
    public IMPLTYPE assignDivide(@Nonnull IJSAssignmentTarget iJSAssignmentTarget, long l) {
        if (EqualsHelper.equals((long)l, (long)1L)) {
            return (IMPLTYPE)((AbstractJSBlock)this.thisAsT());
        }
        return this.assignDivide(iJSAssignmentTarget, JSExpr.lit(l));
    }

    @Nonnull
    public IMPLTYPE assignDivide(@Nonnull IJSAssignmentTarget iJSAssignmentTarget, @Nonnull IJSExpression iJSExpression) {
        this.addStatement(JSExpr.assignDivide(iJSAssignmentTarget, iJSExpression));
        return (IMPLTYPE)((AbstractJSBlock)this.thisAsT());
    }

    @Nonnull
    public IMPLTYPE assignModulo(@Nonnull IJSAssignmentTarget iJSAssignmentTarget, int n) {
        return this.assignModulo(iJSAssignmentTarget, JSExpr.lit(n));
    }

    @Nonnull
    public IMPLTYPE assignModulo(@Nonnull IJSAssignmentTarget iJSAssignmentTarget, long l) {
        return this.assignModulo(iJSAssignmentTarget, JSExpr.lit(l));
    }

    @Nonnull
    public IMPLTYPE assignModulo(@Nonnull IJSAssignmentTarget iJSAssignmentTarget, @Nonnull IJSExpression iJSExpression) {
        this.addStatement(JSExpr.assignModulo(iJSAssignmentTarget, iJSExpression));
        return (IMPLTYPE)((AbstractJSBlock)this.thisAsT());
    }

    @Nonnull
    public IMPLTYPE incrPostfix(@Nonnull IJSAssignmentTarget iJSAssignmentTarget) {
        this.addStatement(new JSIncrPostfix(iJSAssignmentTarget));
        return (IMPLTYPE)((AbstractJSBlock)this.thisAsT());
    }

    @Nonnull
    public IMPLTYPE incrPrefix(@Nonnull IJSAssignmentTarget iJSAssignmentTarget) {
        this.addStatement(new JSIncrPrefix(iJSAssignmentTarget));
        return (IMPLTYPE)((AbstractJSBlock)this.thisAsT());
    }

    @Nonnull
    public IMPLTYPE decrPostfix(@Nonnull IJSAssignmentTarget iJSAssignmentTarget) {
        this.addStatement(new JSDecrPostfix(iJSAssignmentTarget));
        return (IMPLTYPE)((AbstractJSBlock)this.thisAsT());
    }

    @Nonnull
    public IMPLTYPE decrPrefix(@Nonnull IJSAssignmentTarget iJSAssignmentTarget) {
        this.addStatement(new JSDecrPrefix(iJSAssignmentTarget));
        return (IMPLTYPE)((AbstractJSBlock)this.thisAsT());
    }

    @Nonnull
    public JSForLoop _for() {
        return this.addStatement(new JSForLoop());
    }

    @Nonnull
    public JSForIn forIn(@Nonnull JSLet jSLet, @Nonnull IJSExpression iJSExpression) {
        return this.addStatement(new JSForIn(jSLet, iJSExpression));
    }

    @Nonnull
    public JSForIn forIn(@Nonnull @Nonempty String string, @Nonnull IJSExpression iJSExpression) {
        return this.addStatement(new JSForIn(string, iJSExpression));
    }

    @Nonnull
    public JSWhileLoop _while(@Nonnull IJSExpression iJSExpression) {
        return this.addStatement(new JSWhileLoop(iJSExpression));
    }

    @Nonnull
    public JSDoLoop _do(@Nonnull IJSExpression iJSExpression) {
        return this.addStatement(new JSDoLoop(iJSExpression));
    }

    @Nonnull
    public JSSwitch _switch(@Nonnull IJSExpression iJSExpression) {
        return this.addStatement(new JSSwitch(iJSExpression));
    }

    @Nonnull
    public JSTryBlock _try() {
        return this.addStatement(new JSTryBlock());
    }

    @Nonnull
    public IMPLTYPE delete(@Nonnull IJSExpression iJSExpression) {
        this.addStatement(new JSDelete(iJSExpression));
        return (IMPLTYPE)((AbstractJSBlock)this.thisAsT());
    }

    @Nonnull
    public IMPLTYPE _throw(@Nonnull IJSExpression iJSExpression) {
        this.addStatement(new JSThrow(iJSExpression));
        return (IMPLTYPE)((AbstractJSBlock)this.thisAsT());
    }

    @Nonnull
    public IMPLTYPE debugger() {
        this.addStatement(new JSDebugger());
        return (IMPLTYPE)((AbstractJSBlock)this.thisAsT());
    }

    @Nonnull
    public JSLabel label(@Nonnull @Nonempty String string) {
        return this.addStatement(new JSLabel(string));
    }

    @Nonnull
    public JSConditional _if(@Nonnull IJSExpression iJSExpression) {
        return this.addStatement(new JSConditional(iJSExpression));
    }

    @Nonnull
    public JSConditional _if(@Nonnull IJSExpression iJSExpression, @Nullable IHasJSCode iHasJSCode) {
        return this.addStatement(new JSConditional(iJSExpression, iHasJSCode));
    }

    @Nonnull
    public JSConditional _if(@Nonnull IJSExpression iJSExpression, @Nullable IHasJSCode iHasJSCode, @Nullable IHasJSCode iHasJSCode2) {
        return this.addStatement(new JSConditional(iJSExpression, iHasJSCode, iHasJSCode2));
    }

    @Nonnull
    public IMPLTYPE _return() {
        return this._return((IJSExpression)null);
    }

    @Nonnull
    public IMPLTYPE _return(boolean bl) {
        return this._return(JSExpr.lit(bl));
    }

    @Nonnull
    public IMPLTYPE _return(char c) {
        return this._return(JSExpr.lit(c));
    }

    @Nonnull
    public IMPLTYPE _return(double d) {
        return this._return(JSExpr.lit(d));
    }

    @Nonnull
    public IMPLTYPE _return(float f) {
        return this._return(JSExpr.lit(f));
    }

    @Nonnull
    public IMPLTYPE _return(int n) {
        return this._return(JSExpr.lit(n));
    }

    @Nonnull
    public IMPLTYPE _return(long l) {
        return this._return(JSExpr.lit(l));
    }

    @Nonnull
    public IMPLTYPE _return(@Nullable String string) {
        return this._return(string == null ? JSExpr.NULL : JSExpr.lit(string));
    }

    @Nonnull
    public IMPLTYPE _return(@Nullable IJson iJson) {
        return this._return(iJson == null ? JSExpr.NULL : JSExpr.json(iJson));
    }

    @Nonnull
    public IMPLTYPE _return(@Nullable IJSExpression iJSExpression) {
        this.addStatement(new JSReturn(iJSExpression));
        return (IMPLTYPE)((AbstractJSBlock)this.thisAsT());
    }

    @Nonnull
    public JSBlock block() {
        return this.addStatement(new JSBlock(false, false));
    }

    @Nonnull
    public IMPLTYPE comment(@Nonnull String string) {
        this.addStatement(new JSCommentSingleLine(string));
        return (IMPLTYPE)((AbstractJSBlock)this.thisAsT());
    }

    @Nonnull
    public IMPLTYPE add(@Nonnull IHasJSCode iHasJSCode) {
        if (iHasJSCode instanceof JSPackage) {
            for (IHasJSCode iHasJSCode2 : ((JSPackage)iHasJSCode).directMembers()) {
                this.add(iHasJSCode2);
            }
        } else if (iHasJSCode instanceof CollectingJSCodeProvider) {
            for (IHasJSCode iHasJSCode3 : ((CollectingJSCodeProvider)iHasJSCode).directAll()) {
                this.add(iHasJSCode3);
            }
        } else {
            if (GlobalDebug.isDebugMode() && !(iHasJSCode instanceof IHasJSCodeWithSettings)) {
                LOGGER.warn("Adding unspecified IHasJSCode of type " + iHasJSCode.getClass().getName() + " to " + ClassHelper.getClassLocalName((Object)this));
            }
            this.m_aObjs.add(this.m_nPos, (Object)iHasJSCode);
            ++this.m_nPos;
        }
        return (IMPLTYPE)((AbstractJSBlock)this.thisAsT());
    }

    @Nonnull
    public IMPLTYPE add(@Nonnull IJSStatement iJSStatement) {
        this.addStatement(iJSStatement);
        return (IMPLTYPE)((AbstractJSBlock)this.thisAsT());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        AbstractJSBlock abstractJSBlock = (AbstractJSBlock)object;
        return this.m_aObjs.equals(abstractJSBlock.m_aObjs) && this.m_aDecls.equals(abstractJSBlock.m_aDecls) && this.m_nPos == abstractJSBlock.m_nPos;
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aObjs).append(this.m_aDecls).append(this.m_nPos).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).appendIf("objs", this.m_aObjs, CollectionHelper::isNotEmpty).appendIf("decls", this.m_aDecls, CollectionHelper::isNotEmpty).append("pos", this.m_nPos).getToString();
    }
}

