/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.jquery;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.state.EChange;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.html.jquery.IJQuerySelector;
import com.helger.html.jquery.JQuery;
import com.helger.html.jquery.JQueryInvocation;
import com.helger.html.js.IHasJSCodeWithSettings;
import com.helger.html.js.IJSWriterSettings;
import com.helger.html.jscode.IJSExpression;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public class JQuerySelectorList
implements IHasJSCodeWithSettings {
    private final ICommonsList<IJQuerySelector> m_aElements = new CommonsArrayList();

    public JQuerySelectorList() {
    }

    public JQuerySelectorList(@Nonnull IJQuerySelector iJQuerySelector) {
        this.addSelector(iJQuerySelector);
    }

    public JQuerySelectorList(IJQuerySelector ... iJQuerySelectorArray) {
        if (iJQuerySelectorArray != null) {
            for (IJQuerySelector iJQuerySelector : iJQuerySelectorArray) {
                this.addSelector(iJQuerySelector);
            }
        }
    }

    public JQuerySelectorList(@Nullable Iterable<? extends IJQuerySelector> iterable) {
        if (iterable != null) {
            for (IJQuerySelector iJQuerySelector : iterable) {
                this.addSelector(iJQuerySelector);
            }
        }
    }

    public boolean hasSelectors() {
        return this.m_aElements.isNotEmpty();
    }

    @Nonnegative
    public int getSelectorCount() {
        return this.m_aElements.size();
    }

    @Nonnull
    public JQuerySelectorList addSelector(@Nonnull IJQuerySelector iJQuerySelector) {
        ValueEnforcer.notNull((Object)iJQuerySelector, (String)"Selector");
        this.m_aElements.add((Object)iJQuerySelector);
        return this;
    }

    @Nonnull
    public EChange removeSelector(@Nonnegative int n) {
        return EChange.valueOf((this.m_aElements.remove(n) != null ? 1 : 0) != 0);
    }

    @Nonnull
    public EChange removeSelector(@Nonnegative IJQuerySelector iJQuerySelector) {
        return EChange.valueOf((boolean)this.m_aElements.remove((Object)iJQuerySelector));
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IJQuerySelector> getAllSelectors() {
        return (ICommonsList)this.m_aElements.getClone();
    }

    @Nonnull
    public EChange clear() {
        return this.m_aElements.removeAll();
    }

    @Nonnull
    public IJSExpression getAsExpression() {
        int n = this.m_aElements.size();
        if (n == 0) {
            throw new IllegalStateException("Empty jQuery selector is not allowed!");
        }
        if (n == 1) {
            return ((IJQuerySelector)this.m_aElements.getFirstOrNull()).getExpression();
        }
        IJSExpression iJSExpression = ((IJQuerySelector)this.m_aElements.getFirstOrNull()).getExpression();
        for (int i = 1; i < n; ++i) {
            iJSExpression = iJSExpression.plus(' ').plus(((IJQuerySelector)this.m_aElements.get(i)).getExpression());
        }
        return iJSExpression;
    }

    @Nonnull
    public JQueryInvocation invoke() {
        return JQuery.jQuery(this.getAsExpression());
    }

    @Nonnull
    public String getJSCode(@Nullable IJSWriterSettings iJSWriterSettings) {
        return this.getAsExpression().getJSCode(iJSWriterSettings);
    }
}

