/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.jquery;

import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.clone.ICloneable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.html.jquery.JQuery;
import com.helger.html.jquery.JQueryInvocation;
import com.helger.html.jscode.IJSExpression;
import com.helger.html.jscode.JSAnonymousFunction;
import com.helger.html.jscode.JSAssocArray;
import com.helger.html.jscode.JSExpr;
import com.helger.http.EHttpMethod;
import com.helger.url.ISimpleURL;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.Serializable;

public class JQueryAjaxBuilder
implements Serializable,
ICloneable<JQueryAjaxBuilder> {
    private IJSExpression m_aAsync;
    private IJSExpression m_aCache;
    private IJSExpression m_aData;
    private IJSExpression m_aDataType;
    private IJSExpression m_aGlobalEvents;
    private IJSExpression m_aProcessData;
    private IJSExpression m_aURL;
    private IJSExpression m_aTraditional;
    private IJSExpression m_aMethod;
    private IJSExpression m_aCallbackContext;
    private JSAnonymousFunction m_aBeforeSend;
    private JSAnonymousFunction m_aComplete;
    private JSAnonymousFunction m_aError;
    private JSAnonymousFunction m_aSuccess;

    public JQueryAjaxBuilder() {
        this.cache(false);
    }

    public JQueryAjaxBuilder(@Nonnull JQueryAjaxBuilder jQueryAjaxBuilder) {
        ValueEnforcer.notNull((Object)jQueryAjaxBuilder, (String)"Other");
        this.m_aAsync = jQueryAjaxBuilder.m_aAsync;
        this.m_aCache = jQueryAjaxBuilder.m_aCache;
        this.m_aData = jQueryAjaxBuilder.m_aData;
        this.m_aDataType = jQueryAjaxBuilder.m_aDataType;
        this.m_aGlobalEvents = jQueryAjaxBuilder.m_aGlobalEvents;
        this.m_aProcessData = jQueryAjaxBuilder.m_aProcessData;
        this.m_aURL = jQueryAjaxBuilder.m_aURL;
        this.m_aTraditional = jQueryAjaxBuilder.m_aTraditional;
        this.m_aMethod = jQueryAjaxBuilder.m_aMethod;
        this.m_aCallbackContext = jQueryAjaxBuilder.m_aCallbackContext;
        this.m_aBeforeSend = jQueryAjaxBuilder.m_aBeforeSend;
        this.m_aComplete = jQueryAjaxBuilder.m_aComplete;
        this.m_aError = jQueryAjaxBuilder.m_aError;
        this.m_aSuccess = jQueryAjaxBuilder.m_aSuccess;
    }

    @Nullable
    public IJSExpression async() {
        return this.m_aAsync;
    }

    @Nonnull
    public JQueryAjaxBuilder async(boolean bl) {
        return this.async((IJSExpression)JSExpr.lit((boolean)bl));
    }

    @Nonnull
    public JQueryAjaxBuilder async(@Nullable IJSExpression iJSExpression) {
        this.m_aAsync = iJSExpression;
        return this;
    }

    @Nullable
    public IJSExpression cache() {
        return this.m_aCache;
    }

    @Nonnull
    public final JQueryAjaxBuilder cache(boolean bl) {
        return this.cache((IJSExpression)JSExpr.lit((boolean)bl));
    }

    @Nonnull
    public final JQueryAjaxBuilder cache(@Nullable IJSExpression iJSExpression) {
        this.m_aCache = iJSExpression;
        return this;
    }

    @Nullable
    public IJSExpression data() {
        return this.m_aData;
    }

    @Nonnull
    public JQueryAjaxBuilder data(@Nullable IJSExpression iJSExpression) {
        this.m_aData = iJSExpression;
        return this;
    }

    @Nullable
    public IJSExpression dataType() {
        return this.m_aDataType;
    }

    @Nonnull
    public JQueryAjaxBuilder dataType(@Nullable String string) {
        return this.dataType((IJSExpression)(string == null ? null : JSExpr.lit((String)string)));
    }

    @Nonnull
    public JQueryAjaxBuilder dataType(@Nullable IJSExpression iJSExpression) {
        this.m_aDataType = iJSExpression;
        return this;
    }

    @Nullable
    public IJSExpression global() {
        return this.m_aGlobalEvents;
    }

    @Nonnull
    public JQueryAjaxBuilder global(boolean bl) {
        return this.global((IJSExpression)JSExpr.lit((boolean)bl));
    }

    @Nonnull
    public JQueryAjaxBuilder global(@Nullable IJSExpression iJSExpression) {
        this.m_aGlobalEvents = iJSExpression;
        return this;
    }

    @Nullable
    public IJSExpression processData() {
        return this.m_aProcessData;
    }

    @Nonnull
    public JQueryAjaxBuilder processData(boolean bl) {
        return this.processData((IJSExpression)JSExpr.lit((boolean)bl));
    }

    @Nonnull
    public JQueryAjaxBuilder processData(@Nullable IJSExpression iJSExpression) {
        this.m_aProcessData = iJSExpression;
        return this;
    }

    @Nullable
    public IJSExpression traditional() {
        return this.m_aTraditional;
    }

    @Nonnull
    public JQueryAjaxBuilder traditional(boolean bl) {
        return this.traditional((IJSExpression)JSExpr.lit((boolean)bl));
    }

    @Nonnull
    public JQueryAjaxBuilder traditional(@Nullable IJSExpression iJSExpression) {
        this.m_aTraditional = iJSExpression;
        return this;
    }

    @Nullable
    public IJSExpression url() {
        return this.m_aURL;
    }

    @Nonnull
    public JQueryAjaxBuilder url(@Nullable ISimpleURL iSimpleURL) {
        return this.url(iSimpleURL == null ? null : iSimpleURL.getAsString());
    }

    @Nonnull
    public JQueryAjaxBuilder url(@Nullable String string) {
        return this.url((IJSExpression)(string == null ? null : JSExpr.lit((String)string)));
    }

    @Nonnull
    public JQueryAjaxBuilder url(@Nullable IJSExpression iJSExpression) {
        this.m_aURL = iJSExpression;
        return this;
    }

    @Nullable
    public IJSExpression method() {
        return this.m_aMethod;
    }

    @Nonnull
    public JQueryAjaxBuilder method(@Nullable EHttpMethod eHttpMethod) {
        return this.method((IJSExpression)(eHttpMethod == null ? null : JSExpr.lit((String)eHttpMethod.getName())));
    }

    @Nonnull
    public JQueryAjaxBuilder method(@Nullable String string) {
        return this.method((IJSExpression)(string == null ? null : JSExpr.lit((String)string)));
    }

    @Nonnull
    public JQueryAjaxBuilder method(@Nullable IJSExpression iJSExpression) {
        this.m_aMethod = iJSExpression;
        return this;
    }

    @Nullable
    public IJSExpression context() {
        return this.m_aCallbackContext;
    }

    @Nonnull
    public JQueryAjaxBuilder context(@Nullable IJSExpression iJSExpression) {
        this.m_aCallbackContext = iJSExpression;
        return this;
    }

    @Nullable
    public JSAnonymousFunction beforeSend() {
        return this.m_aBeforeSend;
    }

    @Nonnull
    public JQueryAjaxBuilder beforeSend(@Nullable JSAnonymousFunction jSAnonymousFunction) {
        this.m_aBeforeSend = jSAnonymousFunction;
        return this;
    }

    @Nullable
    public JSAnonymousFunction complete() {
        return this.m_aComplete;
    }

    @Nonnull
    public JQueryAjaxBuilder complete(@Nullable JSAnonymousFunction jSAnonymousFunction) {
        this.m_aComplete = jSAnonymousFunction;
        return this;
    }

    @Nullable
    public JSAnonymousFunction error() {
        return this.m_aError;
    }

    @Nonnull
    public JQueryAjaxBuilder error(@Nullable JSAnonymousFunction jSAnonymousFunction) {
        this.m_aError = jSAnonymousFunction;
        return this;
    }

    @Nullable
    public JSAnonymousFunction success() {
        return this.m_aSuccess;
    }

    @Nonnull
    public JQueryAjaxBuilder success(@Nullable JSAnonymousFunction jSAnonymousFunction) {
        this.m_aSuccess = jSAnonymousFunction;
        return this;
    }

    @Nonnull
    @ReturnsMutableCopy
    public JQueryAjaxBuilder getClone() {
        return new JQueryAjaxBuilder(this);
    }

    @Nonnull
    public JSAssocArray getJSSettings() {
        JSAssocArray jSAssocArray = new JSAssocArray();
        if (this.m_aAsync != null) {
            jSAssocArray.add("async", this.m_aAsync);
        }
        if (this.m_aCache != null) {
            jSAssocArray.add("cache", this.m_aCache);
        }
        if (this.m_aData != null) {
            jSAssocArray.add("data", this.m_aData);
        }
        if (this.m_aDataType != null) {
            jSAssocArray.add("dataType", this.m_aDataType);
        }
        if (this.m_aGlobalEvents != null) {
            jSAssocArray.add("global", this.m_aGlobalEvents);
        }
        if (this.m_aProcessData != null) {
            jSAssocArray.add("processData", this.m_aProcessData);
        }
        if (this.m_aTraditional != null) {
            jSAssocArray.add("traditional", this.m_aTraditional);
        }
        if (this.m_aMethod != null) {
            jSAssocArray.add("method", this.m_aMethod);
        }
        if (this.m_aCallbackContext != null) {
            jSAssocArray.add("context", this.m_aCallbackContext);
        }
        if (this.m_aBeforeSend != null) {
            jSAssocArray.add("beforeSend", (IJSExpression)this.m_aBeforeSend);
        }
        if (this.m_aComplete != null) {
            jSAssocArray.add("complete", (IJSExpression)this.m_aComplete);
        }
        if (this.m_aError != null) {
            jSAssocArray.add("error", (IJSExpression)this.m_aError);
        }
        if (this.m_aSuccess != null) {
            jSAssocArray.add("success", (IJSExpression)this.m_aSuccess);
        }
        return jSAssocArray;
    }

    @Nonnull
    public JQueryInvocation build() {
        return JQuery.ajax(this.m_aURL, this.getJSSettings());
    }

    public String toString() {
        return new ToStringGenerator((Object)this).appendIfNotNull("aAsync", (Object)this.m_aAsync).appendIfNotNull("Cache", (Object)this.m_aCache).appendIfNotNull("Data", (Object)this.m_aData).appendIfNotNull("DataType", (Object)this.m_aDataType).appendIfNotNull("GlobalEvents", (Object)this.m_aGlobalEvents).appendIfNotNull("ProcessData", (Object)this.m_aProcessData).appendIfNotNull("URL", (Object)this.m_aURL).appendIfNotNull("Traditional", (Object)this.m_aTraditional).appendIfNotNull("Method", (Object)this.m_aMethod).appendIfNotNull("CallbackContext", (Object)this.m_aCallbackContext).appendIfNotNull("BeforeSend", (Object)this.m_aBeforeSend).appendIfNotNull("Complete", (Object)this.m_aComplete).appendIfNotNull("Error", (Object)this.m_aError).appendIfNotNull("Success", (Object)this.m_aSuccess).getToString();
    }
}

