/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.jetty;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.OverrideOnDemand;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.iface.IThrowingRunnable;
import com.helger.base.lang.clazz.ClassHelper;
import com.helger.base.string.StringHelper;
import com.helger.base.system.SystemProperties;
import com.helger.io.file.FilenameHelper;
import com.helger.photon.jetty.InternalJettyStopMonitorThread;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.File;
import java.util.function.IntUnaryOperator;
import org.eclipse.jetty.ee10.annotations.AnnotationConfiguration;
import org.eclipse.jetty.ee10.servlet.SessionHandler;
import org.eclipse.jetty.ee10.webapp.Configuration;
import org.eclipse.jetty.ee10.webapp.FragmentConfiguration;
import org.eclipse.jetty.ee10.webapp.JettyWebXmlConfiguration;
import org.eclipse.jetty.ee10.webapp.JspConfiguration;
import org.eclipse.jetty.ee10.webapp.MetaInfConfiguration;
import org.eclipse.jetty.ee10.webapp.WebAppConfiguration;
import org.eclipse.jetty.ee10.webapp.WebAppContext;
import org.eclipse.jetty.ee10.webapp.WebInfConfiguration;
import org.eclipse.jetty.ee10.webapp.WebXmlConfiguration;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.session.DefaultSessionCache;
import org.eclipse.jetty.session.FileSessionDataStore;
import org.eclipse.jetty.session.SessionCache;
import org.eclipse.jetty.session.SessionDataStore;
import org.eclipse.jetty.session.SessionManager;
import org.eclipse.jetty.util.resource.PathResourceFactory;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class JettyStarter {
    public static final String CONTAINER_INCLUDE_JAR_PATTERN_JAR = ".*\\.jar$*";
    public static final String CONTAINER_INCLUDE_JAR_PATTERN_CLASSES = ".*/classes/.*";
    public static final String CONTAINER_INCLUDE_JAR_PATTERN_ALL = ".*\\.jar$*|.*/classes/.*";
    public static final int DEFAULT_PORT = 8080;
    public static final String DEFAULT_STOP_KEY = "secret";
    public static final int DEFAULT_STOP_PORT = 8079;
    public static final String DEFAULT_CONTEXT_PATH = "/";
    public static final String DEFAULT_CONTAINER_INCLUDE_JAR_PATTERN = null;
    public static final String DEFAULT_WEB_INF_INCLUDE_JAR_PATTERN = null;
    public static final String DEFAULT_SESSION_COOKIE_NAME = "PHOTONSESSIONID";
    public static final boolean DEFAULT_ALLOW_ANNOTATION_BASED_CONFIG = true;
    public static final boolean DEFAULT_ALLOW_DIRECTORY_LISTING = false;
    private static final Logger LOGGER = LoggerFactory.getLogger(JettyStarter.class);
    private static final String CONTAINER_JAR_PATTERN = "org.eclipse.jetty.server.webapp.ContainerIncludeJarPattern";
    private static final String WEBINF_JAR_PATTERN = "org.eclipse.jetty.server.webapp.WebInfIncludeJarPattern";
    private final ResourceFactory m_aRF = new PathResourceFactory();
    private final String m_sAppName;
    private final String m_sDirBaseName;
    private int m_nPort = 8080;
    private boolean m_bRunStopMonitor = true;
    private String m_sStopKey = "secret";
    private IntUnaryOperator m_aStopPort = n -> 8079;
    private boolean m_bSpecialSessionMgr = true;
    private Resource m_aResourceBase = this.m_aRF.newResource("target/webapp-classes");
    private String m_sWebXmlResource;
    private String m_sContextPath = "/";
    private String m_sContainerIncludeJarPattern = DEFAULT_CONTAINER_INCLUDE_JAR_PATTERN;
    private String m_sWebInfIncludeJarPattern = DEFAULT_WEB_INF_INCLUDE_JAR_PATTERN;
    private ThreadPool m_aThreadPool;
    private boolean m_bAllowAnnotationBasedConfig = true;
    private boolean m_bAllowDirectoryListing = false;
    private String m_sSessionCookieName = "PHOTONSESSIONID";

    public JettyStarter(@Nonnull Class<?> clazz) {
        this(ClassHelper.getClassLocalName(clazz));
    }

    public JettyStarter(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"AppName");
        this.m_sAppName = string;
        this.m_sDirBaseName = FilenameHelper.getAsSecureValidFilename((String)string);
        if (StringHelper.isEmpty((String)this.m_sDirBaseName)) {
            throw new IllegalStateException("FolderName for application name '" + string + "' is empty.");
        }
        this.m_aThreadPool = new QueuedThreadPool();
        ((QueuedThreadPool)this.m_aThreadPool).setName("jetty-server");
        System.setProperty("log4j2.disable.jmx", "true");
    }

    @Nonnegative
    public int getPort() {
        return this.m_nPort;
    }

    @Nonnull
    public final JettyStarter setPort(@Nonnegative int n) {
        ValueEnforcer.isGT0((int)n, (String)"Port");
        this.m_nPort = n;
        return this;
    }

    public boolean isRunStopMonitor() {
        return this.m_bRunStopMonitor;
    }

    @Nonnull
    public final JettyStarter setRunStopMonitor(boolean bl) {
        this.m_bRunStopMonitor = bl;
        return this;
    }

    @Nonnull
    public String getStopKey() {
        return this.m_sStopKey;
    }

    @Nonnull
    public final JettyStarter setStopKey(@Nonnull String string) {
        ValueEnforcer.notNull((Object)string, (String)"StopKey");
        this.m_sStopKey = string;
        return this;
    }

    public int getStopPort() {
        return this.m_aStopPort.applyAsInt(this.m_nPort);
    }

    @Nonnull
    public final JettyStarter setStopPort(@Nonnegative int n) {
        ValueEnforcer.isGT0((int)n, (String)"StopPort");
        return this.setStopPort(n2 -> n);
    }

    @Nonnull
    public final JettyStarter setStopPort(@Nonnull IntUnaryOperator intUnaryOperator) {
        ValueEnforcer.notNull((Object)intUnaryOperator, (String)"StopPort");
        this.m_aStopPort = intUnaryOperator;
        return this;
    }

    public boolean isSpecialSessionMgr() {
        return this.m_bSpecialSessionMgr;
    }

    @Nonnull
    public final JettyStarter setSpecialSessionMgr(boolean bl) {
        this.m_bSpecialSessionMgr = bl;
        return this;
    }

    @Nonnull
    public Resource getResourceBase() {
        return this.m_aResourceBase;
    }

    @Nonnull
    public final JettyStarter setResourceBase(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"ResourceBase");
        return this.setResourceBase(this.m_aRF.newResource(string));
    }

    @Nonnull
    public final JettyStarter setResourceBase(@Nonnull Resource resource) {
        ValueEnforcer.notNull((Object)resource, (String)"ResourceBase");
        this.m_aResourceBase = resource;
        return this;
    }

    @Nullable
    public String getWebXmlResource() {
        return this.m_sWebXmlResource;
    }

    @Nonnull
    public final JettyStarter setWebXmlResource(@Nullable String string) {
        this.m_sWebXmlResource = string;
        return this;
    }

    @Nonnull
    @Nonempty
    public String getContextPath() {
        return this.m_sContextPath;
    }

    @Nonnull
    public final JettyStarter setContextPath(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"sContextPath");
        this.m_sContextPath = string;
        return this;
    }

    @Nullable
    public String getContainerIncludeJarPattern() {
        return this.m_sContainerIncludeJarPattern;
    }

    @Nonnull
    public final JettyStarter setContainerIncludeJarPattern(@Nullable String string) {
        this.m_sContainerIncludeJarPattern = string;
        return this;
    }

    @Nullable
    public String getWebInfIncludeJarPattern() {
        return this.m_sWebInfIncludeJarPattern;
    }

    @Nonnull
    public final JettyStarter setWebInfIncludeJarPattern(@Nullable String string) {
        this.m_sWebInfIncludeJarPattern = string;
        return this;
    }

    @Nullable
    public ThreadPool getThreadPool() {
        return this.m_aThreadPool;
    }

    @Nonnull
    public final JettyStarter setThreadPool(@Nullable ThreadPool threadPool) {
        this.m_aThreadPool = threadPool;
        return this;
    }

    public boolean isAllowAnnotationBasedConfig() {
        return this.m_bAllowAnnotationBasedConfig;
    }

    @Nonnull
    public final JettyStarter setAllowAnnotationBasedConfig(boolean bl) {
        this.m_bAllowAnnotationBasedConfig = bl;
        return this;
    }

    public boolean isAllowDirectoryListing() {
        return this.m_bAllowDirectoryListing;
    }

    @Nonnull
    public final JettyStarter setAllowDirectoryListing(boolean bl) {
        this.m_bAllowDirectoryListing = bl;
        return this;
    }

    @Nullable
    public String getSessionCookieName() {
        return this.m_sSessionCookieName;
    }

    @Nonnull
    public final JettyStarter setSessionCookieName(@Nullable String string) {
        this.m_sSessionCookieName = string;
        return this;
    }

    @OverrideOnDemand
    protected void customizeHttpConfiguration(@Nonnull HttpConfiguration httpConfiguration) throws Exception {
    }

    @OverrideOnDemand
    protected void customizeHttpConnectionFactory(@Nonnull HttpConnectionFactory httpConnectionFactory) throws Exception {
    }

    @OverrideOnDemand
    protected void customizeServerConnector(@Nonnull ServerConnector serverConnector) throws Exception {
    }

    @OverrideOnDemand
    protected void customizeServer(@Nonnull Server server) throws Exception {
    }

    @OverrideOnDemand
    protected void customizeWebAppCtx(@Nonnull WebAppContext webAppContext) throws Exception {
    }

    @Nonnull
    public WebAppContext createWebAppContext(@Nonnull @Nonempty String string) throws Exception {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"ContextPath");
        String string2 = SystemProperties.getTmpDir() + FilenameHelper.getAsSecureValidASCIIFilename((String)string);
        WebAppContext webAppContext = new WebAppContext();
        webAppContext.setBaseResource(this.m_aResourceBase);
        webAppContext.setDescriptor(this.m_sWebXmlResource != null ? this.m_sWebXmlResource : this.m_aRF.newResource(this.m_aResourceBase.getName() + "/WEB-INF/web.xml").getName());
        webAppContext.setContextPath(string);
        webAppContext.setTempDirectory(new File(string2, this.m_sDirBaseName + ".webapp"));
        webAppContext.setParentLoaderPriority(true);
        webAppContext.setThrowUnavailableOnStartupException(true);
        if (this.m_sContainerIncludeJarPattern != null) {
            webAppContext.setAttribute(CONTAINER_JAR_PATTERN, (Object)this.m_sContainerIncludeJarPattern);
        }
        if (this.m_sWebInfIncludeJarPattern != null) {
            webAppContext.setAttribute(WEBINF_JAR_PATTERN, (Object)this.m_sWebInfIncludeJarPattern);
        }
        if (this.m_bAllowAnnotationBasedConfig) {
            webAppContext.setConfigurations(new Configuration[]{new WebInfConfiguration(), new WebXmlConfiguration(), new WebAppConfiguration(), new MetaInfConfiguration(), new FragmentConfiguration(), new AnnotationConfiguration(), new JettyWebXmlConfiguration(), new JspConfiguration()});
        }
        webAppContext.setInitParameter("org.eclipse.jetty.servlet.Default.dirAllowed", Boolean.toString(this.m_bAllowDirectoryListing));
        if (this.m_bSpecialSessionMgr) {
            SessionHandler sessionHandler = new SessionHandler();
            FileSessionDataStore fileSessionDataStore = new FileSessionDataStore();
            fileSessionDataStore.setStoreDir(new File(string2, this.m_sDirBaseName + ".sessions"));
            fileSessionDataStore.setDeleteUnrestorableFiles(true);
            DefaultSessionCache defaultSessionCache = new DefaultSessionCache((SessionManager)sessionHandler);
            defaultSessionCache.setSessionDataStore((SessionDataStore)fileSessionDataStore);
            defaultSessionCache.setRemoveUnloadableSessions(true);
            sessionHandler.setSessionCache((SessionCache)defaultSessionCache);
            webAppContext.setSessionHandler(sessionHandler);
        }
        webAppContext.getSessionHandler().getSessionCookieConfig().setHttpOnly(true);
        if (StringHelper.isNotEmpty((String)this.m_sSessionCookieName)) {
            webAppContext.getSessionHandler().setSessionCookie(this.m_sSessionCookieName);
        }
        this.customizeWebAppCtx(webAppContext);
        return webAppContext;
    }

    protected void customizeHandlerList(@Nonnull Handler.Sequence sequence) throws Exception {
    }

    @OverrideOnDemand
    protected void onServerStarted(@Nonnull Server server) throws Exception {
    }

    @OverrideOnDemand
    protected void onServerStartFailure(@Nonnull Server server, @Nonnull Throwable throwable) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws Exception {
        Server server = new Server(this.m_aThreadPool);
        HttpConfiguration httpConfiguration = new HttpConfiguration();
        httpConfiguration.setSendServerVersion(false);
        httpConfiguration.setSendXPoweredBy(false);
        this.customizeHttpConfiguration(httpConfiguration);
        HttpConnectionFactory httpConnectionFactory = new HttpConnectionFactory(httpConfiguration);
        this.customizeHttpConnectionFactory(httpConnectionFactory);
        ServerConnector serverConnector = new ServerConnector(server, new ConnectionFactory[]{httpConnectionFactory});
        serverConnector.setPort(this.m_nPort);
        serverConnector.setIdleTimeout(30000L);
        this.customizeServerConnector(serverConnector);
        server.setConnectors(new Connector[]{serverConnector});
        server.setAttribute("org.eclipse.jetty.server.Request.maxFormContentSize", (Object)0x200000);
        server.setAttribute("org.eclipse.jetty.server.Request.maxFormKeys", (Object)20000);
        this.customizeServer(server);
        httpConfiguration = this.createWebAppContext(this.m_sContextPath);
        httpConnectionFactory = new Handler.Sequence(new Handler[0]);
        httpConnectionFactory.addHandler((Handler)httpConfiguration);
        this.customizeHandlerList((Handler.Sequence)httpConnectionFactory);
        server.setHandler((Handler)httpConnectionFactory);
        serverConnector = httpConfiguration;
        server.setStopAtShutdown(true);
        try {
            int n = this.m_aStopPort.applyAsInt(this.m_nPort);
            if (this.m_bRunStopMonitor) {
                new InternalJettyStopMonitorThread(n, this.m_sStopKey, (IThrowingRunnable<Exception>)((IThrowingRunnable)() -> ((Server)server).stop())).start();
            }
            server.start();
            LOGGER.info("Started Jetty:" + this.m_nPort + ":" + n + " " + this.m_sAppName);
            this.onServerStarted(server);
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                try {
                    server.stop();
                    server.join();
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    LOGGER.error("ShutdownHook of JettyStarter has been interrupted!");
                }
                catch (Exception exception) {
                    LOGGER.error("Exception in ShutdownHook of JettyStarter!", (Throwable)exception);
                }
            }));
        }
        catch (Exception exception) {
            LOGGER.error("Failed to start Jetty " + this.m_sAppName + "!", (Throwable)exception);
            this.onServerStartFailure(server, exception);
        }
        finally {
            if (serverConnector.isFailed()) {
                LOGGER.error("Failed to start Jetty " + this.m_sAppName + " - stopping server!");
                try {
                    server.stop();
                    LOGGER.error("Failed to start Jetty " + this.m_sAppName + " - stopped server!");
                }
                catch (Exception exception) {
                    LOGGER.error("Error stopping Jetty " + this.m_sAppName + " after startup errors!", (Throwable)exception);
                }
            } else if (!server.isFailed()) {
                server.join();
            }
        }
    }
}

