/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.jetty;

import com.helger.annotation.Nonempty;
import com.helger.base.exception.InitializationException;
import com.helger.photon.jetty.JettyStarter;
import com.helger.photon.jetty.JettyStopper;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jetty.server.Server;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyRunner
extends JettyStarter {
    private static final Logger LOGGER = LoggerFactory.getLogger(JettyRunner.class);
    private Thread m_aThread;
    private final Semaphore m_aServerStartedSem = new Semaphore(0);
    private final AtomicBoolean m_aServerStartupSuccess = new AtomicBoolean(true);

    public JettyRunner() {
        this("JettyRunner");
    }

    public JettyRunner(@Nonnull @Nonempty String string) {
        super(string);
    }

    @Override
    protected void onServerStarted(@Nonnull Server server) {
        this.m_aServerStartedSem.release();
    }

    @Override
    protected void onServerStartFailure(@Nonnull Server server, @Nonnull Throwable throwable) {
        this.m_aServerStartupSuccess.set(false);
        this.m_aServerStartedSem.release();
    }

    public synchronized void startServer() throws Exception {
        if (this.m_aThread != null) {
            throw new IllegalStateException("Jetty is already running!");
        }
        this.m_aServerStartupSuccess.set(true);
        this.m_aThread = new Thread(() -> {
            try {
                this.run();
            }
            catch (Exception exception) {
                LOGGER.error("Error running Jetty", (Throwable)exception);
            }
        }, "JettyRunner");
        this.m_aThread.setDaemon(true);
        this.m_aThread.start();
        this.m_aServerStartedSem.acquire();
        if (!this.m_aServerStartupSuccess.get()) {
            throw new InitializationException("Failed to start Jetty:" + this.getPort() + ":" + this.getStopPort() + " - see logs for details");
        }
    }

    public synchronized void shutDownServer() throws IOException, InterruptedException {
        if (this.m_aThread != null) {
            new JettyStopper().setStopPort(this.getStopPort()).setStopKey(this.getStopKey()).run();
            this.m_aThread.join();
            this.m_aThread = null;
        }
    }
}

