/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.io.mock;

import com.helger.annotation.Nonempty;
import com.helger.annotation.OverridingMethodsMustInvokeSuper;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.dao.AbstractDAO;
import com.helger.photon.io.WebFileIO;
import com.helger.scope.mock.ScopeTestRule;
import jakarta.annotation.Nonnull;
import java.io.File;
import org.junit.rules.ExternalResource;

public class PhotonIOTestRule
extends ExternalResource {
    private final File m_aDataPath;
    private final String m_sServletContextPath;
    private boolean m_bOldDAOSilentMode;
    private boolean m_bOldWebFileIOSilentMode;

    public PhotonIOTestRule() {
        this(ScopeTestRule.STORAGE_PATH);
    }

    public PhotonIOTestRule(@Nonnull File file) {
        this(file, file.getAbsolutePath());
    }

    public PhotonIOTestRule(@Nonnull File file, @Nonnull @Nonempty String string) {
        ValueEnforcer.notNull((Object)file, (String)"DataPath");
        ValueEnforcer.notNull((Object)string, (String)"ServletContextPath");
        this.m_aDataPath = file.getAbsoluteFile();
        this.m_sServletContextPath = string;
    }

    @Nonnull
    public final File getDataPath() {
        return this.m_aDataPath;
    }

    @Nonnull
    @Nonempty
    public final String getServletContextPath() {
        return this.m_sServletContextPath;
    }

    @OverridingMethodsMustInvokeSuper
    public void before() {
        this.m_bOldDAOSilentMode = AbstractDAO.setSilentMode((boolean)true);
        this.m_bOldWebFileIOSilentMode = WebFileIO.setSilentMode(true);
        WebFileIO.initPaths(this.m_aDataPath, this.m_sServletContextPath, false);
    }

    @OverridingMethodsMustInvokeSuper
    public void after() {
        WebFileIO.resetPaths();
        WebFileIO.setSilentMode(this.m_bOldWebFileIOSilentMode);
        AbstractDAO.setSilentMode((boolean)this.m_bOldDAOSilentMode);
    }
}

