/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.io;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.GuardedBy;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.base.concurrent.SimpleReadWriteLock;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.io.relative.FileRelativeIO;
import com.helger.io.relative.IFileRelativeIO;
import com.helger.io.relative.IPathRelativeIO;
import com.helger.io.relative.PathRelativeIO;
import jakarta.annotation.Nonnull;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class WebFileIO {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebFileIO.class);
    private static final SimpleReadWriteLock RW_LOCK = new SimpleReadWriteLock();
    @GuardedBy(value="RW_LOCK")
    private static IFileRelativeIO s_aDataPath;
    @GuardedBy(value="RW_LOCK")
    private static IPathRelativeIO s_aServletContextPath;
    @GuardedBy(value="RW_LOCK")
    private static boolean s_bSilentMode;

    private WebFileIO() {
    }

    public static boolean setSilentMode(boolean bl) {
        return RW_LOCK.writeLockedBoolean(() -> {
            boolean bl2 = s_bSilentMode;
            s_bSilentMode = bl;
            return bl2;
        });
    }

    public static boolean isSilentMode() {
        return RW_LOCK.readLockedBoolean(() -> s_bSilentMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initPaths(@Nonnull File file, @Nonnull @Nonempty String string, boolean bl) {
        ValueEnforcer.notNull((Object)file, (String)"DataPath");
        ValueEnforcer.notEmpty((CharSequence)string, (String)"ServletContextPath");
        RW_LOCK.writeLock().lock();
        try {
            boolean bl2;
            if (s_aDataPath != null) {
                throw new IllegalStateException("Another data path is already present: " + String.valueOf(s_aDataPath));
            }
            if (s_aServletContextPath != null) {
                throw new IllegalStateException("Another servlet context path is already present: " + String.valueOf(s_aServletContextPath));
            }
            boolean bl3 = bl2 = !WebFileIO.isSilentMode();
            if (bl2) {
                LOGGER.info("Using '" + String.valueOf(file) + "' as the data path");
            }
            s_aDataPath = new FileRelativeIO(file);
            if (bl) {
                FileRelativeIO.internalCheckAccessRights((File)file);
            }
            if (bl2) {
                LOGGER.info("Using '" + string + "' as the servlet context path");
            }
            s_aServletContextPath = new PathRelativeIO(string);
        }
        finally {
            RW_LOCK.writeLock().unlock();
        }
    }

    public static void resetPaths() {
        RW_LOCK.writeLocked(() -> {
            s_aDataPath = null;
            s_aServletContextPath = null;
        });
    }

    public static boolean isInited() {
        return RW_LOCK.readLockedBoolean(() -> s_aDataPath != null);
    }

    @Nonnull
    public static IFileRelativeIO getDataIO() {
        IFileRelativeIO iFileRelativeIO = (IFileRelativeIO)RW_LOCK.readLockedGet(() -> s_aDataPath);
        if (iFileRelativeIO == null) {
            throw new IllegalStateException("Data path was not initialized!");
        }
        return iFileRelativeIO;
    }

    @Nonnull
    public static IPathRelativeIO getServletContextIO() {
        IPathRelativeIO iPathRelativeIO = (IPathRelativeIO)RW_LOCK.readLockedGet(() -> s_aServletContextPath);
        if (iPathRelativeIO == null) {
            throw new IllegalStateException("Servlet context path was not initialized!");
        }
        return iPathRelativeIO;
    }

    static {
        s_bSilentMode = false;
    }
}

