/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.resource.css;

import com.helger.annotation.Nonempty;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.builder.IBuilder;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.css.CSSFilenameHelper;
import com.helger.css.media.CSSMediaList;
import com.helger.css.media.ICSSMediaList;
import com.helger.html.resource.css.ICSSPathProvider;
import com.helger.html.resource.css.ICSSProvider;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public final class ConstantCSSPathProvider
implements ICSSPathProvider {
    private final String m_sPath;
    private final String m_sMinifiedPath;
    private final String m_sConditionalComment;
    private final CSSMediaList m_aCSSMediaList;
    private final boolean m_bIsBundlable;

    protected ConstantCSSPathProvider(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2, @Nullable String string3, @Nullable ICSSMediaList iCSSMediaList, boolean bl) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Path");
        ValueEnforcer.isTrue((boolean)CSSFilenameHelper.isCSSFilename((String)string), () -> "'" + string + "' is not a valid CSS filename");
        ValueEnforcer.notEmpty((CharSequence)string2, (String)"MinifiedPath");
        ValueEnforcer.isTrue((boolean)CSSFilenameHelper.isCSSFilename((String)string2), () -> "'" + string2 + "' is not a valid minified JS filename");
        this.m_sPath = string;
        this.m_sMinifiedPath = string2;
        this.m_sConditionalComment = string3;
        this.m_aCSSMediaList = iCSSMediaList == null ? new CSSMediaList() : new CSSMediaList(iCSSMediaList);
        this.m_bIsBundlable = bl;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getCSSItemPath(boolean bl) {
        return bl ? this.m_sPath : this.m_sMinifiedPath;
    }

    @Override
    @Nullable
    public String getConditionalComment() {
        return this.m_sConditionalComment;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICSSMediaList getMediaList() {
        return this.m_aCSSMediaList.getClone();
    }

    @Override
    public boolean isBundlable() {
        return this.m_bIsBundlable;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        ConstantCSSPathProvider constantCSSPathProvider = (ConstantCSSPathProvider)object;
        return this.m_sPath.equals(constantCSSPathProvider.m_sPath) && this.m_sMinifiedPath.equals(constantCSSPathProvider.m_sMinifiedPath) && this.m_bIsBundlable == constantCSSPathProvider.m_bIsBundlable;
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sPath).append((Object)this.m_sMinifiedPath).append(this.m_bIsBundlable).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("path", (Object)this.m_sPath).append("minifiedPath", (Object)this.m_sMinifiedPath).appendIfNotNull("conditionalComment", (Object)this.m_sConditionalComment).appendIfNotNull("CSSMediaList", (Object)this.m_aCSSMediaList).append("isBundlable", this.m_bIsBundlable).getToString();
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements IBuilder<ConstantCSSPathProvider> {
        private String m_sPath;
        private String m_sMinifiedPath;
        private String m_sConditionalComment = ICSSProvider.DEFAULT_CONDITIONAL_COMMENT;
        private ICSSMediaList m_aCSSMediaList = ICSSProvider.DEFAULT_CSS_MEDIA_LIST;
        private boolean m_bIsBundlable = true;

        @Nonnull
        public Builder path(@Nullable String string) {
            this.m_sPath = string;
            return this;
        }

        @Nonnull
        public Builder minifiedPath(@Nullable String string) {
            this.m_sMinifiedPath = string;
            return this;
        }

        @Nonnull
        public Builder minifiedPathFromPath() {
            return this.minifiedPath(CSSFilenameHelper.getMinifiedCSSFilename((String)this.m_sPath));
        }

        @Nonnull
        public Builder conditionalComment(@Nullable String string) {
            this.m_sConditionalComment = string;
            return this;
        }

        @Nonnull
        public Builder cssMediaList(@Nullable ICSSMediaList iCSSMediaList) {
            this.m_aCSSMediaList = iCSSMediaList;
            return this;
        }

        @Nonnull
        public Builder bundlable(boolean bl) {
            this.m_bIsBundlable = bl;
            return this;
        }

        @Nonnull
        public ConstantCSSPathProvider build() {
            return new ConstantCSSPathProvider(this.m_sPath, this.m_sMinifiedPath, this.m_sConditionalComment, this.m_aCSSMediaList, this.m_bIsBundlable);
        }
    }
}

