/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.markdown;

import com.helger.base.enforce.ValueEnforcer;
import com.helger.html.hc.IHCConversionSettings;
import com.helger.html.hc.impl.HCNodeList;
import com.helger.html.hc.render.HCRenderer;
import com.helger.html.markdown.MarkdownHCStack;
import jakarta.annotation.Nonnull;

public class MarkdownProcessingResult {
    private final HCNodeList m_aNodeList;

    public MarkdownProcessingResult(@Nonnull MarkdownHCStack markdownHCStack) {
        ValueEnforcer.notNull((Object)markdownHCStack, (String)"Result");
        this.m_aNodeList = markdownHCStack.getRoot();
    }

    @Nonnull
    public HCNodeList getNodeList() {
        return this.m_aNodeList;
    }

    @Nonnull
    public String getAsHTMLString() {
        return HCRenderer.getAsHTMLStringWithoutNamespaces(this.m_aNodeList).trim();
    }

    @Nonnull
    public String getAsHTMLString(@Nonnull IHCConversionSettings iHCConversionSettings) {
        return HCRenderer.getAsHTMLString(this.m_aNodeList, iHCConversionSettings).trim();
    }
}

