/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.js.tostring;

import com.helger.annotation.concurrent.Immutable;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.html.js.tostring.IJSToStringConverter;
import com.helger.html.js.tostring.JSToString;
import com.helger.html.js.tostring.JSType;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

@Immutable
public class JSToStringConverter
implements IJSToStringConverter {
    public static final boolean DEFAULT_WITH_SURROUNDING_VAR = true;
    private final boolean m_bWithSurroundingVar;

    public JSToStringConverter() {
        this(true);
    }

    public JSToStringConverter(boolean bl) {
        this.m_bWithSurroundingVar = bl;
    }

    public boolean isWithSurroundingVar() {
        return this.m_bWithSurroundingVar;
    }

    @Override
    @Nullable
    public String objectToJSString(@Nullable Object object, @Nonnull JSType jSType) {
        return object == null ? null : JSToString.objectToJSString(object, jSType, this.m_bWithSurroundingVar);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        JSToStringConverter jSToStringConverter = (JSToStringConverter)object;
        return this.m_bWithSurroundingVar == jSToStringConverter.m_bWithSurroundingVar;
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_bWithSurroundingVar).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("withVar", this.m_bWithSurroundingVar).getToString();
    }
}

