/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.js;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.state.EChange;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsEnumMap;
import com.helger.collection.commons.ICommonsMap;
import com.helger.html.js.CollectingJSCodeProvider;
import com.helger.html.js.EJSEvent;
import com.helger.html.js.IHasJSCode;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.Serializable;

@NotThreadSafe
public class JSEventMap
implements Serializable {
    private final ICommonsMap<EJSEvent, CollectingJSCodeProvider> m_aEvents = new CommonsEnumMap(EJSEvent.class);

    public void addHandler(@Nonnull EJSEvent eJSEvent2, @Nonnull IHasJSCode iHasJSCode) {
        ValueEnforcer.notNull((Object)((Object)eJSEvent2), (String)"JSEvent");
        ValueEnforcer.notNull((Object)iHasJSCode, (String)"NewHandler");
        ((CollectingJSCodeProvider)this.m_aEvents.computeIfAbsent((Object)eJSEvent2, eJSEvent -> new CollectingJSCodeProvider())).appendFlattened(iHasJSCode);
    }

    public void prependHandler(@Nonnull EJSEvent eJSEvent2, @Nonnull IHasJSCode iHasJSCode) {
        ValueEnforcer.notNull((Object)((Object)eJSEvent2), (String)"JSEvent");
        ValueEnforcer.notNull((Object)iHasJSCode, (String)"NewHandler");
        ((CollectingJSCodeProvider)this.m_aEvents.computeIfAbsent((Object)eJSEvent2, eJSEvent -> new CollectingJSCodeProvider())).prepend(iHasJSCode);
    }

    public void setHandler(@Nonnull EJSEvent eJSEvent, @Nonnull IHasJSCode iHasJSCode) {
        ValueEnforcer.notNull((Object)((Object)eJSEvent), (String)"JSEvent");
        ValueEnforcer.notNull((Object)iHasJSCode, (String)"NewHandler");
        this.m_aEvents.put((Object)eJSEvent, (Object)new CollectingJSCodeProvider().appendFlattened(iHasJSCode));
    }

    @Nonnull
    public EChange removeHandler(@Nullable EJSEvent eJSEvent) {
        if (eJSEvent == null) {
            return EChange.UNCHANGED;
        }
        return this.m_aEvents.removeObject((Object)eJSEvent);
    }

    @Nullable
    public CollectingJSCodeProvider getHandler(@Nullable EJSEvent eJSEvent) {
        return eJSEvent == null ? null : (CollectingJSCodeProvider)this.m_aEvents.get((Object)eJSEvent);
    }

    public boolean containsHandler(@Nullable EJSEvent eJSEvent) {
        return eJSEvent != null && this.m_aEvents.containsKey((Object)eJSEvent);
    }

    public boolean isEmpty() {
        return this.m_aEvents.isEmpty();
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsMap<EJSEvent, CollectingJSCodeProvider> getAllEventHandler() {
        return (ICommonsMap)this.m_aEvents.getClone();
    }

    @Nonnegative
    public int getCount() {
        return this.m_aEvents.size();
    }

    @Nonnull
    public EChange removeAll() {
        return this.m_aEvents.removeAll();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Events", this.m_aEvents).getToString();
    }
}

