/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.hc.mock;

import com.helger.annotation.OverridingMethodsMustInvokeSuper;
import com.helger.annotation.style.OverrideOnDemand;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.html.EHTMLVersion;
import com.helger.html.hc.config.HCSettings;
import jakarta.annotation.Nonnull;
import org.junit.rules.ExternalResource;

public class HCTestRuleHTMLVersion
extends ExternalResource {
    private boolean m_bWasSilent;
    private final EHTMLVersion m_eHTMLVersion;
    private EHTMLVersion m_ePrevHTMLVersion;

    public HCTestRuleHTMLVersion(@Nonnull EHTMLVersion eHTMLVersion) {
        this.m_eHTMLVersion = (EHTMLVersion)((Object)ValueEnforcer.notNull((Object)((Object)eHTMLVersion), (String)"HTMLVersion"));
    }

    @OverridingMethodsMustInvokeSuper
    @OverrideOnDemand
    public void before() {
        this.m_bWasSilent = HCSettings.setSilentMode(true);
        this.m_ePrevHTMLVersion = HCSettings.getConversionSettings().getHTMLVersion();
        HCSettings.setDefaultHTMLVersion(this.m_eHTMLVersion);
    }

    @OverridingMethodsMustInvokeSuper
    @OverrideOnDemand
    public void after() {
        HCSettings.setDefaultHTMLVersion(this.m_ePrevHTMLVersion);
        HCSettings.setSilentMode(this.m_bWasSilent);
    }
}

