/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.hc.html.textlevel;

import com.helger.annotation.CheckForSigned;
import com.helger.annotation.Nonnegative;
import com.helger.base.numeric.MathHelper;
import com.helger.base.string.StringHelper;
import com.helger.datetime.format.DateTimeFormatterCache;
import com.helger.html.CHTMLAttributes;
import com.helger.html.EHTMLElement;
import com.helger.html.hc.IHCConversionSettingsToNode;
import com.helger.html.hc.html.AbstractHCElementWithChildren;
import com.helger.typeconvert.impl.TypeConverter;
import com.helger.xml.microdom.IMicroElement;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.Date;

public class HCTime
extends AbstractHCElementWithChildren<HCTime> {
    public static final int LENGTH_YEAR = 4;
    public static final int LENGTH_MONTH = 2;
    public static final int LENGTH_DAY = 2;
    public static final int LENGTH_WEEKINYEAR = 2;
    public static final int LENGTH_HOUR = 2;
    public static final int LENGTH_MIN = 2;
    public static final int LENGTH_SEC = 2;
    private String m_sDatetime;

    public HCTime() {
        super(EHTMLElement.TIME);
    }

    @Nullable
    public final String getDatetime() {
        return this.m_sDatetime;
    }

    @Nonnull
    public final HCTime setAsMonth(@Nonnegative int n, @Nonnegative int n2) {
        this.m_sDatetime = StringHelper.getLeadingZero((int)n, (int)4) + "-" + StringHelper.getLeadingZero((int)n2, (int)2);
        return this;
    }

    @Nonnull
    public final HCTime setAsDate(@Nonnegative int n, @Nonnegative int n2, @Nonnegative int n3) {
        this.m_sDatetime = StringHelper.getLeadingZero((int)n, (int)4) + "-" + StringHelper.getLeadingZero((int)n2, (int)2) + "-" + StringHelper.getLeadingZero((int)n3, (int)2);
        return this;
    }

    @Nonnull
    public final HCTime setAsDate(@Nonnull LocalDate localDate) {
        this.m_sDatetime = DateTimeFormatterCache.getDateTimeFormatterStrict((String)"uuuu-MM-dd").format(localDate);
        return this;
    }

    @Nonnull
    public final HCTime setAsDate(@Nonnull Date date) {
        return this.setAsDate((LocalDate)TypeConverter.convert((Object)date, LocalDate.class));
    }

    @Nonnull
    public final HCTime setAsYearlessDate(@Nonnegative int n, @Nonnegative int n2) {
        this.m_sDatetime = StringHelper.getLeadingZero((int)n, (int)2) + "-" + StringHelper.getLeadingZero((int)n2, (int)2);
        return this;
    }

    @Nonnull
    public final HCTime setAsTime(@Nonnegative int n, @Nonnegative int n2) {
        this.m_sDatetime = StringHelper.getLeadingZero((int)n, (int)2) + ":" + StringHelper.getLeadingZero((int)n2, (int)2);
        return this;
    }

    @Nonnull
    public final HCTime setAsTime(@Nonnegative int n, @Nonnegative int n2, @Nonnegative int n3) {
        this.m_sDatetime = StringHelper.getLeadingZero((int)n, (int)2) + ":" + StringHelper.getLeadingZero((int)n2, (int)2) + ":" + StringHelper.getLeadingZero((int)n3, (int)2);
        return this;
    }

    @Nonnull
    public final HCTime setAsTime(@Nonnegative int n, @Nonnegative int n2, @Nonnegative int n3, @Nonnegative int n4) {
        this.m_sDatetime = StringHelper.getLeadingZero((int)n, (int)2) + ":" + StringHelper.getLeadingZero((int)n2, (int)2) + ":" + StringHelper.getLeadingZero((int)n3, (int)2) + "." + n4;
        return this;
    }

    @Nonnull
    public final HCTime setAsTime(@Nonnull LocalTime localTime) {
        this.m_sDatetime = DateTimeFormatterCache.getDateTimeFormatterStrict((String)"HH:mm:ss").format(localTime);
        return this;
    }

    @Nonnull
    public final HCTime setAsTime(@Nonnull Date date) {
        return this.setAsTime((LocalTime)TypeConverter.convert((Object)date, LocalTime.class));
    }

    @Nonnull
    public final HCTime setAsDateAndTime(@Nonnull LocalDateTime localDateTime) {
        this.m_sDatetime = DateTimeFormatterCache.getDateTimeFormatterStrict((String)"uuuu-MM-dd'T'HH:mm:ss.SSSZZ").format(localDateTime);
        return this;
    }

    @Nonnull
    public final HCTime setAsDateAndTime(@Nonnull ZonedDateTime zonedDateTime) {
        return this.setAsDateAndTime(zonedDateTime.toLocalDateTime());
    }

    @Nonnull
    public final HCTime setAsTimezone(@CheckForSigned int n) {
        int n2 = n / 60;
        int n3 = n % 60;
        this.m_sDatetime = (n2 < 0 ? "-" : "+") + StringHelper.getLeadingZero((int)MathHelper.abs((int)n2), (int)2) + ":" + StringHelper.getLeadingZero((int)MathHelper.abs((int)n3), (int)2);
        return this;
    }

    @Nonnull
    public final HCTime setAsWeekInYear(@Nonnegative int n, @Nonnegative int n2) {
        this.m_sDatetime = StringHelper.getLeadingZero((int)n, (int)4) + "-W" + StringHelper.getLeadingZero((int)n2, (int)2);
        return this;
    }

    @Nonnull
    public final HCTime setAsYear(@Nonnegative int n) {
        this.m_sDatetime = StringHelper.getLeadingZero((int)n, (int)4);
        return this;
    }

    @Override
    protected void fillMicroElement(IMicroElement iMicroElement, IHCConversionSettingsToNode iHCConversionSettingsToNode) {
        super.fillMicroElement(iMicroElement, iHCConversionSettingsToNode);
        if (StringHelper.isNotEmpty((String)this.m_sDatetime)) {
            iMicroElement.setAttribute(CHTMLAttributes.DATETIME, this.m_sDatetime);
        }
    }
}

