/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.hc.html.script;

import com.helger.base.tostring.ToStringGenerator;
import com.helger.html.CHTMLAttributeValues;
import com.helger.html.CHTMLAttributes;
import com.helger.html.annotation.OutOfBandNode;
import com.helger.html.hc.IHCConversionSettingsToNode;
import com.helger.html.hc.html.script.AbstractHCScript;
import com.helger.html.resource.js.IJSPathProvider;
import com.helger.url.ISimpleURL;
import com.helger.xml.microdom.IMicroElement;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

@OutOfBandNode
public class HCScriptFile
extends AbstractHCScript<HCScriptFile> {
    public static final boolean DEFAULT_DEFER = false;
    public static final boolean DEFAULT_ASYNC = false;
    private ISimpleURL m_aSrc;
    private IJSPathProvider m_aJSPathProvider;
    private boolean m_bDefer = false;
    private boolean m_bAsync = false;

    @Nullable
    public final ISimpleURL getSrc() {
        return this.m_aSrc;
    }

    @Nonnull
    public final HCScriptFile setSrc(@Nullable ISimpleURL iSimpleURL) {
        this.m_aSrc = iSimpleURL;
        return this;
    }

    @Nullable
    public final IJSPathProvider getPathProvider() {
        return this.m_aJSPathProvider;
    }

    @Nonnull
    public final HCScriptFile setPathProvider(@Nullable IJSPathProvider iJSPathProvider) {
        this.m_aJSPathProvider = iJSPathProvider;
        return (HCScriptFile)this.thisAsT();
    }

    public final boolean isDefer() {
        return this.m_bDefer;
    }

    @Nonnull
    public final HCScriptFile setDefer(boolean bl) {
        this.m_bDefer = bl;
        return this;
    }

    public final boolean isAsync() {
        return this.m_bAsync;
    }

    @Nonnull
    public final HCScriptFile setAsync(boolean bl) {
        this.m_bAsync = bl;
        return this;
    }

    @Override
    protected void fillMicroElement(IMicroElement iMicroElement, IHCConversionSettingsToNode iHCConversionSettingsToNode) {
        super.fillMicroElement(iMicroElement, iHCConversionSettingsToNode);
        if (this.m_aSrc != null) {
            iMicroElement.setAttribute(CHTMLAttributes.SRC, this.m_aSrc.getWithCharset(iHCConversionSettingsToNode.getCharset()).getAsString());
        }
        if (this.m_bDefer) {
            iMicroElement.setAttribute(CHTMLAttributes.DEFER, CHTMLAttributeValues.DEFER);
        }
        if (this.m_bAsync) {
            iMicroElement.setAttribute(CHTMLAttributes.ASYNC, CHTMLAttributeValues.ASYNC);
        }
        iMicroElement.addText((CharSequence)"");
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).appendIfNotNull("Src", (Object)this.m_aSrc).appendIfNotNull("JSPathProvider", (Object)this.m_aJSPathProvider).append("Defer", this.m_bDefer).append("Async", this.m_bAsync).getToString();
    }
}

