/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.hc.html.metadata;

import com.helger.annotation.OverridingMethodsMustInvokeSuper;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.css.media.CSSMediaList;
import com.helger.css.media.ECSSMedium;
import com.helger.css.media.ICSSMediaList;
import com.helger.html.CHTMLAttributes;
import com.helger.html.EHTMLElement;
import com.helger.html.annotation.OutOfBandNode;
import com.helger.html.hc.IHCConversionSettingsToNode;
import com.helger.html.hc.IHCHasChildrenMutable;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.html.AbstractHCElement;
import com.helger.html.hc.html.embedded.EHCCORSSettings;
import com.helger.html.hc.html.metadata.EHCLinkType;
import com.helger.html.hc.html.metadata.IHCLinkType;
import com.helger.html.resource.css.ICSSPathProvider;
import com.helger.mime.CMimeType;
import com.helger.mime.IMimeType;
import com.helger.url.ISimpleURL;
import com.helger.xml.microdom.IHasAttributeValue;
import com.helger.xml.microdom.IMicroElement;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

@OutOfBandNode
public class HCLink
extends AbstractHCElement<HCLink> {
    private IHCLinkType m_aRel;
    private IHCLinkType m_aRev;
    private IMimeType m_aType;
    private ISimpleURL m_aHref;
    private String m_sHrefLang;
    private String m_sCharset;
    private CSSMediaList m_aMediaList;
    private String m_sSizes;
    private ICSSPathProvider m_aCSSPathProvider;
    private EHCCORSSettings m_eCrossOrigin;
    private String m_sIntegrity;

    public HCLink() {
        super(EHTMLElement.LINK);
    }

    public final boolean isCSSLink() {
        return EHCLinkType.STYLESHEET.equals(this.m_aRel);
    }

    @Nullable
    public final IHCLinkType getRel() {
        return this.m_aRel;
    }

    @Nonnull
    public final HCLink setRel(@Nullable IHCLinkType iHCLinkType) {
        this.m_aRel = iHCLinkType;
        return this;
    }

    @Nullable
    public final IHCLinkType getRev() {
        return this.m_aRev;
    }

    @Nonnull
    public final HCLink setRev(@Nullable IHCLinkType iHCLinkType) {
        this.m_aRev = iHCLinkType;
        return this;
    }

    @Nullable
    public final IMimeType getType() {
        return this.m_aType;
    }

    @Nonnull
    public final HCLink setType(@Nullable IMimeType iMimeType) {
        this.m_aType = iMimeType;
        return this;
    }

    @Nullable
    public final ISimpleURL getHref() {
        return this.m_aHref;
    }

    @Nonnull
    public final HCLink setHref(@Nullable ISimpleURL iSimpleURL) {
        this.m_aHref = iSimpleURL;
        return this;
    }

    @Nullable
    public final String getHrefLang() {
        return this.m_sHrefLang;
    }

    @Nonnull
    public final HCLink setHrefLang(@Nullable String string) {
        this.m_sHrefLang = string;
        return this;
    }

    @Nullable
    public final String getCharset() {
        return this.m_sCharset;
    }

    @Nonnull
    public final HCLink setCharset(@Nullable String string) {
        this.m_sCharset = string;
        return this;
    }

    @Nullable
    public final ICSSMediaList getMedia() {
        return this.m_aMediaList;
    }

    @Nonnull
    public final HCLink setMedia(@Nullable ICSSMediaList iCSSMediaList) {
        this.m_aMediaList = iCSSMediaList == null ? null : new CSSMediaList(iCSSMediaList);
        return this;
    }

    @Nonnull
    private CSSMediaList _ensureMediaListPresent() {
        if (this.m_aMediaList == null) {
            this.m_aMediaList = new CSSMediaList();
        }
        return this.m_aMediaList;
    }

    @Nonnull
    public final HCLink addMedium(@Nonnull ECSSMedium eCSSMedium) {
        this._ensureMediaListPresent().addMedium(eCSSMedium);
        return this;
    }

    @Nonnull
    public final HCLink addMedia(@Nonnull ICSSMediaList iCSSMediaList) {
        ValueEnforcer.notNull((Object)iCSSMediaList, (String)"MediaList");
        this._ensureMediaListPresent();
        for (ECSSMedium eCSSMedium : iCSSMediaList.getAllMedia()) {
            this.m_aMediaList.addMedium(eCSSMedium);
        }
        return this;
    }

    @Nonnull
    public final HCLink addMedia(@Nonnull Iterable<ECSSMedium> iterable) {
        ValueEnforcer.notNull(iterable, (String)"MediaList");
        this._ensureMediaListPresent();
        for (ECSSMedium eCSSMedium : iterable) {
            this.m_aMediaList.addMedium(eCSSMedium);
        }
        return this;
    }

    @Nonnull
    public final HCLink addMedia(ECSSMedium ... eCSSMediumArray) {
        ValueEnforcer.notNull((Object)eCSSMediumArray, (String)"MediaList");
        this._ensureMediaListPresent();
        for (ECSSMedium eCSSMedium : eCSSMediumArray) {
            this.m_aMediaList.addMedium(eCSSMedium);
        }
        return this;
    }

    @Nonnull
    public final HCLink removeAllMedia() {
        this.m_aMediaList = null;
        return this;
    }

    @Nullable
    public final String getSizes() {
        return this.m_sSizes;
    }

    @Nonnull
    public final HCLink setSizes(@Nullable String string) {
        this.m_sSizes = string;
        return this;
    }

    @Nullable
    public final ICSSPathProvider getPathProvider() {
        return this.m_aCSSPathProvider;
    }

    @Nonnull
    public final HCLink setPathProvider(@Nullable ICSSPathProvider iCSSPathProvider) {
        this.m_aCSSPathProvider = iCSSPathProvider;
        return this;
    }

    @Nullable
    public final EHCCORSSettings getCrossOrigin() {
        return this.m_eCrossOrigin;
    }

    @Nonnull
    public final HCLink setCrossOrigin(@Nullable EHCCORSSettings eHCCORSSettings) {
        this.m_eCrossOrigin = eHCCORSSettings;
        return this;
    }

    @Nullable
    public final String getIntegrity() {
        return this.m_sIntegrity;
    }

    @Nonnull
    public final HCLink setIntegrity(@Nullable String string) {
        this.m_sIntegrity = string;
        return this;
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    protected void onFinalizeNodeState(@Nonnull IHCConversionSettingsToNode iHCConversionSettingsToNode, @Nonnull IHCHasChildrenMutable<?, ? super IHCNode> iHCHasChildrenMutable) {
        super.onFinalizeNodeState(iHCConversionSettingsToNode, iHCHasChildrenMutable);
        if (this.m_aRel == EHCLinkType.STYLESHEET && !this.hasNonce()) {
            this.setNonce(iHCConversionSettingsToNode.getNonceStyle());
        }
    }

    @Override
    protected void fillMicroElement(IMicroElement iMicroElement, IHCConversionSettingsToNode iHCConversionSettingsToNode) {
        super.fillMicroElement(iMicroElement, iHCConversionSettingsToNode);
        if (this.m_aRel != null) {
            iMicroElement.setAttribute(CHTMLAttributes.REL, (IHasAttributeValue)this.m_aRel);
        }
        if (this.m_aRev != null) {
            iMicroElement.setAttribute(CHTMLAttributes.REV, (IHasAttributeValue)this.m_aRev);
        }
        if (this.m_aType != null) {
            iMicroElement.setAttribute(CHTMLAttributes.TYPE, this.m_aType.getAsString());
        }
        if (this.m_aHref != null) {
            iMicroElement.setAttribute(CHTMLAttributes.HREF, this.m_aHref.getWithCharset(iHCConversionSettingsToNode.getCharset()).getAsString());
        }
        if (StringHelper.isNotEmpty((String)this.m_sHrefLang)) {
            iMicroElement.setAttribute(CHTMLAttributes.HREFLANG, this.m_sHrefLang);
        }
        if (StringHelper.isNotEmpty((String)this.m_sCharset)) {
            iMicroElement.setAttribute(CHTMLAttributes.CHARSET, this.m_sCharset);
        }
        if (this.m_aMediaList != null && this.m_aMediaList.hasAnyMedia()) {
            iMicroElement.setAttribute(CHTMLAttributes.MEDIA, this.m_aMediaList.getMediaString());
        }
        if (StringHelper.isNotEmpty((String)this.m_sSizes)) {
            iMicroElement.setAttribute(CHTMLAttributes.SIZES, this.m_sSizes);
        }
        if (this.m_eCrossOrigin != null) {
            iMicroElement.setAttribute(CHTMLAttributes.CROSSORIGIN, (IHasAttributeValue)this.m_eCrossOrigin);
        }
        if (StringHelper.isNotEmpty((String)this.m_sIntegrity)) {
            iMicroElement.setAttribute(CHTMLAttributes.INTEGRITY, this.m_sIntegrity);
        }
        if (iHCConversionSettingsToNode.getHTMLVersion().isPriorToHTML5()) {
            iMicroElement.addText((CharSequence)"");
        }
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).appendIfNotNull("Rel", (Object)this.m_aRel).appendIfNotNull("Rev", (Object)this.m_aRev).appendIfNotNull("Type", (Object)this.m_aType).appendIfNotNull("Href", (Object)this.m_aHref).appendIfNotNull("HrefLang", (Object)this.m_sHrefLang).appendIfNotNull("Charset", (Object)this.m_sCharset).appendIfNotNull("MediaList", (Object)this.m_aMediaList).appendIfNotNull("Sizes", (Object)this.m_sSizes).appendIfNotNull("CSSPathProvider", (Object)this.m_aCSSPathProvider).appendIfNotNull("CrossOrigin", (Object)this.m_eCrossOrigin).appendIfNotNull("Integrity", (Object)this.m_sIntegrity).getToString();
    }

    @Nonnull
    public static HCLink createCSSLink(@Nonnull ISimpleURL iSimpleURL) {
        return new HCLink().setRel(EHCLinkType.STYLESHEET).setType(CMimeType.TEXT_CSS).setHref(iSimpleURL);
    }
}

