/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.hc.html.grouping;

import com.helger.annotation.CheckReturnValue;
import com.helger.annotation.style.OverrideOnDemand;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.html.EHTMLElement;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.html.AbstractHCElementWithInternalChildren;
import com.helger.html.hc.html.grouping.IHCLI;
import com.helger.html.hc.html.grouping.IHCList;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public abstract class AbstractHCList<IMPLTYPE extends AbstractHCList<IMPLTYPE, ITEMTYPE>, ITEMTYPE extends IHCLI<ITEMTYPE>>
extends AbstractHCElementWithInternalChildren<IMPLTYPE, ITEMTYPE>
implements IHCList<IMPLTYPE, ITEMTYPE> {
    private final Class<ITEMTYPE> m_aItemClass;

    protected AbstractHCList(@Nonnull EHTMLElement eHTMLElement, @Nonnull Class<ITEMTYPE> clazz) {
        super(eHTMLElement);
        this.m_aItemClass = (Class)ValueEnforcer.notNull(clazz, (String)"ItemClass");
    }

    @OverrideOnDemand
    protected void onAddItem(@Nonnull ITEMTYPE ITEMTYPE) {
    }

    @Nullable
    private ITEMTYPE _addItem(@Nullable ITEMTYPE ITEMTYPE) {
        if (ITEMTYPE != null) {
            this.addChild((IHCNode)ITEMTYPE);
            this.onAddItem(ITEMTYPE);
        }
        return ITEMTYPE;
    }

    @Nonnull
    protected abstract ITEMTYPE createEmptyItem();

    @Override
    @Nonnull
    public final ITEMTYPE addItem() {
        return this._addItem(this.createEmptyItem());
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public final ITEMTYPE addAndReturnItem(@Nullable String string) {
        return (ITEMTYPE)((IHCLI)this.addItem().addChild(string));
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public final ITEMTYPE addAndReturnItem(String ... stringArray) {
        return (ITEMTYPE)((IHCLI)this.addItem().addChildren(stringArray));
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public final ITEMTYPE addAndReturnItem(@Nullable IHCNode iHCNode) {
        if (this.m_aItemClass.isInstance(iHCNode)) {
            return (ITEMTYPE)this._addItem((IHCLI)this.m_aItemClass.cast(iHCNode));
        }
        ITEMTYPE ITEMTYPE = this.addItem();
        ITEMTYPE.addChild(iHCNode);
        return ITEMTYPE;
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public final ITEMTYPE addAndReturnItem(IHCNode ... iHCNodeArray) {
        ITEMTYPE ITEMTYPE = this.addItem();
        ITEMTYPE.addChildren(iHCNodeArray);
        return ITEMTYPE;
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public final ITEMTYPE addAndReturnItem(@Nullable Iterable<? extends IHCNode> iterable) {
        ITEMTYPE ITEMTYPE = this.addItem();
        ITEMTYPE.addChildren(iterable);
        return ITEMTYPE;
    }

    @Override
    @Nullable
    @CheckReturnValue
    public final ITEMTYPE addAndReturnItem(@Nullable ITEMTYPE ITEMTYPE) {
        return this._addItem(ITEMTYPE);
    }

    @Override
    @Nonnull
    public final IMPLTYPE addItem(@Nullable String string) {
        this.addAndReturnItem((ITEMTYPE)string);
        return (IMPLTYPE)((AbstractHCList)this.thisAsT());
    }

    @Override
    @Nonnull
    public final IMPLTYPE addItem(String ... stringArray) {
        this.addAndReturnItem((ITEMTYPE)stringArray);
        return (IMPLTYPE)((AbstractHCList)this.thisAsT());
    }

    @Override
    @Nonnull
    public final IMPLTYPE addItem(@Nullable IHCNode iHCNode) {
        this.addAndReturnItem((ITEMTYPE)iHCNode);
        return (IMPLTYPE)((AbstractHCList)this.thisAsT());
    }

    @Override
    @Nonnull
    public final IMPLTYPE addItem(IHCNode ... iHCNodeArray) {
        this.addAndReturnItem((ITEMTYPE)iHCNodeArray);
        return (IMPLTYPE)((AbstractHCList)this.thisAsT());
    }

    @Override
    @Nonnull
    public final IMPLTYPE addItem(@Nullable Iterable<? extends IHCNode> iterable) {
        this.addAndReturnItem((ITEMTYPE)iterable);
        return (IMPLTYPE)((AbstractHCList)this.thisAsT());
    }

    @Override
    @Nonnull
    public final IMPLTYPE addItem(@Nullable ITEMTYPE ITEMTYPE) {
        this._addItem(ITEMTYPE);
        return (IMPLTYPE)((AbstractHCList)this.thisAsT());
    }

    @Override
    @Nullable
    public final ITEMTYPE getFirstItem() {
        return (ITEMTYPE)((IHCLI)this.getFirstChild());
    }

    @Override
    @Nullable
    public final ITEMTYPE getLastItem() {
        return (ITEMTYPE)((IHCLI)this.getLastChild());
    }
}

