/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.hc.html.forms;

import com.helger.annotation.OverridingMethodsMustInvokeSuper;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.base.string.StringHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.html.CHTMLAttributeValues;
import com.helger.html.CHTMLAttributes;
import com.helger.html.EHTMLElement;
import com.helger.html.hc.IHCConversionSettingsToNode;
import com.helger.html.hc.html.HC_Action;
import com.helger.html.hc.html.HC_Target;
import com.helger.html.hc.html.forms.AbstractHCControl;
import com.helger.html.hc.html.forms.EHCFormMethod;
import com.helger.html.hc.html.forms.EHCInputType;
import com.helger.html.hc.html.forms.IHCInput;
import com.helger.html.js.IHasJSCode;
import com.helger.html.js.IHasJSCodeWithSettings;
import com.helger.mime.IMimeType;
import com.helger.url.ISimpleURL;
import com.helger.xml.microdom.IHasAttributeValue;
import com.helger.xml.microdom.IMicroElement;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

@NotThreadSafe
public abstract class AbstractHCInput<IMPLTYPE extends AbstractHCInput<IMPLTYPE>>
extends AbstractHCControl<IMPLTYPE>
implements IHCInput<IMPLTYPE> {
    public static final boolean DEFAULT_CHECKED = false;
    public static final boolean DEFAULT_FORMNOVALIDATE = false;
    public static final boolean DEFAULT_MULTIPLE = false;
    private EHCInputType m_eType;
    private String m_sAccept;
    private String m_sAlt;
    private String m_sAutoComplete;
    private boolean m_bChecked = false;
    private String m_sDirName;
    private String m_sForm;
    private final HC_Action m_aFormAction = new HC_Action();
    private IMimeType m_aFormEncType;
    private EHCFormMethod m_eFormMethod;
    private boolean m_bFormNoValidate = false;
    private HC_Target m_aFormTarget;
    private int m_nHeight = -1;
    private String m_sList;
    private String m_sMaxValue;
    private int m_nMaxLength = -1;
    private String m_sMinValue;
    private int m_nMinLength = -1;
    private boolean m_bMultiple = false;
    private String m_sPattern;
    private String m_sPlaceholder;
    private int m_nSize = -1;
    private ISimpleURL m_aSrc;
    private String m_sStep;
    private String m_sValue;
    private int m_nWidth = -1;

    public AbstractHCInput() {
        super(EHTMLElement.INPUT);
    }

    public AbstractHCInput(@Nonnull EHCInputType eHCInputType) {
        this();
        this.setType(eHCInputType);
    }

    @Override
    @Nullable
    public final EHCInputType getType() {
        return this.m_eType;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setType(@Nullable EHCInputType eHCInputType) {
        this.m_eType = eHCInputType;
        return (IMPLTYPE)((AbstractHCInput)this.thisAsT());
    }

    @Override
    @Nullable
    public final String getAccept() {
        return this.m_sAccept;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setAccept(@Nullable String string) {
        this.m_sAccept = string;
        return (IMPLTYPE)((AbstractHCInput)this.thisAsT());
    }

    @Override
    @Nonnull
    public final IMPLTYPE setAccept(@Nullable IMimeType iMimeType) {
        return (IMPLTYPE)this.setAccept(iMimeType == null ? null : iMimeType.getAsString());
    }

    @Override
    @Nullable
    public final String getAlt() {
        return this.m_sAlt;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setAlt(@Nullable String string) {
        this.m_sAlt = string;
        return (IMPLTYPE)((AbstractHCInput)this.thisAsT());
    }

    @Override
    @Nullable
    public final String getAutoComplete() {
        return this.m_sAutoComplete;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setAutoComplete(@Nullable String string) {
        this.m_sAutoComplete = string;
        return (IMPLTYPE)((AbstractHCInput)this.thisAsT());
    }

    @Override
    public final boolean isChecked() {
        return this.m_bChecked;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setChecked(boolean bl) {
        this.m_bChecked = bl;
        return (IMPLTYPE)((AbstractHCInput)this.thisAsT());
    }

    @Override
    @Nullable
    public final String getDirName() {
        return this.m_sDirName;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setDirName(@Nullable String string) {
        this.m_sDirName = string;
        return (IMPLTYPE)((AbstractHCInput)this.thisAsT());
    }

    @Override
    @Nullable
    public final String getForm() {
        return this.m_sForm;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setForm(@Nullable String string) {
        this.m_sForm = string;
        return (IMPLTYPE)((AbstractHCInput)this.thisAsT());
    }

    @Override
    @Nullable
    public final ISimpleURL getFormActionURL() {
        return this.m_aFormAction.getActionURL();
    }

    @Override
    @Nullable
    public final IHasJSCode getFormActionJS() {
        return this.m_aFormAction.getActionJS();
    }

    @Override
    @Nonnull
    public final IMPLTYPE setFormAction(@Nullable ISimpleURL iSimpleURL) {
        this.m_aFormAction.setAction(iSimpleURL);
        return (IMPLTYPE)((AbstractHCInput)this.thisAsT());
    }

    @Override
    @Nonnull
    public final IMPLTYPE setFormAction(@Nullable IHasJSCodeWithSettings iHasJSCodeWithSettings) {
        this.m_aFormAction.setAction(iHasJSCodeWithSettings);
        return (IMPLTYPE)((AbstractHCInput)this.thisAsT());
    }

    @Override
    @Nullable
    public final IMimeType getFormEncType() {
        return this.m_aFormEncType;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setFormEncType(@Nullable IMimeType iMimeType) {
        this.m_aFormEncType = iMimeType;
        return (IMPLTYPE)((AbstractHCInput)this.thisAsT());
    }

    @Override
    @Nullable
    public final EHCFormMethod getFormMethod() {
        return this.m_eFormMethod;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setFormMethod(@Nullable EHCFormMethod eHCFormMethod) {
        this.m_eFormMethod = eHCFormMethod;
        return (IMPLTYPE)((AbstractHCInput)this.thisAsT());
    }

    @Override
    public final boolean isFormNoValidate() {
        return this.m_bFormNoValidate;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setFormNoValidate(boolean bl) {
        this.m_bFormNoValidate = bl;
        return (IMPLTYPE)((AbstractHCInput)this.thisAsT());
    }

    @Override
    @Nullable
    public final HC_Target getFormTarget() {
        return this.m_aFormTarget;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setFormTarget(@Nullable HC_Target hC_Target) {
        this.m_aFormTarget = hC_Target;
        return (IMPLTYPE)((AbstractHCInput)this.thisAsT());
    }

    @Override
    public final int getHeight() {
        return this.m_nHeight;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setHeight(int n) {
        this.m_nHeight = n;
        return (IMPLTYPE)((AbstractHCInput)this.thisAsT());
    }

    @Override
    @Nullable
    public final String getList() {
        return this.m_sList;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setList(@Nullable String string) {
        this.m_sList = string;
        return (IMPLTYPE)((AbstractHCInput)this.thisAsT());
    }

    @Override
    @Nullable
    public final String getMaxValue() {
        return this.m_sMaxValue;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setMaxValue(@Nullable String string) {
        this.m_sMaxValue = string;
        return (IMPLTYPE)((AbstractHCInput)this.thisAsT());
    }

    @Override
    public final int getMaxLength() {
        return this.m_nMaxLength;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setMaxLength(int n) {
        this.m_nMaxLength = n;
        return (IMPLTYPE)((AbstractHCInput)this.thisAsT());
    }

    @Override
    @Nullable
    public final String getMinValue() {
        return this.m_sMinValue;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setMinValue(@Nullable String string) {
        this.m_sMinValue = string;
        return (IMPLTYPE)((AbstractHCInput)this.thisAsT());
    }

    @Override
    public final int getMinLength() {
        return this.m_nMinLength;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setMinLength(int n) {
        this.m_nMinLength = n;
        return (IMPLTYPE)((AbstractHCInput)this.thisAsT());
    }

    @Override
    public final boolean isMultiple() {
        return this.m_bMultiple;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setMultiple(boolean bl) {
        this.m_bMultiple = bl;
        return (IMPLTYPE)((AbstractHCInput)this.thisAsT());
    }

    @Override
    @Nullable
    public final String getPattern() {
        return this.m_sPattern;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setPattern(@Nullable String string) {
        this.m_sPattern = string;
        return (IMPLTYPE)((AbstractHCInput)this.thisAsT());
    }

    @Override
    @Nullable
    public final String getPlaceholder() {
        return this.m_sPlaceholder;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setPlaceholder(@Nullable String string) {
        this.m_sPlaceholder = string;
        return (IMPLTYPE)((AbstractHCInput)this.thisAsT());
    }

    @Override
    public final int getSize() {
        return this.m_nSize;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setSize(int n) {
        this.m_nSize = n;
        return (IMPLTYPE)((AbstractHCInput)this.thisAsT());
    }

    @Override
    @Nullable
    public final ISimpleURL getSrc() {
        return this.m_aSrc;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setSrc(@Nullable ISimpleURL iSimpleURL) {
        this.m_aSrc = iSimpleURL;
        return (IMPLTYPE)((AbstractHCInput)this.thisAsT());
    }

    @Override
    @Nullable
    public final String getStep() {
        return this.m_sStep;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setStep(@Nullable String string) {
        this.m_sStep = string;
        return (IMPLTYPE)((AbstractHCInput)this.thisAsT());
    }

    @Override
    @Nullable
    public final String getValue() {
        return this.m_sValue;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setValue(@Nullable String string) {
        this.m_sValue = string;
        return (IMPLTYPE)((AbstractHCInput)this.thisAsT());
    }

    @Override
    public final int getWidth() {
        return this.m_nWidth;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setWidth(int n) {
        this.m_nWidth = n;
        return (IMPLTYPE)((AbstractHCInput)this.thisAsT());
    }

    @Override
    public String getPlainText() {
        return StringHelper.getNotNull((String)this.getValue());
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    protected void fillMicroElement(IMicroElement iMicroElement, IHCConversionSettingsToNode iHCConversionSettingsToNode) {
        super.fillMicroElement(iMicroElement, iHCConversionSettingsToNode);
        if (this.m_eType != null) {
            iMicroElement.setAttribute(CHTMLAttributes.TYPE, (IHasAttributeValue)this.m_eType);
        }
        if (StringHelper.isNotEmpty((String)this.m_sAccept)) {
            iMicroElement.setAttribute(CHTMLAttributes.ACCEPT, this.m_sAccept);
        }
        if (StringHelper.isNotEmpty((String)this.m_sAlt)) {
            iMicroElement.setAttribute(CHTMLAttributes.ALT, this.m_sAlt);
        }
        if (StringHelper.isNotEmpty((String)this.m_sAutoComplete)) {
            iMicroElement.setAttribute(CHTMLAttributes.AUTOCOMPLETE, this.m_sAutoComplete);
        }
        if (this.m_bChecked) {
            iMicroElement.setAttribute(CHTMLAttributes.CHECKED, CHTMLAttributeValues.CHECKED);
        }
        if (StringHelper.isNotEmpty((String)this.m_sDirName)) {
            iMicroElement.setAttribute(CHTMLAttributes.DIRNAME, this.m_sDirName);
        }
        if (StringHelper.isNotEmpty((String)this.m_sForm)) {
            iMicroElement.setAttribute(CHTMLAttributes.FORM, this.m_sForm);
        }
        this.m_aFormAction.applyProperties(CHTMLAttributes.FORMACTION, iMicroElement, iHCConversionSettingsToNode.getJSWriterSettings(), iHCConversionSettingsToNode.getCharset());
        if (this.m_aFormEncType != null) {
            iMicroElement.setAttribute(CHTMLAttributes.FORMENCTYPE, this.m_aFormEncType.getAsString());
        }
        if (this.m_eFormMethod != null) {
            iMicroElement.setAttribute(CHTMLAttributes.FORMMETHOD, (IHasAttributeValue)this.m_eFormMethod);
        }
        if (this.m_bFormNoValidate) {
            iMicroElement.setAttribute(CHTMLAttributes.FORMNOVALIDATE, CHTMLAttributeValues.FORMNOVALIDATE);
        }
        if (this.m_aFormTarget != null) {
            iMicroElement.setAttribute(CHTMLAttributes.FORMTARGET, (IHasAttributeValue)this.m_aFormTarget);
        }
        if (this.m_nHeight > 0) {
            iMicroElement.setAttribute(CHTMLAttributes.HEIGHT, this.m_nHeight);
        }
        if (StringHelper.isNotEmpty((String)this.m_sList)) {
            iMicroElement.setAttribute(CHTMLAttributes.LIST, this.m_sList);
        }
        if (StringHelper.isNotEmpty((String)this.m_sMaxValue)) {
            iMicroElement.setAttribute(CHTMLAttributes.MAX, this.m_sMaxValue);
        }
        if (this.m_nMaxLength > 0) {
            iMicroElement.setAttribute(CHTMLAttributes.MAXLENGTH, this.m_nMaxLength);
        }
        if (StringHelper.isNotEmpty((String)this.m_sMinValue)) {
            iMicroElement.setAttribute(CHTMLAttributes.MIN, this.m_sMinValue);
        }
        if (this.m_nMinLength > 0) {
            iMicroElement.setAttribute(CHTMLAttributes.MINLENGTH, this.m_nMinLength);
        }
        if (this.m_bMultiple) {
            iMicroElement.setAttribute(CHTMLAttributes.MULTIPLE, CHTMLAttributeValues.MULTIPLE);
        }
        if (StringHelper.isNotEmpty((String)this.m_sPattern)) {
            iMicroElement.setAttribute(CHTMLAttributes.PATTERN, this.m_sPattern);
        }
        if (StringHelper.isNotEmpty((String)this.m_sPlaceholder)) {
            iMicroElement.setAttribute(CHTMLAttributes.PLACEHOLDER, this.m_sPlaceholder);
        }
        if (this.m_nSize > 0) {
            iMicroElement.setAttribute(CHTMLAttributes.SIZE, this.m_nSize);
        }
        if (this.m_aSrc != null) {
            iMicroElement.setAttribute(CHTMLAttributes.SRC, this.m_aSrc.getWithCharset(iHCConversionSettingsToNode.getCharset()).getAsString());
        }
        if (StringHelper.isNotEmpty((String)this.m_sStep)) {
            iMicroElement.setAttribute(CHTMLAttributes.STEP, this.m_sStep);
        }
        if (this.m_sValue != null) {
            iMicroElement.setAttribute(CHTMLAttributes.VALUE, this.m_sValue);
        }
        if (this.m_nWidth > 0) {
            iMicroElement.setAttribute(CHTMLAttributes.WIDTH, this.m_nWidth);
        }
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).appendIfNotNull("Type", (Object)this.m_eType).appendIfNotNull("Accept", (Object)this.m_sAccept).appendIfNotNull("Alt", (Object)this.m_sAlt).append("AutoComplete", (Object)this.m_sAutoComplete).append("Checked", this.m_bChecked).appendIfNotNull("DirName", (Object)this.m_sDirName).appendIfNotNull("Form", (Object)this.m_sForm).append("FormAction", (Object)this.m_aFormAction).appendIfNotNull("FormEncType", (Object)this.m_aFormEncType).appendIfNotNull("FormMethod", (Object)this.m_eFormMethod).append("FormNoValidate", this.m_bFormNoValidate).appendIfNotNull("FormTarget", (Object)this.m_aFormTarget).append("Height", this.m_nHeight).appendIfNotNull("List", (Object)this.m_sList).appendIfNotNull("MaxValue", (Object)this.m_sMaxValue).append("MaxLength", this.m_nMaxLength).appendIfNotNull("MinValue", (Object)this.m_sMinValue).append("MinLength", this.m_nMinLength).append("Multiple", this.m_bMultiple).appendIfNotNull("Pattern", (Object)this.m_sPattern).appendIfNotNull("Placeholder", (Object)this.m_sPlaceholder).append("Size", this.m_nSize).appendIfNotNull("Src", (Object)this.m_aSrc).appendIfNotNull("Step", (Object)this.m_sStep).appendIfNotNull("Value", (Object)this.m_sValue).append("Width", this.m_nWidth).getToString();
    }
}

