/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.hc.html.embedded;

import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.html.CHTMLAttributes;
import com.helger.html.EHTMLElement;
import com.helger.html.hc.IHCConversionSettingsToNode;
import com.helger.html.hc.html.AbstractHCElement;
import com.helger.html.hc.html.embedded.EHCParamValueType;
import com.helger.mime.IMimeType;
import com.helger.xml.microdom.IHasAttributeValue;
import com.helger.xml.microdom.IMicroElement;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public class HCParam
extends AbstractHCElement<HCParam> {
    private String m_sName;
    private String m_sValue;
    private EHCParamValueType m_eValueType;
    private IMimeType m_aType;

    public HCParam() {
        super(EHTMLElement.PARAM);
    }

    public HCParam(@Nonnull String string) {
        this();
        this.setName(string);
    }

    @Nullable
    public final String getName() {
        return this.m_sName;
    }

    @Nonnull
    public final HCParam setName(@Nonnull String string) {
        this.m_sName = (String)ValueEnforcer.notNull((Object)string, (String)"Name");
        return this;
    }

    @Nullable
    public final String getValue() {
        return this.m_sValue;
    }

    @Nonnull
    public final HCParam setValue(@Nullable String string) {
        this.m_sValue = string;
        return this;
    }

    @Nullable
    public final EHCParamValueType getValueType() {
        return this.m_eValueType;
    }

    @Nonnull
    public final HCParam setValueType(@Nullable EHCParamValueType eHCParamValueType) {
        this.m_eValueType = eHCParamValueType;
        return this;
    }

    @Nullable
    public final IMimeType getType() {
        return this.m_aType;
    }

    @Nonnull
    public final HCParam setType(@Nullable IMimeType iMimeType) {
        this.m_aType = iMimeType;
        return this;
    }

    @Override
    protected void fillMicroElement(IMicroElement iMicroElement, IHCConversionSettingsToNode iHCConversionSettingsToNode) {
        super.fillMicroElement(iMicroElement, iHCConversionSettingsToNode);
        if (StringHelper.isNotEmpty((String)this.m_sName)) {
            iMicroElement.setAttribute(CHTMLAttributes.NAME, this.m_sName);
        }
        if (StringHelper.isNotEmpty((String)this.m_sValue)) {
            iMicroElement.setAttribute(CHTMLAttributes.VALUE, this.m_sValue);
        }
        if (this.m_eValueType != null) {
            iMicroElement.setAttribute(CHTMLAttributes.VALUETYPE, (IHasAttributeValue)this.m_eValueType);
        }
        if (this.m_aType != null) {
            iMicroElement.setAttribute(CHTMLAttributes.TYPE, this.m_aType.getAsString());
        }
        iMicroElement.addText((CharSequence)"");
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).appendIfNotNull("name", (Object)this.m_sName).appendIfNotNull("value", (Object)this.m_sValue).appendIfNotNull("valueType", (Object)this.m_eValueType).appendIfNotNull("type", (Object)this.m_aType).getToString();
    }
}

