/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.hc.html.embedded;

import com.helger.annotation.Nonempty;
import com.helger.annotation.OverridingMethodsMustInvokeSuper;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.html.CHTMLAttributeValues;
import com.helger.html.CHTMLAttributes;
import com.helger.html.EHTMLElement;
import com.helger.html.hc.IHCConversionSettingsToNode;
import com.helger.html.hc.html.AbstractHCElementWithInternalChildren;
import com.helger.html.hc.html.IHCMediaElementChild;
import com.helger.html.hc.html.embedded.EHCCORSSettings;
import com.helger.html.hc.html.embedded.EHCPreload;
import com.helger.html.hc.html.embedded.HCSource;
import com.helger.html.hc.html.embedded.HCTrack;
import com.helger.html.hc.html.embedded.IHCMediaElement;
import com.helger.url.ISimpleURL;
import com.helger.xml.microdom.IHasAttributeValue;
import com.helger.xml.microdom.IMicroElement;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public abstract class AbstractHCMediaElement<IMPLTYPE extends AbstractHCMediaElement<IMPLTYPE>>
extends AbstractHCElementWithInternalChildren<IMPLTYPE, IHCMediaElementChild<?>>
implements IHCMediaElement<IMPLTYPE> {
    public static final boolean DEFAULT_AUTOPLAY = false;
    public static final boolean DEFAULT_CONTROLS = false;
    public static final boolean DEFAULT_LOOP = false;
    public static final boolean DEFAULT_MUTED = false;
    private boolean m_bAutoPlay = false;
    private EHCPreload m_ePreload;
    private boolean m_bControls = false;
    private boolean m_bLoop = false;
    private boolean m_bMuted = false;
    private ISimpleURL m_aSrc;
    private EHCCORSSettings m_eCrossOrigin;

    public AbstractHCMediaElement(@Nonnull EHTMLElement eHTMLElement) {
        super(eHTMLElement);
    }

    @Override
    public final boolean isAutoPlay() {
        return this.m_bAutoPlay;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setAutoPlay(boolean bl) {
        this.m_bAutoPlay = bl;
        return (IMPLTYPE)((AbstractHCMediaElement)this.thisAsT());
    }

    @Override
    @Nullable
    public final EHCPreload getPreload() {
        return this.m_ePreload;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setPreload(@Nullable EHCPreload eHCPreload) {
        this.m_ePreload = eHCPreload;
        return (IMPLTYPE)((AbstractHCMediaElement)this.thisAsT());
    }

    @Override
    public final boolean isControls() {
        return this.m_bControls;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setControls(boolean bl) {
        this.m_bControls = bl;
        return (IMPLTYPE)((AbstractHCMediaElement)this.thisAsT());
    }

    @Override
    public final boolean isLoop() {
        return this.m_bLoop;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setLoop(boolean bl) {
        this.m_bLoop = bl;
        return (IMPLTYPE)((AbstractHCMediaElement)this.thisAsT());
    }

    @Override
    public final boolean isMuted() {
        return this.m_bMuted;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setMuted(boolean bl) {
        this.m_bMuted = bl;
        return (IMPLTYPE)((AbstractHCMediaElement)this.thisAsT());
    }

    @Override
    @Nullable
    public final ISimpleURL getSrc() {
        return this.m_aSrc;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setSrc(@Nullable ISimpleURL iSimpleURL) {
        this.m_aSrc = iSimpleURL;
        return (IMPLTYPE)((AbstractHCMediaElement)this.thisAsT());
    }

    @Override
    @Nullable
    public final EHCCORSSettings getCrossOrigin() {
        return this.m_eCrossOrigin;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setCrossOrigin(@Nullable EHCCORSSettings eHCCORSSettings) {
        this.m_eCrossOrigin = eHCCORSSettings;
        return (IMPLTYPE)((AbstractHCMediaElement)this.thisAsT());
    }

    @Override
    @Nonnull
    public final IMPLTYPE addSource(@Nullable HCSource hCSource) {
        if (hCSource != null) {
            this.addChild(hCSource);
        }
        return (IMPLTYPE)((AbstractHCMediaElement)this.thisAsT());
    }

    @Override
    @Nonnull
    public final IMPLTYPE addTrack(@Nullable HCTrack hCTrack) {
        if (hCTrack != null) {
            this.addChild(hCTrack);
        }
        return (IMPLTYPE)((AbstractHCMediaElement)this.thisAsT());
    }

    @Override
    @Nonnull
    @Nonempty
    protected ICommonsList<IHCMediaElementChild<?>> getChildrenFormEmitting(@Nonnull @Nonempty ICommonsList<IHCMediaElementChild<?>> iCommonsList) {
        CommonsArrayList commonsArrayList = new CommonsArrayList(iCommonsList.size());
        iCommonsList.findAll(iHCMediaElementChild -> iHCMediaElementChild.getElement().equals((Object)EHTMLElement.SOURCE), arg_0 -> ((ICommonsList)commonsArrayList).add(arg_0));
        iCommonsList.findAll(iHCMediaElementChild -> !iHCMediaElementChild.getElement().equals((Object)EHTMLElement.SOURCE), arg_0 -> ((ICommonsList)commonsArrayList).add(arg_0));
        return commonsArrayList;
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    protected void fillMicroElement(IMicroElement iMicroElement, IHCConversionSettingsToNode iHCConversionSettingsToNode) {
        super.fillMicroElement(iMicroElement, iHCConversionSettingsToNode);
        if (this.m_bAutoPlay) {
            iMicroElement.setAttribute(CHTMLAttributes.AUTOPLAY, CHTMLAttributeValues.AUTOPLAY);
        }
        if (this.m_ePreload != null) {
            iMicroElement.setAttribute(CHTMLAttributes.PRELOAD, (IHasAttributeValue)this.m_ePreload);
        }
        if (this.m_bControls) {
            iMicroElement.setAttribute(CHTMLAttributes.CONTROLS, CHTMLAttributeValues.CONTROLS);
        }
        if (this.m_bLoop) {
            iMicroElement.setAttribute(CHTMLAttributes.LOOP, CHTMLAttributeValues.LOOP);
        }
        if (this.m_bMuted) {
            iMicroElement.setAttribute(CHTMLAttributes.MUTED, CHTMLAttributeValues.MUTED);
        }
        if (this.m_aSrc != null) {
            iMicroElement.setAttribute(CHTMLAttributes.SRC, this.m_aSrc.getWithCharset(iHCConversionSettingsToNode.getCharset()).getAsString());
        }
        if (this.m_eCrossOrigin != null) {
            iMicroElement.setAttribute(CHTMLAttributes.CROSSORIGIN, (IHasAttributeValue)this.m_eCrossOrigin);
        }
    }
}

