/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.hc.html.embedded;

import com.helger.annotation.OverridingMethodsMustInvokeSuper;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.html.CHTMLAttributes;
import com.helger.html.EHTMLElement;
import com.helger.html.hc.IHCConversionSettingsToNode;
import com.helger.html.hc.html.AbstractHCElement;
import com.helger.html.hc.html.HC_Target;
import com.helger.html.hc.html.embedded.IHCArea;
import com.helger.html.hc.html.links.EHCReferrerPolicy;
import com.helger.url.ISimpleURL;
import com.helger.xml.microdom.IHasAttributeValue;
import com.helger.xml.microdom.IMicroElement;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public abstract class AbstractHCArea<IMPLTYPE extends AbstractHCArea<IMPLTYPE>>
extends AbstractHCElement<IMPLTYPE>
implements IHCArea<IMPLTYPE> {
    private String m_sAlt;
    private String m_sCoords;
    private String m_sShape;
    private ISimpleURL m_aHref;
    private HC_Target m_aTarget;
    private String m_sDownload;
    private ISimpleURL m_aPing;
    private String m_sRel;
    private EHCReferrerPolicy m_eReferrerPolicy;

    public AbstractHCArea() {
        super(EHTMLElement.AREA);
    }

    public AbstractHCArea(@Nonnull ISimpleURL iSimpleURL) {
        this();
        this.setHref(iSimpleURL);
    }

    @Override
    @Nullable
    public final String getAlt() {
        return this.m_sAlt;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setAlt(@Nullable String string) {
        this.m_sAlt = string;
        return (IMPLTYPE)((AbstractHCArea)this.thisAsT());
    }

    @Override
    @Nullable
    public final String getCoords() {
        return this.m_sCoords;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setCoords(@Nullable String string) {
        this.m_sCoords = string;
        return (IMPLTYPE)((AbstractHCArea)this.thisAsT());
    }

    @Override
    @Nullable
    public final String getShape() {
        return this.m_sShape;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setShape(@Nullable String string) {
        this.m_sShape = string;
        return (IMPLTYPE)((AbstractHCArea)this.thisAsT());
    }

    @Override
    @Nullable
    public final ISimpleURL getHref() {
        return this.m_aHref;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setHref(@Nonnull ISimpleURL iSimpleURL) {
        ValueEnforcer.notNull((Object)iSimpleURL, (String)"href");
        this.m_aHref = iSimpleURL;
        return (IMPLTYPE)((AbstractHCArea)this.thisAsT());
    }

    @Override
    @Nullable
    public final HC_Target getTarget() {
        return this.m_aTarget;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setTarget(@Nullable HC_Target hC_Target) {
        this.m_aTarget = hC_Target;
        return (IMPLTYPE)((AbstractHCArea)this.thisAsT());
    }

    @Override
    @Nullable
    public final String getDownload() {
        return this.m_sDownload;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setDownload(@Nullable String string) {
        this.m_sDownload = string;
        return (IMPLTYPE)((AbstractHCArea)this.thisAsT());
    }

    @Override
    @Nullable
    public final ISimpleURL getPing() {
        return this.m_aPing;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setPing(@Nullable ISimpleURL iSimpleURL) {
        this.m_aPing = iSimpleURL;
        return (IMPLTYPE)((AbstractHCArea)this.thisAsT());
    }

    @Override
    @Nullable
    public final String getRel() {
        return this.m_sRel;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setRel(@Nullable String string) {
        this.m_sRel = string;
        return (IMPLTYPE)((AbstractHCArea)this.thisAsT());
    }

    @Override
    @Nullable
    public final EHCReferrerPolicy getReferrerPolicy() {
        return this.m_eReferrerPolicy;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setReferrerPolicy(@Nullable EHCReferrerPolicy eHCReferrerPolicy) {
        this.m_eReferrerPolicy = eHCReferrerPolicy;
        return (IMPLTYPE)((AbstractHCArea)this.thisAsT());
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    protected void fillMicroElement(IMicroElement iMicroElement, IHCConversionSettingsToNode iHCConversionSettingsToNode) {
        String string;
        super.fillMicroElement(iMicroElement, iHCConversionSettingsToNode);
        if (StringHelper.isNotEmpty((String)this.m_sAlt)) {
            iMicroElement.setAttribute(CHTMLAttributes.ALT, this.m_sAlt);
        }
        if (StringHelper.isNotEmpty((String)this.m_sCoords)) {
            iMicroElement.setAttribute(CHTMLAttributes.COORDS, this.m_sCoords);
        }
        if (StringHelper.isNotEmpty((String)this.m_sShape)) {
            iMicroElement.setAttribute(CHTMLAttributes.SHAPE, this.m_sShape);
        }
        if (this.m_aHref != null) {
            string = this.m_aHref.getWithCharset(iHCConversionSettingsToNode.getCharset()).getAsString();
            iMicroElement.setAttribute(CHTMLAttributes.HREF, string);
        }
        if (this.m_aTarget != null) {
            iMicroElement.setAttribute(CHTMLAttributes.TARGET, (IHasAttributeValue)this.m_aTarget);
        }
        if (StringHelper.isNotEmpty((String)this.m_sDownload)) {
            iMicroElement.setAttribute(CHTMLAttributes.DOWNLOAD, this.m_sDownload);
        }
        if (this.m_aPing != null) {
            string = this.m_aPing.getWithCharset(iHCConversionSettingsToNode.getCharset()).getAsString();
            iMicroElement.setAttribute(CHTMLAttributes.PING, string);
        }
        if (StringHelper.isNotEmpty((String)this.m_sRel)) {
            iMicroElement.setAttribute(CHTMLAttributes.REL, this.m_sRel);
        }
        if (this.m_eReferrerPolicy != null) {
            iMicroElement.setAttribute(CHTMLAttributes.REFERRERPOLICY, (IHasAttributeValue)this.m_eReferrerPolicy);
        }
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).appendIfNotNull("Href", (Object)this.m_sAlt).appendIfNotNull("Coords", (Object)this.m_sCoords).appendIfNotNull("Shape", (Object)this.m_sShape).appendIfNotNull("Href", (Object)this.m_aHref).appendIfNotNull("Target", (Object)this.m_aTarget).appendIfNotNull("Download", (Object)this.m_sDownload).appendIfNotNull("Ping", (Object)this.m_aPing).appendIfNotNull("Rel", (Object)this.m_sRel).appendIfNotNull("ReferrerPolicy", (Object)this.m_eReferrerPolicy).getToString();
    }
}

