/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.hc.html;

import com.helger.annotation.CheckForSigned;
import com.helger.annotation.Nonempty;
import com.helger.annotation.style.ReturnsMutableObject;
import com.helger.base.state.ETriState;
import com.helger.base.string.StringHelper;
import com.helger.html.EHTMLElement;
import com.helger.html.EHTMLRole;
import com.helger.html.hc.IHCHasID;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.html.EHCContentEditable;
import com.helger.html.hc.html.EHCDraggable;
import com.helger.html.hc.html.EHCInputMode;
import com.helger.html.hc.html.EHCTextDirection;
import com.helger.html.hc.html.IHCAttrContainer;
import com.helger.html.hc.html.IHCHasCSSClasses;
import com.helger.html.hc.html.IHCHasCSSStyles;
import com.helger.html.hc.html.IHCHasJSEventHandler;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.function.Consumer;

public interface IHCElement<IMPLTYPE extends IHCElement<IMPLTYPE>>
extends IHCNode,
IHCHasID<IMPLTYPE>,
IHCHasCSSStyles<IMPLTYPE>,
IHCHasCSSClasses<IMPLTYPE>,
IHCHasJSEventHandler<IMPLTYPE> {
    public static final long DEFAULT_TABINDEX = -5L;

    @Nonnull
    public EHTMLElement getElement();

    @Nonnull
    @Nonempty
    public String getTagName();

    @Nullable
    public String getAccessKey();

    @Nonnull
    public IMPLTYPE setAccessKey(@Nullable String var1);

    public boolean isAutoFocus();

    @Nonnull
    public IMPLTYPE setAutoFocus(boolean var1);

    @Nullable
    public EHCContentEditable getContentEditable();

    @Nonnull
    public IMPLTYPE setContentEditable(@Nullable EHCContentEditable var1);

    @Nullable
    public EHCTextDirection getDirection();

    @Nonnull
    public IMPLTYPE setDirection(@Nullable EHCTextDirection var1);

    @Nullable
    public EHCDraggable getDraggable();

    @Nonnull
    public IMPLTYPE setDraggable(@Nullable EHCDraggable var1);

    @Nullable
    public String getEnterKeyHint();

    @Nonnull
    public IMPLTYPE setEnterKeyHint(@Nullable String var1);

    @Nullable
    public String getExportParts();

    @Nonnull
    public IMPLTYPE setExportParts(@Nullable String var1);

    public boolean isHidden();

    public IMPLTYPE setHidden(boolean var1);

    public boolean isInert();

    public IMPLTYPE setInert(boolean var1);

    @Nullable
    public EHCInputMode getInputMode();

    @Nonnull
    public IMPLTYPE setInputMode(@Nullable EHCInputMode var1);

    @Nullable
    public String getLanguage();

    @Nonnull
    public IMPLTYPE setLanguage(@Nullable String var1);

    @Nullable
    public String getNonce();

    default public boolean hasNonce() {
        return StringHelper.isNotEmpty((String)this.getNonce());
    }

    @Nonnull
    public IMPLTYPE setNonce(@Nullable String var1);

    @Nullable
    public String getPart();

    @Nonnull
    public IMPLTYPE setPart(@Nullable String var1);

    @Nullable
    public String getSlot();

    @Nonnull
    public IMPLTYPE setSlot(@Nullable String var1);

    public boolean isSpellCheck();

    @Nonnull
    public IMPLTYPE setSpellCheck(boolean var1);

    @CheckForSigned
    public long getTabIndex();

    @Nonnull
    public IMPLTYPE setTabIndex(long var1);

    @Nullable
    public String getTitle();

    @Nonnull
    public IMPLTYPE setTitle(String var1);

    public boolean isTranslateOn();

    public boolean isTranslateOff();

    public boolean isTranslateUndefined();

    @Nonnull
    public ETriState getTranslate();

    @Nonnull
    default public IMPLTYPE setTranslate(boolean bl) {
        return this.setTranslate(ETriState.valueOf((boolean)bl));
    }

    @Nonnull
    public IMPLTYPE setTranslate(@Nonnull ETriState var1);

    public boolean isUnfocusable();

    @Nonnull
    public IMPLTYPE setUnfocusable(boolean var1);

    @Nullable
    public EHTMLRole getRole();

    @Nonnull
    public IMPLTYPE setRole(@Nullable EHTMLRole var1);

    @Nonnull
    @ReturnsMutableObject
    public IHCAttrContainer customAttrs();

    @Nonnull
    default public IMPLTYPE withCustomAttrs(@Nonnull Consumer<? super IHCAttrContainer> consumer) {
        consumer.accept(this.customAttrs());
        return (IMPLTYPE)((IHCElement)this.thisAsT());
    }
}

