/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.hc.html;

import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.state.EChange;
import com.helger.base.state.IChangeIndicator;
import com.helger.base.string.StringHelper;
import com.helger.base.string.StringImplode;
import com.helger.collection.CollectionFind;
import com.helger.collection.commons.CommonsLinkedHashMap;
import com.helger.collection.commons.ICommonsOrderedMap;
import com.helger.html.CHTMLAttributes;
import com.helger.html.hc.html.IHCElement;
import com.helger.typeconvert.collection.IAttributeContainer;
import com.helger.xml.microdom.IMicroQName;
import com.helger.xml.microdom.MicroQName;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Map;

public interface IHCAttrContainer
extends IAttributeContainer<IMicroQName, String> {
    @Nonnull
    default public EChange putIn(@Nonnull String string, @Nullable String string2) {
        return this.putIn(new MicroQName(string), string2);
    }

    default public boolean hasDataAttrs() {
        return CollectionFind.containsAny((Iterable)this.keySet(), iMicroQName -> CHTMLAttributes.isDataAttrName(iMicroQName.getName()));
    }

    default public boolean containsDataAttr(@Nullable String string) {
        return this.containsKey(CHTMLAttributes.makeDataAttrName(string));
    }

    @Nullable
    default public String getDataAttrValue(@Nullable String string) {
        return (String)this.getValue(CHTMLAttributes.makeDataAttrName(string));
    }

    @Nonnull
    @ReturnsMutableCopy
    default public ICommonsOrderedMap<IMicroQName, String> getAllDataAttrs() {
        CommonsLinkedHashMap commonsLinkedHashMap = new CommonsLinkedHashMap();
        for (Map.Entry entry : this.entrySet()) {
            if (!CHTMLAttributes.isDataAttrName(((IMicroQName)entry.getKey()).getName())) continue;
            commonsLinkedHashMap.put((Object)((IMicroQName)entry.getKey()), (Object)((String)entry.getValue()));
        }
        return commonsLinkedHashMap;
    }

    @Nonnull
    default public EChange setDataAttr(@Nullable String string, int n) {
        return this.setDataAttr(string, Integer.toString(n));
    }

    @Nonnull
    default public EChange setDataAttr(@Nullable String string, long l) {
        return this.setDataAttr(string, Long.toString(l));
    }

    @Nonnull
    default public EChange setDataAttr(@Nullable String string, @Nullable String string2) {
        return this.putIn(CHTMLAttributes.makeDataAttrName(string), string2);
    }

    @Nonnull
    default public EChange removeDataAttr(@Nullable String string) {
        return this.removeObject(CHTMLAttributes.makeDataAttrName(string));
    }

    @Nonnull
    default public EChange setAriaControls(@Nonnull String string) {
        return this.putIn(CHTMLAttributes.ARIA_CONTROLS, string);
    }

    default public boolean containsAriaDescription() {
        return this.containsKey(CHTMLAttributes.ARIA_DESCRIPTION);
    }

    @Nonnull
    default public EChange setAriaDescription(@Nonnull String string) {
        return this.putIn(CHTMLAttributes.ARIA_DESCRIPTION, string);
    }

    default public boolean containsAriaDescribedBy() {
        return this.containsKey(CHTMLAttributes.ARIA_DESCRIBEDBY);
    }

    @Nonnull
    default public EChange setAriaDescribedBy(@Nonnull String string) {
        return this.putIn(CHTMLAttributes.ARIA_DESCRIBEDBY, string);
    }

    @Nonnull
    default public EChange addToAriaDescribedBy(@Nonnull String string) {
        String string2 = (String)this.getValue(CHTMLAttributes.ARIA_DESCRIBEDBY);
        boolean bl = StringHelper.isNotEmpty((String)string2) && !string2.contains(string);
        return this.setAriaDescribedBy((String)(bl ? string2 + " " + string : string));
    }

    @Nonnull
    default public EChange setAriaDescribedBy(@Nonnull IHCElement<?> iHCElement) {
        return this.setAriaDescribedBy(((IHCElement)iHCElement.ensureID()).getID());
    }

    @Nonnull
    default public EChange addToAriaDescribedBy(@Nonnull IHCElement<?> iHCElement) {
        return this.addToAriaDescribedBy(((IHCElement)iHCElement.ensureID()).getID());
    }

    @Nonnull
    default public EChange setAriaDescribedBy(@Nonnull List<? extends IHCElement<?>> list) {
        return this.setAriaDescribedBy(StringImplode.imploder().source(list, iHCElement -> ((IHCElement)iHCElement.ensureID()).getID()).separator(' ').build());
    }

    @Nonnull
    default public EChange addToAriaDescribedBy(@Nonnull Iterable<? extends IHCElement<?>> iterable) {
        EChange eChange = EChange.UNCHANGED;
        for (IHCElement<?> iHCElement : iterable) {
            eChange = eChange.or((IChangeIndicator)this.addToAriaDescribedBy(iHCElement));
        }
        return eChange;
    }

    @Nonnull
    default public EChange setAriaDescribedBy(IHCElement<?> ... iHCElementArray) {
        return this.setAriaDescribedBy(StringImplode.imploder().source((Object[])iHCElementArray, iHCElement -> ((IHCElement)iHCElement.ensureID()).getID()).separator(' ').build());
    }

    @Nonnull
    default public EChange addToAriaDescribedBy(IHCElement<?> ... iHCElementArray) {
        EChange eChange = EChange.UNCHANGED;
        for (IHCElement<?> iHCElement : iHCElementArray) {
            eChange = eChange.or((IChangeIndicator)this.addToAriaDescribedBy(iHCElement));
        }
        return eChange;
    }

    @Nonnull
    default public EChange setAriaExpanded(boolean bl) {
        return this.putIn(CHTMLAttributes.ARIA_EXPANDED, Boolean.toString(bl));
    }

    @Nonnull
    default public EChange setAriaHasPopup(boolean bl) {
        return this.putIn(CHTMLAttributes.ARIA_HASPOPUP, Boolean.toString(bl));
    }

    @Nonnull
    default public EChange setAriaHidden(boolean bl) {
        return this.putIn(CHTMLAttributes.ARIA_HIDDEN, Boolean.toString(bl));
    }

    @Nonnull
    default public EChange setAriaInvalid(boolean bl) {
        return this.putIn(CHTMLAttributes.ARIA_INVALID, Boolean.toString(bl));
    }

    default public boolean containsAriaLabel() {
        return this.containsKey(CHTMLAttributes.ARIA_LABEL);
    }

    @Nonnull
    default public EChange setAriaLabel(@Nonnull String string) {
        return this.putIn(CHTMLAttributes.ARIA_LABEL, string);
    }

    default public boolean containsAriaLabeledBy() {
        return this.containsKey(CHTMLAttributes.ARIA_LABELLEDBY);
    }

    @Nonnull
    default public EChange setAriaLabeledBy(@Nonnull String string) {
        return this.putIn(CHTMLAttributes.ARIA_LABELLEDBY, string);
    }

    @Nonnull
    default public EChange addToAriaLabeledBy(@Nonnull String string) {
        String string2 = (String)this.getValue(CHTMLAttributes.ARIA_LABELLEDBY);
        boolean bl = StringHelper.isNotEmpty((String)string2) && !string2.contains(string);
        return this.setAriaLabeledBy((String)(bl ? string2 + " " + string : string));
    }

    @Nonnull
    default public EChange setAriaLabeledBy(@Nonnull IHCElement<?> iHCElement) {
        return this.setAriaLabeledBy(((IHCElement)iHCElement.ensureID()).getID());
    }

    @Nonnull
    default public EChange addToAriaLabeledBy(@Nonnull IHCElement<?> iHCElement) {
        return this.addToAriaLabeledBy(((IHCElement)iHCElement.ensureID()).getID());
    }

    @Nonnull
    default public EChange setAriaLabeledBy(@Nonnull List<? extends IHCElement<?>> list) {
        return this.setAriaLabeledBy(StringImplode.imploder().source(list, iHCElement -> ((IHCElement)iHCElement.ensureID()).getID()).separator(' ').build());
    }

    @Nonnull
    default public EChange addToAriaLabeledBy(@Nonnull Iterable<? extends IHCElement<?>> iterable) {
        EChange eChange = EChange.UNCHANGED;
        for (IHCElement<?> iHCElement : iterable) {
            eChange = eChange.or((IChangeIndicator)this.addToAriaLabeledBy(iHCElement));
        }
        return eChange;
    }

    @Nonnull
    default public EChange setAriaLabeledBy(IHCElement<?> ... iHCElementArray) {
        return this.setAriaLabeledBy(StringImplode.imploder().source((Object[])iHCElementArray, iHCElement -> ((IHCElement)iHCElement.ensureID()).getID()).separator(' ').build());
    }

    @Nonnull
    default public EChange addToAriaLabeledBy(IHCElement<?> ... iHCElementArray) {
        EChange eChange = EChange.UNCHANGED;
        for (IHCElement<?> iHCElement : iHCElementArray) {
            eChange = eChange.or((IChangeIndicator)this.addToAriaLabeledBy(iHCElement));
        }
        return eChange;
    }

    @Nonnull
    default public EChange setAriaRequired(boolean bl) {
        return this.putIn(CHTMLAttributes.ARIA_REQUIRED, Boolean.toString(bl));
    }
}

