/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.hc.html;

import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.clone.ICloneable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.html.js.CJS;
import com.helger.html.js.IHasJSCodeWithSettings;
import com.helger.html.js.IJSWriterSettings;
import com.helger.url.ISimpleURL;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.IMicroQName;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.nio.charset.Charset;

@NotThreadSafe
public class HC_Action
implements ICloneable<HC_Action> {
    private ISimpleURL m_aActionURL;
    private IHasJSCodeWithSettings m_aActionJS;

    public HC_Action() {
    }

    public HC_Action(@Nonnull HC_Action hC_Action) {
        ValueEnforcer.notNull((Object)hC_Action, (String)"Other");
        this.m_aActionURL = hC_Action.m_aActionURL;
        this.m_aActionJS = hC_Action.m_aActionJS;
    }

    @Nullable
    public final ISimpleURL getActionURL() {
        return this.m_aActionURL;
    }

    @Nullable
    public final IHasJSCodeWithSettings getActionJS() {
        return this.m_aActionJS;
    }

    public final void setAction(@Nullable ISimpleURL iSimpleURL) {
        this.m_aActionURL = iSimpleURL;
        this.m_aActionJS = null;
    }

    public final void setAction(@Nullable IHasJSCodeWithSettings iHasJSCodeWithSettings) {
        this.m_aActionURL = null;
        this.m_aActionJS = iHasJSCodeWithSettings;
    }

    public void applyProperties(@Nonnull IMicroQName iMicroQName, @Nonnull IMicroElement iMicroElement, @Nonnull IJSWriterSettings iJSWriterSettings, @Nonnull Charset charset) {
        if (this.m_aActionJS != null) {
            String string = this.m_aActionJS.getJSCode(iJSWriterSettings);
            iMicroElement.setAttribute(iMicroQName, CJS.JS_PREFIX + string);
        } else if (this.m_aActionURL != null) {
            iMicroElement.setAttribute(iMicroQName, this.m_aActionURL.getWithCharset(charset).getAsString());
        }
    }

    @Nonnull
    @ReturnsMutableCopy
    public HC_Action getClone() {
        return new HC_Action(this);
    }

    public String toString() {
        return new ToStringGenerator(null).appendIfNotNull("ActionURL", (Object)this.m_aActionURL).appendIfNotNull("ActionJS", (Object)this.m_aActionJS).getToString();
    }
}

