/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.hc.html;

import com.helger.annotation.CheckForSigned;
import com.helger.annotation.Nonempty;
import com.helger.annotation.OverridingMethodsMustInvokeSuper;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.OverrideOnDemand;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.annotation.style.ReturnsMutableObject;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.state.ETriState;
import com.helger.base.string.StringHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.cache.regex.RegExHelper;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.CommonsLinkedHashMap;
import com.helger.collection.commons.CommonsLinkedHashSet;
import com.helger.collection.commons.ICommonsList;
import com.helger.collection.commons.ICommonsOrderedMap;
import com.helger.collection.commons.ICommonsOrderedSet;
import com.helger.css.ICSSWriterSettings;
import com.helger.css.property.ECSSProperty;
import com.helger.css.propertyvalue.ICSSValue;
import com.helger.html.CHTMLAttributeValues;
import com.helger.html.CHTMLAttributes;
import com.helger.html.EHTMLElement;
import com.helger.html.EHTMLRole;
import com.helger.html.EHTMLVersion;
import com.helger.html.css.ICSSClassProvider;
import com.helger.html.hc.IHCConversionSettingsToNode;
import com.helger.html.hc.IHCHasChildrenMutable;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.config.HCConsistencyChecker;
import com.helger.html.hc.html.EHCContentEditable;
import com.helger.html.hc.html.EHCDraggable;
import com.helger.html.hc.html.EHCInputMode;
import com.helger.html.hc.html.EHCTextDirection;
import com.helger.html.hc.html.FakeJS;
import com.helger.html.hc.html.HCAttrContainer;
import com.helger.html.hc.html.IHCAttrContainer;
import com.helger.html.hc.html.IHCElement;
import com.helger.html.hc.impl.AbstractHCNode;
import com.helger.html.js.CJS;
import com.helger.html.js.CollectingJSCodeProvider;
import com.helger.html.js.EJSEvent;
import com.helger.html.js.IHasJSCode;
import com.helger.html.js.IJSWriterSettings;
import com.helger.html.js.JSEventMap;
import com.helger.xml.microdom.IHasAttributeValue;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.IMicroNode;
import com.helger.xml.microdom.IMicroQName;
import com.helger.xml.microdom.MicroElement;
import com.helger.xml.microdom.MicroQName;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Map;

@NotThreadSafe
public abstract class AbstractHCElement<IMPLTYPE extends AbstractHCElement<IMPLTYPE>>
extends AbstractHCNode
implements IHCElement<IMPLTYPE> {
    public static final boolean DEFAULT_AUTO_FOCUS = false;
    public static final boolean DEFAULT_HIDDEN = false;
    public static final boolean DEFAULT_INERT = false;
    public static final boolean DEFAULT_SPELLCHECK = false;
    public static final ETriState DEFAULT_TRANSLATE = ETriState.UNDEFINED;
    public static final boolean DEFAULT_UNFOCUSABLE = false;
    private final EHTMLElement m_eElement;
    private final String m_sElementName;
    private ICommonsOrderedSet<ICSSClassProvider> m_aCSSClassProviders;
    private ICommonsOrderedMap<ECSSProperty, ICSSValue> m_aStyles;
    private JSEventMap m_aJSEvents;
    private String m_sAccessKey;
    private boolean m_bAutoFocus = false;
    private EHCContentEditable m_eContentEditable;
    private EHCTextDirection m_eDirection;
    private EHCDraggable m_eDraggable;
    private String m_sEnterKeyHint;
    private String m_sExportParts;
    private boolean m_bHidden = false;
    private String m_sID;
    private boolean m_bInert = false;
    private EHCInputMode m_eInputMode;
    private String m_sLanguage;
    private String m_sNonce;
    private String m_sPart;
    private String m_sSlot;
    private boolean m_bSpellCheck = false;
    private long m_nTabIndex = -5L;
    private String m_sTitle;
    private ETriState m_eTranslate = DEFAULT_TRANSLATE;
    private EHTMLRole m_eRole;
    private boolean m_bUnfocusable = false;
    private final IHCAttrContainer m_aCustomAttrs = new HCAttrContainer();

    public static boolean isValidID(@Nullable String string) {
        return !StringHelper.isNotEmpty((String)string) || !RegExHelper.stringMatchesPattern((String)".*\\s.*", (String)string);
    }

    protected AbstractHCElement(@Nonnull EHTMLElement eHTMLElement) {
        this.m_eElement = (EHTMLElement)((Object)ValueEnforcer.notNull((Object)((Object)eHTMLElement), (String)"Element"));
        this.m_sElementName = eHTMLElement.getElementName();
    }

    @Override
    @Nonnull
    public final EHTMLElement getElement() {
        return this.m_eElement;
    }

    @Override
    @Nonnull
    @Nonempty
    public final String getTagName() {
        return this.m_sElementName;
    }

    @Override
    public final boolean containsClass(@Nullable ICSSClassProvider iCSSClassProvider) {
        return this.m_aCSSClassProviders != null && iCSSClassProvider != null && this.m_aCSSClassProviders.contains((Object)iCSSClassProvider);
    }

    @Override
    @Nonnull
    public final IMPLTYPE addClass(@Nullable ICSSClassProvider iCSSClassProvider) {
        if (iCSSClassProvider != null) {
            if (this.m_aCSSClassProviders == null) {
                this.m_aCSSClassProviders = new CommonsLinkedHashSet();
            }
            this.m_aCSSClassProviders.add((Object)iCSSClassProvider);
        }
        return (IMPLTYPE)((AbstractHCElement)this.thisAsT());
    }

    @Override
    @Nonnull
    public final IMPLTYPE removeClass(@Nullable ICSSClassProvider iCSSClassProvider) {
        if (this.m_aCSSClassProviders != null && iCSSClassProvider != null) {
            this.m_aCSSClassProviders.remove((Object)iCSSClassProvider);
        }
        return (IMPLTYPE)((AbstractHCElement)this.thisAsT());
    }

    @Override
    @Nonnull
    public final IMPLTYPE removeAllClasses() {
        if (this.m_aCSSClassProviders != null) {
            this.m_aCSSClassProviders.clear();
        }
        return (IMPLTYPE)((AbstractHCElement)this.thisAsT());
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public final ICommonsOrderedSet<ICSSClassProvider> getAllClasses() {
        return new CommonsLinkedHashSet(this.m_aCSSClassProviders);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public final ICommonsOrderedSet<String> getAllClassNames() {
        CommonsLinkedHashSet commonsLinkedHashSet = new CommonsLinkedHashSet();
        if (this.m_aCSSClassProviders != null) {
            for (ICSSClassProvider iCSSClassProvider : this.m_aCSSClassProviders) {
                String string = iCSSClassProvider.getCSSClass();
                if (!StringHelper.isNotEmpty((String)string)) continue;
                commonsLinkedHashSet.add((Object)string);
            }
        }
        return commonsLinkedHashSet;
    }

    @Override
    public final boolean hasAnyClass() {
        return this.m_aCSSClassProviders != null && this.m_aCSSClassProviders.isNotEmpty();
    }

    @Override
    @Nullable
    public final String getAllClassesAsString() {
        if (this.m_aCSSClassProviders == null) {
            return null;
        }
        ICommonsOrderedSet iCommonsOrderedSet = this.m_aCSSClassProviders.getClone();
        int n = iCommonsOrderedSet.size();
        if (n == 0) {
            return null;
        }
        if (n == 1) {
            return ((ICSSClassProvider)iCommonsOrderedSet.getFirst()).getCSSClass();
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (ICSSClassProvider iCSSClassProvider : iCommonsOrderedSet) {
            String string = iCSSClassProvider.getCSSClass();
            if (!StringHelper.isNotEmpty((String)string)) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public final ICommonsOrderedMap<ECSSProperty, ICSSValue> getAllStyles() {
        return new CommonsLinkedHashMap(this.m_aStyles);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public final ICommonsList<ICSSValue> getAllStyleValues() {
        return this.m_aStyles == null ? new CommonsArrayList() : this.m_aStyles.copyOfValues();
    }

    @Override
    @Nullable
    public final ICSSValue getStyleValue(@Nullable ECSSProperty eCSSProperty) {
        return eCSSProperty == null || this.m_aStyles == null ? null : (ICSSValue)this.m_aStyles.get((Object)eCSSProperty);
    }

    @Override
    public final boolean containsStyle(@Nullable ECSSProperty eCSSProperty) {
        return this.m_aStyles != null && this.m_aStyles.containsKey((Object)eCSSProperty);
    }

    @Override
    public final boolean hasStyle(@Nullable ICSSValue iCSSValue) {
        if (iCSSValue == null || this.m_aStyles == null) {
            return false;
        }
        ECSSProperty eCSSProperty = iCSSValue.getProp();
        return EqualsHelper.equals((Object)this.m_aStyles.get((Object)eCSSProperty), (Object)iCSSValue);
    }

    @Override
    public final boolean hasAnyStyle() {
        return this.m_aStyles != null && this.m_aStyles.isNotEmpty();
    }

    @Override
    @Nonnull
    public final IMPLTYPE addStyle(@Nullable ICSSValue iCSSValue) {
        if (iCSSValue != null) {
            if (this.m_aStyles == null) {
                this.m_aStyles = new CommonsLinkedHashMap();
            }
            this.m_aStyles.put((Object)iCSSValue.getProp(), (Object)iCSSValue);
        }
        return (IMPLTYPE)((AbstractHCElement)this.thisAsT());
    }

    @Override
    @Nonnull
    public final IMPLTYPE removeStyle(@Nonnull ECSSProperty eCSSProperty) {
        if (this.m_aStyles != null) {
            this.m_aStyles.remove((Object)eCSSProperty);
        }
        return (IMPLTYPE)((AbstractHCElement)this.thisAsT());
    }

    @Override
    @Nonnull
    public final IMPLTYPE removeAllStyles() {
        this.m_aStyles.clear();
        return (IMPLTYPE)((AbstractHCElement)this.thisAsT());
    }

    @Override
    @Nullable
    public final String getAllStylesAsString(@Nonnull ICSSWriterSettings iCSSWriterSettings) {
        if (this.m_aStyles == null || this.m_aStyles.isEmpty()) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (ICSSValue iCSSValue : this.m_aStyles.values()) {
            stringBuilder.append(iCSSValue.getAsCSSString(iCSSWriterSettings));
        }
        return stringBuilder.toString();
    }

    @Override
    @Nullable
    @ReturnsMutableObject
    public final JSEventMap getEventMap() {
        return this.m_aJSEvents;
    }

    @Override
    @Nullable
    public final IHasJSCode getEventHandler(@Nullable EJSEvent eJSEvent) {
        return this.m_aJSEvents == null ? null : this.m_aJSEvents.getHandler(eJSEvent);
    }

    @Override
    public final boolean containsEventHandler(@Nullable EJSEvent eJSEvent) {
        return this.m_aJSEvents != null && this.m_aJSEvents.containsHandler(eJSEvent);
    }

    @Override
    @Nonnull
    public final IMPLTYPE addEventHandler(@Nonnull EJSEvent eJSEvent, @Nullable IHasJSCode iHasJSCode) {
        if (iHasJSCode != null) {
            if (this.m_aJSEvents == null) {
                this.m_aJSEvents = new JSEventMap();
            }
            this.m_aJSEvents.addHandler(eJSEvent, iHasJSCode);
        }
        return (IMPLTYPE)((AbstractHCElement)this.thisAsT());
    }

    @Override
    @Nonnull
    public final IMPLTYPE prependEventHandler(@Nonnull EJSEvent eJSEvent, @Nullable IHasJSCode iHasJSCode) {
        if (iHasJSCode != null) {
            if (this.m_aJSEvents == null) {
                this.m_aJSEvents = new JSEventMap();
            }
            this.m_aJSEvents.prependHandler(eJSEvent, iHasJSCode);
        }
        return (IMPLTYPE)((AbstractHCElement)this.thisAsT());
    }

    @Override
    @Nonnull
    public final IMPLTYPE setEventHandler(@Nonnull EJSEvent eJSEvent, @Nullable IHasJSCode iHasJSCode) {
        if (iHasJSCode != null) {
            if (this.m_aJSEvents == null) {
                this.m_aJSEvents = new JSEventMap();
            }
            this.m_aJSEvents.setHandler(eJSEvent, iHasJSCode);
        } else if (this.m_aJSEvents != null) {
            this.m_aJSEvents.removeHandler(eJSEvent);
        }
        return (IMPLTYPE)((AbstractHCElement)this.thisAsT());
    }

    @Override
    @Nonnull
    public final IMPLTYPE removeAllEventHandler(@Nullable EJSEvent eJSEvent) {
        if (this.m_aJSEvents != null) {
            this.m_aJSEvents.removeHandler(eJSEvent);
        }
        return (IMPLTYPE)((AbstractHCElement)this.thisAsT());
    }

    @Override
    @Nullable
    public final String getAccessKey() {
        return this.m_sAccessKey;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setAccessKey(@Nullable String string) {
        this.m_sAccessKey = string;
        return (IMPLTYPE)((AbstractHCElement)this.thisAsT());
    }

    @Override
    public final boolean isAutoFocus() {
        return this.m_bAutoFocus;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setAutoFocus(boolean bl) {
        this.m_bAutoFocus = bl;
        return (IMPLTYPE)((AbstractHCElement)this.thisAsT());
    }

    @Override
    @Nullable
    public final EHCContentEditable getContentEditable() {
        return this.m_eContentEditable;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setContentEditable(@Nullable EHCContentEditable eHCContentEditable) {
        this.m_eContentEditable = eHCContentEditable;
        return (IMPLTYPE)((AbstractHCElement)this.thisAsT());
    }

    @Override
    @Nullable
    public final EHCTextDirection getDirection() {
        return this.m_eDirection;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setDirection(@Nullable EHCTextDirection eHCTextDirection) {
        this.m_eDirection = eHCTextDirection;
        return (IMPLTYPE)((AbstractHCElement)this.thisAsT());
    }

    @Override
    @Nullable
    public final EHCDraggable getDraggable() {
        return this.m_eDraggable;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setDraggable(@Nullable EHCDraggable eHCDraggable) {
        this.m_eDraggable = eHCDraggable;
        return (IMPLTYPE)((AbstractHCElement)this.thisAsT());
    }

    @Override
    @Nullable
    public final String getEnterKeyHint() {
        return this.m_sEnterKeyHint;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setEnterKeyHint(@Nullable String string) {
        this.m_sEnterKeyHint = string;
        return (IMPLTYPE)((AbstractHCElement)this.thisAsT());
    }

    @Override
    @Nullable
    public final String getExportParts() {
        return this.m_sExportParts;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setExportParts(@Nullable String string) {
        this.m_sExportParts = string;
        return (IMPLTYPE)((AbstractHCElement)this.thisAsT());
    }

    @Override
    public final boolean isHidden() {
        return this.m_bHidden;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setHidden(boolean bl) {
        this.m_bHidden = bl;
        return (IMPLTYPE)((AbstractHCElement)this.thisAsT());
    }

    @Override
    @Nullable
    public final String getID() {
        return this.m_sID;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setID(@Nullable String string) {
        return this.setID(string, false);
    }

    @Nonnull
    public final IMPLTYPE setID(@Nullable String string, boolean bl) {
        if (!AbstractHCElement.isValidID(string)) {
            HCConsistencyChecker.consistencyError("HC object ID '" + string + "' is invalid!");
        } else {
            if (!bl && this.m_sID != null) {
                if (StringHelper.isNotEmpty((String)string)) {
                    if (!this.m_sID.equals(string)) {
                        HCConsistencyChecker.consistencyError("Overwriting HC object ID '" + this.m_sID + "' with '" + string + "' - this may have side effects!");
                    }
                } else {
                    HCConsistencyChecker.consistencyError("The HC object ID '" + this.m_sID + "' will be removed - this may have side effects");
                }
            }
            this.m_sID = string;
        }
        return (IMPLTYPE)((AbstractHCElement)this.thisAsT());
    }

    @Override
    public final boolean isInert() {
        return this.m_bInert;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setInert(boolean bl) {
        this.m_bInert = bl;
        return (IMPLTYPE)((AbstractHCElement)this.thisAsT());
    }

    @Override
    @Nullable
    public final EHCInputMode getInputMode() {
        return this.m_eInputMode;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setInputMode(EHCInputMode eHCInputMode) {
        this.m_eInputMode = eHCInputMode;
        return (IMPLTYPE)((AbstractHCElement)this.thisAsT());
    }

    @Override
    @Nullable
    public final String getLanguage() {
        return this.m_sLanguage;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setLanguage(@Nullable String string) {
        this.m_sLanguage = string;
        return (IMPLTYPE)((AbstractHCElement)this.thisAsT());
    }

    @Override
    @Nullable
    public final String getNonce() {
        return this.m_sNonce;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setNonce(@Nullable String string) {
        this.m_sNonce = string;
        return (IMPLTYPE)((AbstractHCElement)this.thisAsT());
    }

    @Override
    @Nullable
    public final String getPart() {
        return this.m_sPart;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setPart(@Nullable String string) {
        this.m_sPart = string;
        return (IMPLTYPE)((AbstractHCElement)this.thisAsT());
    }

    @Override
    @Nullable
    public final String getSlot() {
        return this.m_sSlot;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setSlot(@Nullable String string) {
        this.m_sSlot = string;
        return (IMPLTYPE)((AbstractHCElement)this.thisAsT());
    }

    @Override
    public final boolean isSpellCheck() {
        return this.m_bSpellCheck;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setSpellCheck(boolean bl) {
        this.m_bSpellCheck = bl;
        return (IMPLTYPE)((AbstractHCElement)this.thisAsT());
    }

    @Override
    @CheckForSigned
    public final long getTabIndex() {
        return this.m_nTabIndex;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setTabIndex(long l) {
        this.m_nTabIndex = l;
        return (IMPLTYPE)((AbstractHCElement)this.thisAsT());
    }

    @Override
    @Nullable
    public final String getTitle() {
        return this.m_sTitle;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setTitle(@Nullable String string) {
        this.m_sTitle = string;
        return (IMPLTYPE)((AbstractHCElement)this.thisAsT());
    }

    @Override
    public final boolean isTranslateOn() {
        return this.m_eTranslate.isTrue();
    }

    @Override
    public final boolean isTranslateOff() {
        return this.m_eTranslate.isFalse();
    }

    @Override
    public final boolean isTranslateUndefined() {
        return this.m_eTranslate.isUndefined();
    }

    @Override
    @Nonnull
    public final ETriState getTranslate() {
        return this.m_eTranslate;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setTranslate(@Nonnull ETriState eTriState) {
        this.m_eTranslate = (ETriState)ValueEnforcer.notNull((Object)eTriState, (String)"Translate");
        return (IMPLTYPE)((AbstractHCElement)this.thisAsT());
    }

    @Override
    @Nullable
    public final EHTMLRole getRole() {
        return this.m_eRole;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setRole(@Nullable EHTMLRole eHTMLRole) {
        this.m_eRole = eHTMLRole;
        return (IMPLTYPE)((AbstractHCElement)this.thisAsT());
    }

    @Override
    public final boolean isUnfocusable() {
        return this.m_bUnfocusable;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setUnfocusable(boolean bl) {
        this.m_bUnfocusable = bl;
        return (IMPLTYPE)((AbstractHCElement)this.thisAsT());
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public final IHCAttrContainer customAttrs() {
        return this.m_aCustomAttrs;
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    protected void onFinalizeNodeState(@Nonnull IHCConversionSettingsToNode iHCConversionSettingsToNode, @Nonnull IHCHasChildrenMutable<?, ? super IHCNode> iHCHasChildrenMutable) {
        super.onFinalizeNodeState(iHCConversionSettingsToNode, iHCHasChildrenMutable);
        if (this.m_bUnfocusable) {
            this.addEventHandler(EJSEvent.FOCUS, FakeJS.JS_BLUR);
        }
    }

    @Override
    protected void onConsistencyCheck(@Nonnull IHCConversionSettingsToNode iHCConversionSettingsToNode) {
        EHTMLVersion eHTMLVersion = iHCConversionSettingsToNode.getHTMLVersion();
        if (eHTMLVersion.isAtLeastHTML5() && this.m_aCustomAttrs != null) {
            for (Map.Entry entry : this.m_aCustomAttrs.entrySet()) {
                String string = ((IMicroQName)entry.getKey()).getName();
                if (StringHelper.startsWith((String)string, (String)"data-") || StringHelper.startsWith((String)string, (String)"aria-") || this.m_eElement == EHTMLElement.LINK) continue;
                HCConsistencyChecker.consistencyError("Custom HTML5 attribute '" + string + "' does not start with one of the proposed prefixes 'data-' or 'aria-'");
            }
        }
    }

    @Nonnull
    @OverrideOnDemand
    protected IMicroElement createMicroElement(@Nonnull IHCConversionSettingsToNode iHCConversionSettingsToNode) {
        return new MicroElement(iHCConversionSettingsToNode.getHTMLNamespaceURI(), this.m_sElementName);
    }

    @OverridingMethodsMustInvokeSuper
    @OverrideOnDemand
    protected void fillMicroElement(@Nonnull IMicroElement iMicroElement, @Nonnull IHCConversionSettingsToNode iHCConversionSettingsToNode) {
        boolean bl = iHCConversionSettingsToNode.getHTMLVersion().isAtLeastHTML5();
        if (StringHelper.isNotEmpty((String)this.m_sID)) {
            iMicroElement.setAttribute(CHTMLAttributes.ID, this.m_sID);
        }
        if (StringHelper.isNotEmpty((String)this.m_sTitle)) {
            iMicroElement.setAttribute(CHTMLAttributes.TITLE, this.m_sTitle);
        }
        if (StringHelper.isNotEmpty((String)this.m_sLanguage)) {
            iMicroElement.setAttribute((IMicroQName)new MicroQName("http://www.w3.org/XML/1998/namespace", CHTMLAttributes.LANG.getName()), this.m_sLanguage);
            iMicroElement.setAttribute(CHTMLAttributes.LANG, this.m_sLanguage);
        }
        if (this.m_eDirection != null) {
            iMicroElement.setAttribute(CHTMLAttributes.DIR, (IHasAttributeValue)this.m_eDirection);
        }
        iMicroElement.setAttribute(CHTMLAttributes.CLASS, this.getAllClassesAsString());
        iMicroElement.setAttribute(CHTMLAttributes.STYLE, this.getAllStylesAsString(iHCConversionSettingsToNode.getCSSWriterSettings()));
        if (this.m_aJSEvents != null) {
            IJSWriterSettings iJSWriterSettings = iHCConversionSettingsToNode.getJSWriterSettings();
            for (EJSEvent eJSEvent : EJSEvent.values()) {
                CollectingJSCodeProvider collectingJSCodeProvider = this.m_aJSEvents.getHandler(eJSEvent);
                if (collectingJSCodeProvider == null) continue;
                String string = collectingJSCodeProvider.getJSCode(iJSWriterSettings);
                iMicroElement.setAttribute(eJSEvent.getHTMLEventName(), CJS.JS_PREFIX + string);
            }
        }
        if (this.m_nTabIndex != -5L) {
            iMicroElement.setAttribute(CHTMLAttributes.TABINDEX, this.m_nTabIndex);
        }
        if (StringHelper.isNotEmpty((String)this.m_sAccessKey)) {
            iMicroElement.setAttribute(CHTMLAttributes.ACCESSKEY, this.m_sAccessKey);
        }
        if (bl) {
            if (this.m_bAutoFocus) {
                iMicroElement.setAttribute(CHTMLAttributes.AUTOFOCUS, CHTMLAttributeValues.AUTOFOCUS);
            }
            if (this.m_eContentEditable != null) {
                iMicroElement.setAttribute(CHTMLAttributes.CONTENTEDITABLE, (IHasAttributeValue)this.m_eContentEditable);
            }
            if (this.m_eDraggable != null) {
                iMicroElement.setAttribute(CHTMLAttributes.DRAGGABLE, (IHasAttributeValue)this.m_eDraggable);
            }
            if (StringHelper.isNotEmpty((String)this.m_sEnterKeyHint)) {
                iMicroElement.setAttribute(CHTMLAttributes.ENTERKEYHINT, this.m_sEnterKeyHint);
            }
            if (StringHelper.isNotEmpty((String)this.m_sExportParts)) {
                iMicroElement.setAttribute(CHTMLAttributes.EXPORTPARTS, this.m_sExportParts);
            }
            if (this.m_bHidden) {
                iMicroElement.setAttribute(CHTMLAttributes.HIDDEN, CHTMLAttributeValues.HIDDEN);
            }
            if (this.m_bInert) {
                iMicroElement.setAttribute(CHTMLAttributes.INERT, CHTMLAttributeValues.INERT);
            }
            if (this.m_eInputMode != null) {
                iMicroElement.setAttribute(CHTMLAttributes.INPUTMODE, (IHasAttributeValue)this.m_eInputMode);
            }
            if (StringHelper.isNotEmpty((String)this.m_sNonce)) {
                iMicroElement.setAttribute(CHTMLAttributes.NONCE, this.m_sNonce);
            }
            if (StringHelper.isNotEmpty((String)this.m_sPart)) {
                iMicroElement.setAttribute(CHTMLAttributes.PART, this.m_sPart);
            }
            if (StringHelper.isNotEmpty((String)this.m_sSlot)) {
                iMicroElement.setAttribute(CHTMLAttributes.SLOT, this.m_sSlot);
            }
            if (this.m_bSpellCheck) {
                iMicroElement.setAttribute(CHTMLAttributes.SPELLCHECK, CHTMLAttributeValues.SPELLCHECK);
            }
            if (this.m_eTranslate.isDefined()) {
                iMicroElement.setAttribute(CHTMLAttributes.TRANSLATE, this.m_eTranslate.isTrue() ? "yes" : "no");
            }
        }
        if (this.m_eRole != null) {
            iMicroElement.setAttribute(CHTMLAttributes.ROLE, this.m_eRole.getID());
        }
        if (this.m_aCustomAttrs != null) {
            for (Object object : this.m_aCustomAttrs.entrySet()) {
                iMicroElement.setAttribute((IMicroQName)object.getKey(), (String)object.getValue());
            }
        }
    }

    @OverrideOnDemand
    protected void finishMicroElement(@Nonnull IMicroElement iMicroElement, @Nonnull IHCConversionSettingsToNode iHCConversionSettingsToNode) {
    }

    @Override
    @Nonnull
    @OverridingMethodsMustInvokeSuper
    protected IMicroNode internalConvertToMicroNode(@Nonnull IHCConversionSettingsToNode iHCConversionSettingsToNode) {
        IMicroElement iMicroElement = this.createMicroElement(iHCConversionSettingsToNode);
        if (iMicroElement == null) {
            throw new IllegalStateException("Created a null Micro Element!");
        }
        this.fillMicroElement(iMicroElement, iHCConversionSettingsToNode);
        this.finishMicroElement(iMicroElement, iHCConversionSettingsToNode);
        return iMicroElement;
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("Element", (Enum)this.m_eElement).append("ElementName", (Object)this.m_sElementName).appendIfNotNull("Classes", this.m_aCSSClassProviders).appendIfNotNull("Styles", this.m_aStyles).appendIfNotNull("JSEvents", (Object)this.m_aJSEvents).appendIfNotNull("AccessKey", (Object)this.m_sAccessKey).append("AutoFocus", this.m_bAutoFocus).appendIfNotNull("ContentEditable", (Object)this.m_eContentEditable).appendIfNotNull("Direction", (Object)this.m_eDirection).appendIfNotNull("Draggable", (Object)this.m_eDraggable).appendIfNotNull("EnterKeyHint", (Object)this.m_sEnterKeyHint).appendIfNotNull("ExportParts", (Object)this.m_sExportParts).append("Hidden", this.m_bHidden).appendIfNotNull("ID", (Object)this.m_sID).append("Inert", this.m_bInert).appendIfNotNull("InputMode", (Object)this.m_eInputMode).appendIfNotNull("Language", (Object)this.m_sLanguage).appendIfNotNull("Nonce", (Object)this.m_sNonce).appendIfNotNull("Part", (Object)this.m_sPart).appendIfNotNull("Slot", (Object)this.m_sSlot).append("SpellCheck", this.m_bSpellCheck).append("TabIndex", this.m_nTabIndex).appendIfNotNull("Title", (Object)this.m_sTitle).appendIfNotNull("Translate", (Object)this.m_eTranslate).appendIfNotNull("Role", (Object)this.m_eRole).append("Unfocusable", this.m_bUnfocusable).appendIfNotNull("CustomAttrs", (Object)this.m_aCustomAttrs).getToString();
    }
}

