/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.hc.ext;

import com.helger.base.email.IEmailAddress;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.html.hc.html.textlevel.AbstractHCA;
import com.helger.url.ISimpleURL;
import com.helger.url.SimpleURL;
import com.helger.url.protocol.EURLProtocol;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public class HCA_MailTo
extends AbstractHCA<HCA_MailTo> {
    private final String m_sEmailAddress;

    public HCA_MailTo(@Nonnull String string) {
        super((ISimpleURL)new SimpleURL(EURLProtocol.MAILTO.getProtocol() + string));
        this.m_sEmailAddress = (String)ValueEnforcer.notNull((Object)string, (String)"Email");
    }

    @Nonnull
    public String getEmail() {
        return this.m_sEmailAddress;
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("email", (Object)this.m_sEmailAddress).getToString();
    }

    @Nullable
    public static HCA_MailTo createLinkedEmail(@Nullable String string) {
        return HCA_MailTo.createLinkedEmail(string, string);
    }

    @Nullable
    public static HCA_MailTo createLinkedEmail(@Nullable IEmailAddress iEmailAddress) {
        return iEmailAddress == null ? null : HCA_MailTo.createLinkedEmail(iEmailAddress.getAddress(), iEmailAddress.getDisplayName());
    }

    @Nullable
    public static HCA_MailTo createLinkedEmail(@Nullable String string, @Nullable String string2) {
        if (StringHelper.isEmpty((String)string)) {
            return null;
        }
        HCA_MailTo hCA_MailTo = new HCA_MailTo(string);
        hCA_MailTo.addChild(StringHelper.getNotEmpty((String)string2, (String)string));
        return hCA_MailTo;
    }
}

