/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.hc;

import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.numeric.mutable.MutableBoolean;
import com.helger.base.state.EContinue;
import com.helger.base.string.StringHelper;
import com.helger.base.string.StringRemove;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.html.EHTMLElement;
import com.helger.html.hc.IHCIteratorCallback;
import com.helger.html.hc.IHCIteratorNonBreakableCallback;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.IHCNodeList;
import com.helger.html.hc.IHCTextNode;
import com.helger.html.hc.IHCWrappingNode;
import com.helger.xml.microdom.IMicroElement;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.List;

@Immutable
public final class HCHelper {
    private static final char[] ID_REMOVE_CHARS = "[]{}<>-.$/".toCharArray();

    private HCHelper() {
    }

    @Nonnull
    private static EContinue _recursiveIterateTreeBreakable(@Nonnull IHCNode iHCNode, @Nonnull IHCIteratorCallback iHCIteratorCallback) {
        if (iHCNode.hasChildren()) {
            for (IHCNode iHCNode2 : iHCNode.getAllChildren()) {
                if (iHCIteratorCallback.call(iHCNode, iHCNode2).isBreak()) {
                    return EContinue.BREAK;
                }
                if (!HCHelper._recursiveIterateTreeBreakable(iHCNode2, iHCIteratorCallback).isBreak()) continue;
                return EContinue.BREAK;
            }
        }
        return EContinue.CONTINUE;
    }

    @Nonnull
    private static EContinue _recursiveIterateTreeBreakableNoCopy(@Nonnull IHCNode iHCNode, @Nonnull IHCIteratorCallback iHCIteratorCallback) {
        if (iHCNode.hasChildren()) {
            for (IHCNode iHCNode2 : iHCNode.getChildren()) {
                if (iHCIteratorCallback.call(iHCNode, iHCNode2).isBreak()) {
                    return EContinue.BREAK;
                }
                if (!HCHelper._recursiveIterateTreeBreakableNoCopy(iHCNode2, iHCIteratorCallback).isBreak()) continue;
                return EContinue.BREAK;
            }
        }
        return EContinue.CONTINUE;
    }

    public static void iterateTree(@Nonnull IHCNode iHCNode, @Nonnull IHCIteratorCallback iHCIteratorCallback) {
        ValueEnforcer.notNull((Object)iHCNode, (String)"node");
        ValueEnforcer.notNull((Object)iHCIteratorCallback, (String)"callback");
        if (iHCIteratorCallback.call(null, iHCNode).isContinue()) {
            HCHelper._recursiveIterateTreeBreakable(iHCNode, iHCIteratorCallback);
        }
    }

    public static void iterateTreeNoCopy(@Nonnull IHCNode iHCNode, @Nonnull IHCIteratorCallback iHCIteratorCallback) {
        ValueEnforcer.notNull((Object)iHCNode, (String)"node");
        ValueEnforcer.notNull((Object)iHCIteratorCallback, (String)"callback");
        if (iHCIteratorCallback.call(null, iHCNode).isContinue()) {
            HCHelper._recursiveIterateTreeBreakableNoCopy(iHCNode, iHCIteratorCallback);
        }
    }

    public static void iterateChildren(@Nonnull IHCNode iHCNode, @Nonnull IHCIteratorCallback iHCIteratorCallback) {
        ValueEnforcer.notNull((Object)iHCNode, (String)"node");
        ValueEnforcer.notNull((Object)iHCIteratorCallback, (String)"callback");
        HCHelper._recursiveIterateTreeBreakable(iHCNode, iHCIteratorCallback);
    }

    public static void iterateChildrenNoCopy(@Nonnull IHCNode iHCNode, @Nonnull IHCIteratorCallback iHCIteratorCallback) {
        ValueEnforcer.notNull((Object)iHCNode, (String)"node");
        ValueEnforcer.notNull((Object)iHCIteratorCallback, (String)"callback");
        HCHelper._recursiveIterateTreeBreakableNoCopy(iHCNode, iHCIteratorCallback);
    }

    private static void _iterateTreeNonBreakable(@Nonnull ICommonsList<IHCNode> iCommonsList, @Nonnull ICommonsList<IHCNode> iCommonsList2, @Nonnull IHCIteratorNonBreakableCallback iHCIteratorNonBreakableCallback) {
        while (iCommonsList.isNotEmpty()) {
            IHCNode iHCNode = (IHCNode)iCommonsList.remove(0);
            IHCNode iHCNode2 = (IHCNode)iCommonsList2.remove(0);
            iHCIteratorNonBreakableCallback.call(iHCNode, iHCNode2);
            if (!iHCNode2.hasChildren()) continue;
            for (IHCNode iHCNode3 : iHCNode2.getChildren()) {
                iCommonsList.add((Object)iHCNode2);
                iCommonsList2.add((Object)iHCNode3);
            }
        }
    }

    public static void iterateTreeNonBreakable(@Nonnull IHCNode iHCNode, @Nonnull IHCIteratorNonBreakableCallback iHCIteratorNonBreakableCallback) {
        ValueEnforcer.notNull((Object)iHCNode, (String)"node");
        ValueEnforcer.notNull((Object)iHCIteratorNonBreakableCallback, (String)"callback");
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        CommonsArrayList commonsArrayList2 = new CommonsArrayList();
        commonsArrayList.add(null);
        commonsArrayList2.add((Object)iHCNode);
        HCHelper._iterateTreeNonBreakable((ICommonsList<IHCNode>)commonsArrayList, (ICommonsList<IHCNode>)commonsArrayList2, iHCIteratorNonBreakableCallback);
    }

    public static void iterateChildrenNonBreakable(@Nonnull IHCNode iHCNode, @Nonnull IHCIteratorNonBreakableCallback iHCIteratorNonBreakableCallback) {
        ValueEnforcer.notNull((Object)iHCNode, (String)"node");
        ValueEnforcer.notNull((Object)iHCIteratorNonBreakableCallback, (String)"callback");
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        CommonsArrayList commonsArrayList2 = new CommonsArrayList();
        if (iHCNode.hasChildren()) {
            for (IHCNode iHCNode2 : iHCNode.getChildren()) {
                commonsArrayList.add((Object)iHCNode);
                commonsArrayList2.add((Object)iHCNode2);
            }
        }
        HCHelper._iterateTreeNonBreakable((ICommonsList<IHCNode>)commonsArrayList, (ICommonsList<IHCNode>)commonsArrayList2, iHCIteratorNonBreakableCallback);
    }

    public static boolean recursiveContainsAtLeastOneTextNode(@Nullable IHCNode iHCNode3) {
        if (iHCNode3 == null) {
            return false;
        }
        if (iHCNode3 instanceof IHCTextNode) {
            return true;
        }
        MutableBoolean mutableBoolean = new MutableBoolean(false);
        HCHelper.iterateChildrenNoCopy(iHCNode3, (iHCNode, iHCNode2) -> {
            if (iHCNode2 instanceof IHCTextNode) {
                mutableBoolean.set(true);
                return EContinue.BREAK;
            }
            return EContinue.CONTINUE;
        });
        return mutableBoolean.booleanValue();
    }

    @Nullable
    public static IMicroElement getFirstChildElement(@Nonnull IMicroElement iMicroElement, @Nonnull EHTMLElement eHTMLElement) {
        ValueEnforcer.notNull((Object)iMicroElement, (String)"element");
        ValueEnforcer.notNull((Object)((Object)eHTMLElement), (String)"HTMLElement");
        IMicroElement iMicroElement2 = iMicroElement.getFirstChildElement(eHTMLElement.getElementName());
        if (iMicroElement2 == null) {
            iMicroElement2 = iMicroElement.getFirstChildElement(eHTMLElement.getElementNameUpperCase());
        }
        return iMicroElement2;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsList<IMicroElement> getChildElements(@Nonnull IMicroElement iMicroElement, @Nonnull EHTMLElement eHTMLElement) {
        ValueEnforcer.notNull((Object)iMicroElement, (String)"element");
        ValueEnforcer.notNull((Object)((Object)eHTMLElement), (String)"HTMLElement");
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        commonsArrayList.addAll((Collection)iMicroElement.getAllChildElements(eHTMLElement.getElementName()));
        commonsArrayList.addAll((Collection)iMicroElement.getAllChildElements(eHTMLElement.getElementNameUpperCase()));
        return commonsArrayList;
    }

    private static void _recursiveAddFlattened(@Nullable IHCNode iHCNode2, @Nonnull List<IHCNode> list) {
        ValueEnforcer.notNull(list, (String)"RealList");
        if (iHCNode2 != null) {
            if (iHCNode2 instanceof IHCNodeList) {
                IHCNodeList iHCNodeList = (IHCNodeList)iHCNode2;
                iHCNodeList.forAllChildren(iHCNode -> HCHelper._recursiveAddFlattened(iHCNode, list));
            } else {
                list.add(iHCNode2);
            }
        }
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsList<IHCNode> getAsFlattenedList(@Nullable IHCNode iHCNode) {
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        HCHelper._recursiveAddFlattened(iHCNode, (List<IHCNode>)commonsArrayList);
        return commonsArrayList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsList<IHCNode> getAsFlattenedList(@Nullable Iterable<? extends IHCNode> iterable) {
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        if (iterable != null) {
            for (IHCNode iHCNode : iterable) {
                HCHelper._recursiveAddFlattened(iHCNode, (List<IHCNode>)commonsArrayList);
            }
        }
        return commonsArrayList;
    }

    @Nullable
    public static IHCNode getUnwrappedNode(@Nullable IHCNode iHCNode) {
        if (HCHelper.isWrappedNode(iHCNode)) {
            return HCHelper.getUnwrappedNode(((IHCWrappingNode)iHCNode).getWrappedNode());
        }
        return iHCNode;
    }

    public static boolean isWrappedNode(@Nullable IHCNode iHCNode) {
        return iHCNode instanceof IHCWrappingNode;
    }

    @Nonnull
    public static String getAsHTMLID(@Nullable String string) {
        String string2 = StringHelper.getNotNull((String)string, (String)"").trim();
        return (string2 = StringRemove.removeMultiple((String)string2, (char[])ID_REMOVE_CHARS)).isEmpty() ? "_" : string2;
    }
}

