/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.entity;

import com.helger.annotation.Nonempty;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.io.stream.StreamHelper;
import com.helger.collection.commons.CommonsHashMap;
import com.helger.collection.commons.ICommonsMap;
import com.helger.collection.commons.ICommonsSet;
import com.helger.io.resource.ClassPathResource;
import com.helger.xml.sax.InputSourceFactory;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.InputStream;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public final class HTMLEntityResolver
implements EntityResolver {
    private static final HTMLEntityResolver INSTANCE = new HTMLEntityResolver();
    private final ICommonsMap<String, byte[]> m_aResolveMap = new CommonsHashMap();

    private void _addResolvablePublicId(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2) {
        if (this.m_aResolveMap.containsKey((Object)string)) {
            throw new IllegalArgumentException("Passed public id '" + string + "' is already contained!");
        }
        InputStream inputStream = ClassPathResource.getInputStream((String)string2);
        if (inputStream == null) {
            throw new IllegalArgumentException("The passed resource " + string2 + " does not exist!");
        }
        byte[] byArray = StreamHelper.getAllBytes((InputStream)inputStream);
        this.m_aResolveMap.put((Object)string, (Object)byArray);
    }

    private HTMLEntityResolver() {
        this._addResolvablePublicId("-//W3C//DTD XHTML 1.0 Strict//EN", "external/html/xhtml1-strict.dtd");
        this._addResolvablePublicId("-//W3C//DTD XHTML 1.0 Transitional//EN", "external/html/xhtml1-transitional.dtd");
        this._addResolvablePublicId("-//W3C//DTD XHTML 1.1//EN", "external/html/xhtml11.dtd");
        this._addResolvablePublicId("-//W3C//ENTITIES Latin 1 for XHTML//EN", "external/html/xhtml-lat1.ent");
        this._addResolvablePublicId("-//W3C//ENTITIES Symbols for XHTML//EN", "external/html/xhtml-symbol.ent");
        this._addResolvablePublicId("-//W3C//ENTITIES Special for XHTML//EN", "external/html/xhtml-special.ent");
        this._addResolvablePublicId("-//W3C//ELEMENTS XHTML Inline Style 1.0//EN", "external/html/xhtml-inlstyle-1.mod");
        this._addResolvablePublicId("-//W3C//ENTITIES XHTML 1.1 Document Model 1.0//EN", "external/html/xhtml11-model-1.mod");
        this._addResolvablePublicId("-//W3C//ENTITIES XHTML Modular Framework 1.0//EN", "external/html/xhtml-framework-1.mod");
        this._addResolvablePublicId("-//W3C//ELEMENTS XHTML Text 1.0//EN", "external/html/xhtml-text-1.mod");
        this._addResolvablePublicId("-//W3C//ELEMENTS XHTML Hypertext 1.0//EN", "external/html/xhtml-hypertext-1.mod");
        this._addResolvablePublicId("-//W3C//ELEMENTS XHTML Lists 1.0//EN", "external/html/xhtml-list-1.mod");
        this._addResolvablePublicId("-//W3C//ELEMENTS XHTML Editing Elements 1.0//EN", "external/html/xhtml-edit-1.mod");
        this._addResolvablePublicId("-//W3C//ELEMENTS XHTML BIDI Override Element 1.0//EN", "external/html/xhtml-bdo-1.mod");
        this._addResolvablePublicId("-//W3C//ELEMENTS XHTML Ruby 1.0//EN", "external/html/xhtml-ruby-1.mod");
        this._addResolvablePublicId("-//W3C//ELEMENTS XHTML Presentation 1.0//EN", "external/html/xhtml-pres-1.mod");
        this._addResolvablePublicId("-//W3C//ELEMENTS XHTML Link Element 1.0//EN", "external/html/xhtml-link-1.mod");
        this._addResolvablePublicId("-//W3C//ELEMENTS XHTML Metainformation 1.0//EN", "external/html/xhtml-meta-1.mod");
        this._addResolvablePublicId("-//W3C//ELEMENTS XHTML Base Element 1.0//EN", "external/html/xhtml-base-1.mod");
        this._addResolvablePublicId("-//W3C//ELEMENTS XHTML Scripting 1.0//EN", "external/html/xhtml-script-1.mod");
        this._addResolvablePublicId("-//W3C//ELEMENTS XHTML Style Sheets 1.0//EN", "external/html/xhtml-style-1.mod");
        this._addResolvablePublicId("-//W3C//ELEMENTS XHTML Images 1.0//EN", "external/html/xhtml-image-1.mod");
        this._addResolvablePublicId("-//W3C//ELEMENTS XHTML Client-side Image Maps 1.0//EN", "external/html/xhtml-csismap-1.mod");
        this._addResolvablePublicId("-//W3C//ELEMENTS XHTML Server-side Image Maps 1.0//EN", "external/html/xhtml-ssismap-1.mod");
        this._addResolvablePublicId("-//W3C//ELEMENTS XHTML Param Element 1.0//EN", "external/html/xhtml-param-1.mod");
        this._addResolvablePublicId("-//W3C//ELEMENTS XHTML Embedded Object 1.0//EN", "external/html/xhtml-object-1.mod");
        this._addResolvablePublicId("-//W3C//ELEMENTS XHTML Tables 1.0//EN", "external/html/xhtml-table-1.mod");
        this._addResolvablePublicId("-//W3C//ELEMENTS XHTML Forms 1.0//EN", "external/html/xhtml-form-1.mod");
        this._addResolvablePublicId("-//W3C//ELEMENTS XHTML Target 1.0//EN", "external/html/xhtml-target-1.mod");
        this._addResolvablePublicId("-//W3C//ELEMENTS XHTML Legacy Markup 1.0//EN", "external/html/xhtml-legacy-1.mod");
        this._addResolvablePublicId("-//W3C//ELEMENTS XHTML Document Structure 1.0//EN", "external/html/xhtml-struct-1.mod");
        this._addResolvablePublicId("-//W3C//ELEMENTS XHTML Base Architecture 1.0//EN", "external/html/xhtml-arch-1.mod");
        this._addResolvablePublicId("-//W3C//NOTATIONS XHTML Notations 1.0//EN", "external/html/xhtml-notations-1.mod");
        this._addResolvablePublicId("-//W3C//ENTITIES XHTML Datatypes 1.0//EN", "external/html/xhtml-datatypes-1.mod");
        this._addResolvablePublicId("-//W3C//ENTITIES XHTML Qualified Names 1.0//EN", "external/html/xhtml-qname-1.mod");
        this._addResolvablePublicId("-//W3C//ENTITIES XHTML Intrinsic Events 1.0//EN", "external/html/xhtml-events-1.mod");
        this._addResolvablePublicId("-//W3C//ENTITIES XHTML Common Attributes 1.0//EN", "external/html/xhtml-attribs-1.mod");
        this._addResolvablePublicId("-//W3C//ENTITIES XHTML Character Entities 1.0//EN", "external/html/xhtml-charent-1.mod");
        this._addResolvablePublicId("-//W3C//ELEMENTS XHTML Inline Structural 1.0//EN", "external/html/xhtml-inlstruct-1.mod");
        this._addResolvablePublicId("-//W3C//ELEMENTS XHTML Inline Phrasal 1.0//EN", "external/html/xhtml-inlphras-1.mod");
        this._addResolvablePublicId("-//W3C//ELEMENTS XHTML Block Structural 1.0//EN", "external/html/xhtml-blkstruct-1.mod");
        this._addResolvablePublicId("-//W3C//ELEMENTS XHTML Block Phrasal 1.0//EN", "external/html/xhtml-blkphras-1.mod");
        this._addResolvablePublicId("-//W3C//ELEMENTS XHTML Inline Presentation 1.0//EN", "external/html/xhtml-inlpres-1.mod");
        this._addResolvablePublicId("-//W3C//ELEMENTS XHTML Block Presentation 1.0//EN", "external/html/xhtml-blkpres-1.mod");
    }

    @Nonnull
    public static HTMLEntityResolver getInstance() {
        return INSTANCE;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsSet<String> getAllPublicIds() {
        return this.m_aResolveMap.copyOfKeySet();
    }

    @Override
    @Nullable
    public InputSource resolveEntity(@Nullable String string, @Nullable String string2) {
        return this.resolveEntity(string);
    }

    @Nullable
    public InputSource resolveEntity(@Nullable String string) {
        byte[] byArray = (byte[])this.m_aResolveMap.get((Object)string);
        return byArray == null ? null : InputSourceFactory.create((byte[])byArray);
    }
}

