/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.uictrls.datatables.plugins;

import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.state.ETriState;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.html.css.DefaultCSSClassProvider;
import com.helger.html.css.ICSSClassProvider;
import com.helger.html.hc.IHCConversionSettingsToNode;
import com.helger.html.jscode.IJSExpression;
import com.helger.html.jscode.JSAnonymousFunction;
import com.helger.html.jscode.JSArray;
import com.helger.html.jscode.JSAssocArray;
import com.helger.html.jscode.JSExpr;
import com.helger.html.resource.css.ICSSPathProvider;
import com.helger.html.resource.js.IJSPathProvider;
import com.helger.photon.app.html.PhotonCSS;
import com.helger.photon.app.html.PhotonJS;
import com.helger.photon.uictrls.datatables.DataTables;
import com.helger.photon.uictrls.datatables.EDataTablesCSSPathProvider;
import com.helger.photon.uictrls.datatables.EDataTablesJSPathProvider;
import com.helger.photon.uictrls.datatables.column.DataTablesColumnDef;
import com.helger.photon.uictrls.datatables.plugins.AbstractDataTablesPlugin;
import com.helger.photon.uictrls.datatables.plugins.DTPResponsiveBreakpoint;
import com.helger.photon.uictrls.datatables.plugins.EDTPResponsiveType;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public class DataTablesPluginResponsive
extends AbstractDataTablesPlugin {
    public static final String PLUGIN_NAME = "responsive";
    public static final ICSSClassProvider CSS_CLASS_ALL = DefaultCSSClassProvider.create((String)"all");
    public static final ICSSClassProvider CSS_CLASS_CONTROL = DefaultCSSClassProvider.create((String)"control");
    public static final ICSSClassProvider CSS_CLASS_NONE = DefaultCSSClassProvider.create((String)"none");
    public static final ICSSClassProvider CSS_CLASS_NEVER = DefaultCSSClassProvider.create((String)"never");
    private ICommonsList<DTPResponsiveBreakpoint> m_aBreakpoints;
    private ETriState m_eDetails = ETriState.UNDEFINED;
    private JSAnonymousFunction m_aDetailsRenderer;
    private IJSExpression m_aDetailsTarget;
    private EDTPResponsiveType m_eDetailsType;

    public DataTablesPluginResponsive() {
        super(PLUGIN_NAME);
    }

    @Nonnull
    public DataTablesPluginResponsive addBreakpoint(@Nonnull DTPResponsiveBreakpoint dTPResponsiveBreakpoint) {
        ValueEnforcer.notNull((Object)dTPResponsiveBreakpoint, (String)"Breakpoint");
        if (this.m_aBreakpoints == null) {
            this.m_aBreakpoints = new CommonsArrayList();
        }
        this.m_aBreakpoints.add((Object)dTPResponsiveBreakpoint);
        return this;
    }

    @Nonnull
    public DataTablesPluginResponsive setDetails(@Nonnull ETriState eTriState) {
        ValueEnforcer.notNull((Object)eTriState, (String)"Details");
        this.m_eDetails = eTriState;
        return this;
    }

    @Nonnull
    public DataTablesPluginResponsive setDetailsRenderer(@Nullable JSAnonymousFunction jSAnonymousFunction) {
        this.m_aDetailsRenderer = jSAnonymousFunction;
        return this;
    }

    @Nonnull
    public DataTablesPluginResponsive setDetailsTarget(int n) {
        return this.setDetailsTarget((IJSExpression)JSExpr.lit((int)n));
    }

    @Nonnull
    public DataTablesPluginResponsive setDetailsTarget(String string) {
        return this.setDetailsTarget((IJSExpression)JSExpr.lit((String)string));
    }

    @Nonnull
    public DataTablesPluginResponsive setDetailsTarget(@Nullable IJSExpression iJSExpression) {
        this.m_aDetailsTarget = iJSExpression;
        return this;
    }

    @Nonnull
    public DataTablesPluginResponsive setDetailsType(@Nullable EDTPResponsiveType eDTPResponsiveType) {
        this.m_eDetailsType = eDTPResponsiveType;
        return this;
    }

    @Override
    public void finalizeDataTablesSettings(@Nonnull DataTables dataTables) {
        for (DataTablesColumnDef dataTablesColumnDef : dataTables.columnDefs()) {
            if (dataTablesColumnDef.isVisible()) continue;
            dataTablesColumnDef.addClass(CSS_CLASS_NEVER);
        }
    }

    @Override
    @Nullable
    public IJSExpression getInitParams() {
        JSArray jSArray;
        JSAssocArray jSAssocArray = new JSAssocArray();
        if (this.m_aBreakpoints != null) {
            jSArray = new JSArray();
            for (DTPResponsiveBreakpoint dTPResponsiveBreakpoint : this.m_aBreakpoints) {
                jSArray.add((IJSExpression)dTPResponsiveBreakpoint.getAsJS());
            }
            jSAssocArray.add("breakpoints", (IJSExpression)jSArray);
        }
        jSArray = new JSAssocArray();
        if (this.m_aDetailsRenderer != null) {
            jSArray.add("renderer", (IJSExpression)this.m_aDetailsRenderer);
        }
        if (this.m_aDetailsTarget != null) {
            jSArray.add("target", this.m_aDetailsTarget);
        }
        if (this.m_eDetailsType != null) {
            jSArray.add("type", this.m_eDetailsType.getName());
        }
        if (!jSArray.isEmpty()) {
            jSAssocArray.add("details", (IJSExpression)jSArray);
        } else if (this.m_eDetails.isDefined()) {
            jSAssocArray.add("details", this.m_eDetails.getAsBooleanValue(true));
        }
        if (jSAssocArray.isEmpty()) {
            return JSExpr.TRUE;
        }
        return jSAssocArray;
    }

    @Override
    public void registerExternalResources(IHCConversionSettingsToNode iHCConversionSettingsToNode) {
        PhotonJS.registerJSIncludeForThisRequest((IJSPathProvider)EDataTablesJSPathProvider.DATATABLES_RESPONSIVE);
        PhotonCSS.registerCSSIncludeForThisRequest((ICSSPathProvider)EDataTablesCSSPathProvider.DATATABLES_RESPONSIVE);
    }
}

