/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.uictrls.datatables.plugins;

import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.state.ETriState;
import com.helger.html.hc.IHCConversionSettingsToNode;
import com.helger.html.jscode.IJSExpression;
import com.helger.html.jscode.JSAssocArray;
import com.helger.html.jscode.JSExpr;
import com.helger.html.resource.css.ICSSPathProvider;
import com.helger.html.resource.js.IJSPathProvider;
import com.helger.photon.app.html.PhotonCSS;
import com.helger.photon.app.html.PhotonJS;
import com.helger.photon.uictrls.datatables.EDataTablesCSSPathProvider;
import com.helger.photon.uictrls.datatables.EDataTablesJSPathProvider;
import com.helger.photon.uictrls.datatables.plugins.AbstractDataTablesPlugin;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public class DataTablesPluginFixedHeader
extends AbstractDataTablesPlugin {
    public static final String PLUGIN_NAME = "fixedHeader";
    public static final boolean DEFAULT_FOOTER = false;
    public static final int DEFAULT_FOOTER_OFFSET = 0;
    public static final boolean DEFAULT_HEADER = true;
    public static final int DEFAULT_HEADER_OFFSET = 0;
    private ETriState m_eFooter = ETriState.UNDEFINED;
    private Integer m_aFooterOffset;
    private ETriState m_eHeader = ETriState.UNDEFINED;
    private Integer m_aHeaderOffset;

    public DataTablesPluginFixedHeader() {
        super(PLUGIN_NAME);
    }

    @Nonnull
    public DataTablesPluginFixedHeader setFooter(boolean bl) {
        return this.setFooter(ETriState.valueOf((boolean)bl));
    }

    @Nonnull
    public DataTablesPluginFixedHeader setFooter(@Nonnull ETriState eTriState) {
        ValueEnforcer.notNull((Object)eTriState, (String)"Footer");
        this.m_eFooter = eTriState;
        return this;
    }

    @Nonnull
    public DataTablesPluginFixedHeader setFooterOffset(int n) {
        return this.setFooterOffset((Integer)n);
    }

    @Nonnull
    public DataTablesPluginFixedHeader setFooterOffset(@Nullable Integer n) {
        this.m_aFooterOffset = n;
        return this;
    }

    @Nonnull
    public DataTablesPluginFixedHeader setHeader(boolean bl) {
        return this.setHeader(ETriState.valueOf((boolean)bl));
    }

    @Nonnull
    public DataTablesPluginFixedHeader setHeader(@Nonnull ETriState eTriState) {
        ValueEnforcer.notNull((Object)eTriState, (String)"Header");
        this.m_eHeader = eTriState;
        return this;
    }

    @Nonnull
    public DataTablesPluginFixedHeader setHeaderOffset(int n) {
        return this.setHeaderOffset((Integer)n);
    }

    @Nonnull
    public DataTablesPluginFixedHeader setHeaderOffset(@Nullable Integer n) {
        this.m_aHeaderOffset = n;
        return this;
    }

    @Override
    @Nullable
    public IJSExpression getInitParams() {
        JSAssocArray jSAssocArray = new JSAssocArray();
        if (this.m_eFooter.isDefined()) {
            jSAssocArray.add("footer", this.m_eFooter.getAsBooleanValue(false));
        }
        if (this.m_aFooterOffset != null) {
            jSAssocArray.add("footerOffset", this.m_aFooterOffset.intValue());
        }
        if (this.m_eHeader.isDefined()) {
            jSAssocArray.add("header", this.m_eHeader.getAsBooleanValue(true));
        }
        if (this.m_aHeaderOffset != null) {
            jSAssocArray.add("headerOffset", this.m_aHeaderOffset.intValue());
        }
        if (jSAssocArray.isEmpty()) {
            return JSExpr.TRUE;
        }
        return jSAssocArray;
    }

    @Override
    public void registerExternalResources(IHCConversionSettingsToNode iHCConversionSettingsToNode) {
        PhotonJS.registerJSIncludeForThisRequest((IJSPathProvider)EDataTablesJSPathProvider.DATATABLES_FIXED_HEADER);
        PhotonCSS.registerCSSIncludeForThisRequest((ICSSPathProvider)EDataTablesCSSPathProvider.DATATABLES_FIXED_HEADER);
    }
}

