/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.uictrls.datatables.plugins;

import com.helger.annotation.Nonempty;
import com.helger.annotation.style.OverrideOnDemand;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHelper;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.html.hc.IHCConversionSettingsToNode;
import com.helger.html.jscode.IJSExpression;
import com.helger.html.jscode.JSArray;
import com.helger.html.jscode.JSAssocArray;
import com.helger.html.jscode.JSAtom;
import com.helger.html.jscode.JSExpr;
import com.helger.html.resource.css.ICSSPathProvider;
import com.helger.html.resource.js.IJSPathProvider;
import com.helger.photon.app.html.PhotonCSS;
import com.helger.photon.app.html.PhotonJS;
import com.helger.photon.uictrls.datatables.DataTables;
import com.helger.photon.uictrls.datatables.DataTablesDom;
import com.helger.photon.uictrls.datatables.EDataTablesCSSPathProvider;
import com.helger.photon.uictrls.datatables.EDataTablesJSPathProvider;
import com.helger.photon.uictrls.datatables.plugins.AbstractDataTablesPlugin;
import com.helger.photon.uictrls.datatables.plugins.DTPButtonsButton;
import com.helger.photon.uictrls.datatables.plugins.DTPButtonsDom;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public class DataTablesPluginButtons
extends AbstractDataTablesPlugin {
    public static final String PLUGIN_NAME = "buttons";
    public static final String DEFAULT_NAME = "main";
    private final ICommonsList<Object> m_aButtons = new CommonsArrayList();
    private DTPButtonsDom m_aDom;
    private String m_sName;

    public DataTablesPluginButtons() {
        super(PLUGIN_NAME);
    }

    @Nonnull
    @ReturnsMutableCopy
    @OverrideOnDemand
    protected DataTablesDom createDom() {
        return new DataTablesDom();
    }

    @OverrideOnDemand
    protected void weaveIntoDom(@Nonnull DataTablesDom dataTablesDom) {
        dataTablesDom.setPosition(0).addCustom("B").openDiv("clear").closeDiv();
    }

    @Override
    public void finalizeDataTablesSettings(@Nonnull DataTables dataTables) {
        DataTablesDom dataTablesDom = dataTables.directGetDom();
        if (dataTablesDom == null) {
            dataTablesDom = this.createDom();
            dataTables.setDom(dataTablesDom);
        }
        this.weaveIntoDom(dataTablesDom);
    }

    @Nonnull
    public DataTablesPluginButtons addButton(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Button");
        this.m_aButtons.add((Object)string);
        return this;
    }

    @Nonnull
    public DataTablesPluginButtons addButton(@Nonnull DTPButtonsButton dTPButtonsButton) {
        ValueEnforcer.notNull((Object)dTPButtonsButton, (String)"Button");
        this.m_aButtons.add((Object)dTPButtonsButton);
        return this;
    }

    @Nonnull
    public DataTablesPluginButtons setDom(@Nullable DTPButtonsDom dTPButtonsDom) {
        this.m_aDom = dTPButtonsDom;
        return this;
    }

    @Nonnull
    public DataTablesPluginButtons setName(@Nullable String string) {
        this.m_sName = string;
        return this;
    }

    @Override
    @Nullable
    public IJSExpression getInitParams() {
        JSArray jSArray;
        JSAssocArray jSAssocArray = new JSAssocArray();
        if (this.m_aButtons.isNotEmpty()) {
            jSArray = new JSArray();
            for (Object e : this.m_aButtons) {
                if (e instanceof String) {
                    jSArray.add((String)e);
                    continue;
                }
                jSArray.add(((DTPButtonsButton)e).getAsJS());
            }
            jSAssocArray.add(PLUGIN_NAME, (IJSExpression)jSArray);
        }
        if (this.m_aDom != null) {
            jSAssocArray.add("dom", (IJSExpression)this.m_aDom.getAsJS());
        }
        if (StringHelper.isNotEmpty((String)this.m_sName)) {
            jSAssocArray.add("name", this.m_sName);
        }
        if (jSAssocArray.size() == 1 && (jSArray = jSAssocArray.get((IJSExpression)new JSAtom(PLUGIN_NAME))) != null) {
            return jSArray;
        }
        if (jSAssocArray.isEmpty()) {
            return JSExpr.TRUE;
        }
        return jSAssocArray;
    }

    @Override
    public void registerExternalResources(@Nonnull IHCConversionSettingsToNode iHCConversionSettingsToNode) {
        PhotonJS.registerJSIncludeForThisRequest((IJSPathProvider)EDataTablesJSPathProvider.DATATABLES_BUTTONS);
        PhotonCSS.registerCSSIncludeForThisRequest((ICSSPathProvider)EDataTablesCSSPathProvider.DATATABLES_BUTTONS);
        for (Object e : this.m_aButtons) {
            if (!(e instanceof DTPButtonsButton)) continue;
            ((DTPButtonsButton)e).registerExternalResources(iHCConversionSettingsToNode);
        }
    }
}

