/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.uictrls.datatables.plugins;

import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.state.ETriState;
import com.helger.html.hc.IHCConversionSettingsToNode;
import com.helger.html.jscode.IJSExpression;
import com.helger.html.jscode.JSAssocArray;
import com.helger.html.jscode.JSExpr;
import com.helger.photon.uictrls.datatables.plugins.DTPButtonsButton;
import com.helger.photon.uictrls.datatables.plugins.EDTPButtonsButtonType;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public class DTPButtonsButtonColumnsToggle
extends DTPButtonsButton {
    private IJSExpression m_aColumns;
    private ETriState m_eVisibility = ETriState.UNDEFINED;

    public DTPButtonsButtonColumnsToggle() {
        this.setExtend(EDTPButtonsButtonType.COLUMNS_TOGGLE.getName());
    }

    @Nonnull
    public DTPButtonsButtonColumnsToggle setColumns(@Nullable String string) {
        return this.setColumns((IJSExpression)(string == null ? null : JSExpr.lit((String)string)));
    }

    @Nonnull
    public DTPButtonsButtonColumnsToggle setColumns(@Nullable IJSExpression iJSExpression) {
        this.m_aColumns = iJSExpression;
        return this;
    }

    @Nonnull
    public DTPButtonsButtonColumnsToggle setVisibility(boolean bl) {
        return this.setVisibility(ETriState.valueOf((boolean)bl));
    }

    @Nonnull
    public DTPButtonsButtonColumnsToggle setVisibility(@Nonnull ETriState eTriState) {
        ValueEnforcer.notNull((Object)eTriState, (String)"Visibility");
        this.m_eVisibility = eTriState;
        return this;
    }

    @Override
    protected void onGetAsJS(@Nonnull JSAssocArray jSAssocArray) {
        if (this.m_aColumns != null) {
            jSAssocArray.add("columns", this.m_aColumns);
        }
        if (this.m_eVisibility.isDefined()) {
            jSAssocArray.add("visibility", this.m_eVisibility.getAsBooleanValue(true));
        }
    }

    @Override
    public void registerExternalResources(@Nonnull IHCConversionSettingsToNode iHCConversionSettingsToNode) {
        super.registerExternalResources(iHCConversionSettingsToNode);
        EDTPButtonsButtonType.COLUMNS_TOGGLE.registerExternalResources();
    }
}

