/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.uictrls.datatables.column;

import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.array.ArrayHelper;
import com.helger.base.compare.ESortOrder;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHelper;
import com.helger.base.version.Version;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.html.tabular.AbstractHCCol;
import com.helger.html.hc.impl.HCTextNode;
import com.helger.masterdata.currency.ECurrency;
import com.helger.photon.uicore.css.CUICoreCSS;
import com.helger.photon.uictrls.datatables.column.ComparatorDT;
import com.helger.photon.uictrls.datatables.column.DTOrderSpec;
import com.helger.photon.uictrls.datatables.column.EDTColType;
import com.helger.photon.uictrls.datatables.column.IComparableExtractor;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Locale;
import java.util.function.Function;

public class DTCol
extends AbstractHCCol<DTCol> {
    private IHCNode m_aHeaderNode;
    private EDTColType m_eColType;
    private ESortOrder m_eInitialSorting;
    private boolean m_bSearchable = true;
    private boolean m_bOrderable = true;
    private boolean m_bVisible = true;
    private String m_sName;
    private int[] m_aDataSort;
    private final DTOrderSpec m_aOrderSpec = new DTOrderSpec();

    public DTCol() {
        this((IHCNode)null);
    }

    public DTCol(@Nullable String string) {
        this((IHCNode)HCTextNode.createOnDemand((String)string));
    }

    public DTCol(@Nullable IHCNode iHCNode) {
        this.setHeaderNode(iHCNode);
    }

    @Nullable
    public EDTColType getColType() {
        return this.m_eColType;
    }

    @Nonnull
    public DTCol setDisplayType(@Nonnull EDTColType eDTColType, @Nonnull Locale locale) {
        return this.setDisplayType(eDTColType, locale, null);
    }

    @Nonnull
    public DTCol setDisplayType(@Nonnull EDTColType eDTColType, @Nonnull Locale locale, @Nullable Function<String, String> function) {
        ValueEnforcer.notNull((Object)((Object)eDTColType), (String)"BaseType");
        ValueEnforcer.notNull((Object)locale, (String)"DisplayLocale");
        this.m_eColType = eDTColType;
        this.m_aOrderSpec.setDisplayLocale(locale);
        switch (eDTColType) {
            case BOOLEAN: {
                this.m_aOrderSpec.setCollating(false);
                break;
            }
            case DATE: {
                this.addClass(CUICoreCSS.CSS_CLASS_RIGHT);
                this.m_aOrderSpec.setComparableExtractor(function, ComparatorDT.getExtractorDate(locale));
                this.m_aOrderSpec.setCollating(false);
                break;
            }
            case DATETIME: {
                this.addClass(CUICoreCSS.CSS_CLASS_RIGHT);
                this.m_aOrderSpec.setComparableExtractor(function, ComparatorDT.getExtractorDateTime(locale));
                this.m_aOrderSpec.setCollating(false);
                break;
            }
            case DOUBLE: {
                this.addClass(CUICoreCSS.CSS_CLASS_RIGHT);
                this.m_aOrderSpec.setComparableExtractor(function, ComparatorDT.getExtractorBigDecimal(locale));
                this.m_aOrderSpec.setCollating(false);
                break;
            }
            case DURATION: {
                this.m_aOrderSpec.setComparableExtractor(function, ComparatorDT.getExtractorDuration());
                this.m_aOrderSpec.setCollating(false);
                break;
            }
            case INT: {
                this.addClass(CUICoreCSS.CSS_CLASS_RIGHT);
                this.m_aOrderSpec.setComparableExtractor(function, ComparatorDT.getExtractorBigInteger(locale));
                this.m_aOrderSpec.setCollating(false);
                break;
            }
            case TEXT: {
                this.m_aOrderSpec.setComparableExtractor(function, string -> string);
                this.m_aOrderSpec.setCollating(true);
                break;
            }
            case TIME: {
                this.addClass(CUICoreCSS.CSS_CLASS_RIGHT);
                this.m_aOrderSpec.setComparableExtractor(function, ComparatorDT.getExtractorTime(locale));
                this.m_aOrderSpec.setCollating(false);
                break;
            }
            case VERSION: {
                this.m_aOrderSpec.setComparableExtractor(function, Version::parse);
                this.m_aOrderSpec.setCollating(false);
                break;
            }
            case XML: {
                this.setOrderable(false);
                this.m_aOrderSpec.setCollating(false);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported base type provided: " + String.valueOf((Object)eDTColType));
            }
        }
        return this;
    }

    @Nonnull
    public DTCol setDisplayTypeCurrency(@Nonnull ECurrency eCurrency) {
        ValueEnforcer.notNull((Object)eCurrency, (String)"Currency");
        this.m_aOrderSpec.setComparableExtractor(null, ComparatorDT.getExtractorCurrencyFormat(eCurrency));
        this.addClass(CUICoreCSS.CSS_CLASS_RIGHT);
        return this;
    }

    @Nonnull
    public DTCol setDisplayTypePercentage(@Nonnull Locale locale) {
        return this.setDisplayType(EDTColType.DOUBLE, locale, string -> StringHelper.trimEnd((String)string, (String)"%"));
    }

    @Nonnull
    public IHCNode getHeaderNode() {
        return this.m_aHeaderNode;
    }

    @Nonnull
    public DTCol setHeaderNode(@Nullable IHCNode iHCNode) {
        this.m_aHeaderNode = iHCNode;
        return this;
    }

    @Nonnull
    public ESortOrder getInitialSorting() {
        return this.m_eInitialSorting;
    }

    public boolean hasInitialSorting() {
        return this.m_eInitialSorting != null;
    }

    @Nonnull
    public DTCol setInitialSorting(@Nullable ESortOrder eSortOrder) {
        this.m_eInitialSorting = eSortOrder;
        return this;
    }

    public boolean isSearchable() {
        return this.m_bSearchable;
    }

    @Nonnull
    public DTCol setSearchable(boolean bl) {
        this.m_bSearchable = bl;
        return this;
    }

    public boolean isOrderable() {
        return this.m_bOrderable;
    }

    @Nonnull
    public DTCol setOrderable(boolean bl) {
        this.m_bOrderable = bl;
        return this;
    }

    public boolean isVisible() {
        return this.m_bVisible;
    }

    @Nonnull
    public DTCol setVisible(boolean bl) {
        this.m_bVisible = bl;
        return this;
    }

    @Nullable
    public String getName() {
        return this.m_sName;
    }

    @Nonnull
    public DTCol setName(@Nullable String string) {
        this.m_sName = string;
        return this;
    }

    @Nullable
    @ReturnsMutableCopy
    public int[] getDataSort() {
        return ArrayHelper.getCopy((int[])this.m_aDataSort);
    }

    @Nonnull
    public DTCol setDataSort(int ... nArray) {
        this.m_aDataSort = ArrayHelper.getCopy((int[])nArray);
        return this;
    }

    @Nonnull
    public DTOrderSpec getOrderSpec() {
        return this.m_aOrderSpec;
    }

    @Nonnull
    public DTCol setCollating(boolean bl) {
        this.m_aOrderSpec.setCollating(bl);
        return this;
    }

    @Nonnull
    public <T extends Comparable<? super T>> DTCol setComparableExtractor(@Nullable Function<String, String> function, @Nullable IComparableExtractor<T> iComparableExtractor) {
        this.m_aOrderSpec.setComparableExtractor(function, iComparableExtractor);
        return this;
    }
}

