/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.uictrls.datatables.ajax;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableObject;
import com.helger.base.string.StringHelper;
import com.helger.collection.CollectionHelper;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.CommonsLinkedHashMap;
import com.helger.collection.commons.ICommonsList;
import com.helger.collection.commons.ICommonsOrderedMap;
import com.helger.html.CHTMLAttributes;
import com.helger.html.hc.html.tabular.HCRow;
import com.helger.html.hc.html.tabular.IHCCell;
import com.helger.photon.uictrls.datatables.ajax.DataTablesServerDataCell;
import com.helger.xml.microdom.IMicroQName;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public final class DataTablesServerDataRow {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataTablesServerDataRow.class);
    private final String m_sRowID;
    private final String m_sRowClass;
    private ICommonsOrderedMap<IMicroQName, String> m_aRowData;
    private ICommonsOrderedMap<IMicroQName, String> m_aRowAttr;
    private final ICommonsList<DataTablesServerDataCell> m_aCells;

    public DataTablesServerDataRow(@Nonnull HCRow hCRow) {
        if (hCRow.hasAnyStyle()) {
            LOGGER.warn("Cell has styles assigned which will be lost: " + String.valueOf(hCRow.getAllStyles()));
        }
        this.m_sRowID = hCRow.getID();
        this.m_sRowClass = hCRow.getAllClassesAsString();
        for (Map.Entry entry : hCRow.customAttrs().entrySet()) {
            IMicroQName iMicroQName = (IMicroQName)entry.getKey();
            if (CHTMLAttributes.isDataAttrName((IMicroQName)iMicroQName)) {
                if (this.m_aRowData == null) {
                    this.m_aRowData = new CommonsLinkedHashMap();
                }
                this.m_aRowData.put((Object)iMicroQName, (Object)((String)entry.getValue()));
                continue;
            }
            if (this.m_aRowAttr == null) {
                this.m_aRowAttr = new CommonsLinkedHashMap();
            }
            this.m_aRowAttr.put((Object)iMicroQName, (Object)((String)entry.getValue()));
        }
        this.m_aCells = new CommonsArrayList(hCRow.getCellCount());
        for (Map.Entry entry : hCRow.getChildren()) {
            this.m_aCells.add((Object)new DataTablesServerDataCell((IHCCell<?>)entry));
        }
    }

    public boolean hasRowID() {
        return StringHelper.isNotEmpty((String)this.m_sRowID);
    }

    @Nullable
    public String getRowID() {
        return this.m_sRowID;
    }

    public boolean hasRowClass() {
        return StringHelper.isNotEmpty((String)this.m_sRowClass);
    }

    @Nullable
    public String getRowClass() {
        return this.m_sRowClass;
    }

    public boolean hasRowData() {
        return CollectionHelper.isNotEmpty(this.m_aRowData);
    }

    @Nonnull
    @ReturnsMutableObject(value="speed")
    public ICommonsOrderedMap<IMicroQName, String> directGetAllRowData() {
        return this.m_aRowData;
    }

    public boolean hasRowAttr() {
        return CollectionHelper.isNotEmpty(this.m_aRowAttr);
    }

    @Nullable
    @ReturnsMutableObject(value="speed")
    public ICommonsOrderedMap<IMicroQName, String> directGetAllRowAttrs() {
        return this.m_aRowAttr;
    }

    @Nonnull
    @ReturnsMutableObject
    public ICommonsList<DataTablesServerDataCell> directGetAllCells() {
        return this.m_aCells;
    }

    @Nonnull
    public DataTablesServerDataCell getCellAtIndex(@Nonnegative int n) {
        return (DataTablesServerDataCell)this.m_aCells.get(n);
    }
}

