/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.uictrls.datatables.ajax;

import com.helger.base.string.StringHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.cache.regex.RegExHelper;
import com.helger.html.hc.IHCConversionSettings;
import com.helger.html.hc.IHCConversionSettingsToNode;
import com.helger.html.hc.IHCNodeList;
import com.helger.html.hc.config.IHCOnDocumentReadyProvider;
import com.helger.html.hc.html.tabular.IHCCell;
import com.helger.html.hc.impl.HCNodeList;
import com.helger.html.hc.render.HCRenderer;
import com.helger.html.hc.special.AbstractHCSpecialNodes;
import com.helger.html.hc.special.HCSpecialNodeHandler;
import com.helger.html.hc.special.HCSpecialNodes;
import com.helger.html.hc.special.IHCSpecialNodes;
import com.helger.photon.uictrls.datatables.ajax.DataTablesServerData;
import com.helger.xml.microdom.IMicroNode;
import com.helger.xml.microdom.IMicroNodeWithChildren;
import com.helger.xml.microdom.IMicroText;
import com.helger.xml.microdom.serialize.MicroWriter;
import com.helger.xml.serialize.write.IXMLWriterSettings;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.BitSet;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DataTablesServerDataCell {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataTablesServerDataCell.class);
    private IHCNodeList<?> m_aContent;
    private HCSpecialNodes m_aLazySpecialNodes;
    private IMicroNode m_aLazyMicroNode;
    private String m_sLazyHTML;
    private String m_sLazyTextContent;

    public DataTablesServerDataCell(@Nonnull IHCCell<?> iHCCell) {
        if (iHCCell.hasAnyStyle()) {
            LOGGER.warn("Cell has styles assigned which will be lost: " + String.valueOf(iHCCell.getAllStyles()));
        }
        if (iHCCell.hasAnyClass()) {
            LOGGER.warn("Cell has classes assigned which will be lost: " + String.valueOf(iHCCell.getAllClasses()));
        }
        IHCNodeList iHCNodeList = iHCCell.getAllChildrenAsNodeList();
        this.setContent(iHCNodeList);
    }

    private void writeObject(@Nonnull ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.m_aContent);
        objectOutputStream.writeObject(this.m_aLazySpecialNodes);
    }

    private void readObject(@Nonnull ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.m_aContent = (HCNodeList)objectInputStream.readObject();
        this.m_aLazySpecialNodes = (HCSpecialNodes)objectInputStream.readObject();
    }

    public void setContent(@Nonnull IHCNodeList<?> iHCNodeList) {
        if (this.m_aLazySpecialNodes != null) {
            this.m_aLazySpecialNodes.clear();
        }
        IHCConversionSettings iHCConversionSettings = DataTablesServerData.DEFAULT_CONVERSION_SETTINGS;
        HCRenderer.prepareForConversion(iHCNodeList, iHCNodeList, (IHCConversionSettingsToNode)iHCConversionSettings);
        if (iHCConversionSettings.isExtractOutOfBandNodes()) {
            if (this.m_aLazySpecialNodes == null) {
                this.m_aLazySpecialNodes = new HCSpecialNodes();
            }
            IHCOnDocumentReadyProvider iHCOnDocumentReadyProvider = null;
            HCSpecialNodeHandler.extractSpecialContent(iHCNodeList, (AbstractHCSpecialNodes)this.m_aLazySpecialNodes, iHCOnDocumentReadyProvider);
            if (this.m_aLazySpecialNodes.isEmpty()) {
                this.m_aLazySpecialNodes = null;
            }
        }
        this.m_aContent = iHCNodeList;
        this.m_aLazyMicroNode = null;
        this.m_sLazyHTML = null;
        this.m_sLazyTextContent = null;
    }

    @Nonnull
    public IHCNodeList<?> getContent() {
        return this.m_aContent;
    }

    @Nullable
    private IMicroNode _getOrCreateMicroNode() {
        IMicroNode iMicroNode = this.m_aLazyMicroNode;
        if (iMicroNode == null) {
            this.m_aLazyMicroNode = iMicroNode = this.m_aContent.convertToMicroNode((IHCConversionSettingsToNode)DataTablesServerData.DEFAULT_CONVERSION_SETTINGS);
            if (iMicroNode == null) {
                this.m_sLazyHTML = "";
                this.m_sLazyTextContent = "";
            }
        }
        return iMicroNode;
    }

    @Nullable
    public String getHTMLString() {
        String string = this.m_sLazyHTML;
        if (string == null) {
            IMicroNode iMicroNode = this._getOrCreateMicroNode();
            string = this.m_sLazyHTML;
            if (string == null) {
                assert (iMicroNode != null);
                string = MicroWriter.getNodeAsString((IMicroNode)iMicroNode, (IXMLWriterSettings)DataTablesServerData.DEFAULT_CONVERSION_SETTINGS.getXMLWriterSettings());
                if (string == null) {
                    string = "";
                }
                this.m_sLazyHTML = string;
            }
        }
        return string;
    }

    @Nonnull
    public String getTextContent() {
        String string = this.m_sLazyTextContent;
        if (string == null) {
            IMicroNode iMicroNode = this._getOrCreateMicroNode();
            string = this.m_sLazyTextContent;
            if (string == null) {
                assert (iMicroNode != null);
                if (iMicroNode instanceof IMicroNodeWithChildren) {
                    string = ((IMicroNodeWithChildren)iMicroNode).getTextContent();
                } else if (iMicroNode.isText()) {
                    if (!((IMicroText)iMicroNode).isElementContentWhitespace()) {
                        string = iMicroNode.getNodeValue();
                    }
                } else if (iMicroNode.isCDATA()) {
                    string = iMicroNode.getNodeValue();
                }
                if (string == null) {
                    string = "";
                }
                this.m_sLazyTextContent = string;
            }
        }
        return this.m_sLazyTextContent;
    }

    @Nullable
    public IHCSpecialNodes getSpecialNodes() {
        return this.m_aLazySpecialNodes;
    }

    public void matchRegEx(@Nonnull String[] stringArray, @Nonnull BitSet bitSet) {
        String string = this.getTextContent();
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (!RegExHelper.stringMatchesPattern((String)string2, (String)string)) continue;
            bitSet.set(i);
        }
    }

    public void matchPlainTextCaseSensitive(@Nonnull String[] stringArray, @Nonnull BitSet bitSet) {
        String string = this.getTextContent();
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (!StringHelper.contains((String)string, (String)string2)) continue;
            bitSet.set(i);
        }
    }

    public void matchPlainTextIgnoreCase(@Nonnull String[] stringArray, @Nonnull Locale locale, @Nonnull BitSet bitSet) {
        String string = this.getTextContent();
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (!StringHelper.containsIgnoreCase((String)string, (String)string2, (Locale)locale)) continue;
            bitSet.set(i);
        }
    }

    @Nonnull
    public String toString() {
        return new ToStringGenerator((Object)this).append("Content", this.m_aContent).getToString();
    }
}

