/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.uictrls.datatables.ajax;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.base.compare.ESortOrder;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.photon.uictrls.datatables.column.DTOrderSpec;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Comparator;

@NotThreadSafe
public final class DTSSRequestDataOrderColumn {
    private final int m_nColumnIndex;
    private final ESortOrder m_eSortOrder;
    private DTOrderSpec m_aOrderSpec;

    public DTSSRequestDataOrderColumn(@Nonnegative int n, @Nullable ESortOrder eSortOrder) {
        this.m_nColumnIndex = n;
        this.m_eSortOrder = eSortOrder;
    }

    @Nonnegative
    public int getColumnIndex() {
        return this.m_nColumnIndex;
    }

    @Nullable
    public ESortOrder getSortOrder() {
        return this.m_eSortOrder;
    }

    @Nonnull
    public ESortOrder getSortDirectionOrDefault() {
        return this.m_eSortOrder == null ? ESortOrder.DEFAULT : this.m_eSortOrder;
    }

    public void setOrderSpec(@Nonnull DTOrderSpec dTOrderSpec) {
        ValueEnforcer.notNull((Object)dTOrderSpec, (String)"OrderSpec");
        this.m_aOrderSpec = dTOrderSpec;
    }

    @Nonnull
    public Comparator<String> getOrderComparator() {
        DTOrderSpec dTOrderSpec = this.m_aOrderSpec;
        Comparator<Object> comparator = dTOrderSpec == null ? Comparator.naturalOrder() : dTOrderSpec.getComparator();
        boolean bl = this.getSortDirectionOrDefault().isAscending();
        if (!bl) {
            comparator = comparator.reversed();
        }
        if (bl) {
            return Comparator.nullsFirst(comparator);
        }
        return Comparator.nullsLast(comparator);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        DTSSRequestDataOrderColumn dTSSRequestDataOrderColumn = (DTSSRequestDataOrderColumn)object;
        return this.m_nColumnIndex == dTSSRequestDataOrderColumn.m_nColumnIndex && EqualsHelper.equals((Object)this.m_eSortOrder, (Object)dTSSRequestDataOrderColumn.m_eSortOrder);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_nColumnIndex).append((Object)this.m_eSortOrder).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("ColumnIndex", this.m_nColumnIndex).append("SortOrder", (Enum)this.m_eSortOrder).append("OrderSpec", (Object)this.m_aOrderSpec).getToString();
    }
}

