/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.uictrls.datatables.ajax;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.annotation.style.ReturnsMutableObject;
import com.helger.base.array.ArrayHelper;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.CollectionFind;
import com.helger.collection.commons.ICommonsList;
import com.helger.photon.uictrls.datatables.ajax.DTSSRequestDataColumn;
import com.helger.photon.uictrls.datatables.ajax.DTSSRequestDataOrderColumn;
import com.helger.photon.uictrls.datatables.ajax.DTSSRequestDataSearch;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public final class DTSSRequestData {
    private final int m_nDraw;
    private final int m_nDisplayStart;
    private final int m_nDisplayLength;
    private final DTSSRequestDataSearch m_aSearch;
    private final ICommonsList<DTSSRequestDataColumn> m_aColumnData;
    private final ICommonsList<DTSSRequestDataOrderColumn> m_aOrderColumns;

    public DTSSRequestData(int n, int n2, int n3, @Nullable String string, boolean bl, @Nonnull ICommonsList<DTSSRequestDataColumn> iCommonsList, @Nonnull ICommonsList<DTSSRequestDataOrderColumn> iCommonsList2) {
        ValueEnforcer.notNull(iCommonsList, (String)"ColumnData");
        ValueEnforcer.isFalse(() -> CollectionFind.containsAnyNullElement((Iterable)iCommonsList), (String)"ColumnData may not contain null elements");
        ValueEnforcer.notNull(iCommonsList2, (String)"OrderColumns");
        this.m_nDraw = n;
        this.m_nDisplayStart = n2;
        this.m_nDisplayLength = n3;
        this.m_aSearch = new DTSSRequestDataSearch(string, bl);
        this.m_aColumnData = iCommonsList;
        this.m_aOrderColumns = iCommonsList2;
    }

    public int getDraw() {
        return this.m_nDraw;
    }

    public int getDisplayStart() {
        return this.m_nDisplayStart;
    }

    public int getDisplayLength() {
        return this.m_nDisplayLength;
    }

    public boolean showAllEntries() {
        return this.m_nDisplayLength == -1;
    }

    public int getColumnCount() {
        return this.m_aColumnData.size();
    }

    public boolean isSearchActive() {
        if (this.m_aSearch.hasSearchText()) {
            return true;
        }
        for (DTSSRequestDataColumn dTSSRequestDataColumn : this.m_aColumnData) {
            if (!dTSSRequestDataColumn.isSearchable() || !dTSSRequestDataColumn.getSearch().hasSearchText()) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    public DTSSRequestDataSearch getSearch() {
        return this.m_aSearch;
    }

    @Nonnull
    public DTSSRequestDataColumn getColumn(@Nonnegative int n) {
        return (DTSSRequestDataColumn)this.m_aColumnData.get(n);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<DTSSRequestDataColumn> getColumnData() {
        return (ICommonsList)this.m_aColumnData.getClone();
    }

    @Nonnull
    @ReturnsMutableCopy
    public DTSSRequestDataColumn[] getColumnDataArray() {
        return (DTSSRequestDataColumn[])ArrayHelper.createArray(this.m_aColumnData, DTSSRequestDataColumn.class);
    }

    @Nonnegative
    public int getOrderColumnCount() {
        return this.m_aOrderColumns.size();
    }

    @Nonnull
    @ReturnsMutableObject(value="speed")
    public ICommonsList<DTSSRequestDataOrderColumn> directGetAllOrderColumns() {
        return this.m_aOrderColumns;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Draw", this.m_nDraw).append("DisplayStart", this.m_nDisplayStart).append("DisplayLength", this.m_nDisplayLength).append("Search", (Object)this.m_aSearch).append("OrderColumns", this.m_aOrderColumns).append("ColumnData", this.m_aColumnData).getToString();
    }
}

