/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.uictrls.datatables.ajax;

import com.helger.base.compare.IComparator;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.ICommonsList;
import com.helger.photon.uictrls.datatables.ajax.DTSSRequestDataOrderColumn;
import com.helger.photon.uictrls.datatables.ajax.DataTablesServerDataCell;
import com.helger.photon.uictrls.datatables.ajax.DataTablesServerDataRow;
import com.helger.photon.uictrls.datatables.ajax.DataTablesServerSortState;
import jakarta.annotation.Nonnull;

final class ComparatorDataTablesServerDataRow
implements IComparator<DataTablesServerDataRow> {
    private final ICommonsList<DTSSRequestDataOrderColumn> m_aOrderColumns;

    ComparatorDataTablesServerDataRow(@Nonnull DataTablesServerSortState dataTablesServerSortState) {
        ValueEnforcer.notNull((Object)dataTablesServerSortState, (String)"ServerSortState");
        this.m_aOrderColumns = dataTablesServerSortState.directGetAllOrderColumns();
    }

    public int compare(@Nonnull DataTablesServerDataRow dataTablesServerDataRow, @Nonnull DataTablesServerDataRow dataTablesServerDataRow2) {
        int n = 0;
        for (DTSSRequestDataOrderColumn dTSSRequestDataOrderColumn : this.m_aOrderColumns) {
            int n2 = dTSSRequestDataOrderColumn.getColumnIndex();
            DataTablesServerDataCell dataTablesServerDataCell = dataTablesServerDataRow.getCellAtIndex(n2);
            DataTablesServerDataCell dataTablesServerDataCell2 = dataTablesServerDataRow2.getCellAtIndex(n2);
            String string = dataTablesServerDataCell.getTextContent();
            String string2 = dataTablesServerDataCell2.getTextContent();
            n = dTSSRequestDataOrderColumn.getOrderComparator().compare(string, string2);
            if (n == 0) continue;
            break;
        }
        return n;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("OrderColumns", this.m_aOrderColumns).getToString();
    }
}

