/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.uictrls.datatables;

import com.helger.annotation.CheckForSigned;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.text.display.IHasDisplayText;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Locale;

@Immutable
public class DataTablesLengthMenuItem
implements IHasDisplayText {
    private final int m_nItemCount;
    private final IHasDisplayText m_aText;

    public DataTablesLengthMenuItem(int n, @Nonnull IHasDisplayText iHasDisplayText) {
        this.m_nItemCount = n;
        this.m_aText = (IHasDisplayText)ValueEnforcer.notNull((Object)iHasDisplayText, (String)"Text");
    }

    public boolean isAllItem() {
        return this.m_nItemCount == -1;
    }

    @CheckForSigned
    public int getItemCount() {
        return this.m_nItemCount;
    }

    @Nonnull
    public IHasDisplayText getText() {
        return this.m_aText;
    }

    @Nullable
    public String getDisplayText(@Nonnull Locale locale) {
        return this.m_aText.getDisplayText(locale);
    }

    @Nonnull
    public String toString() {
        return new ToStringGenerator((Object)this).append("itemCount", this.m_nItemCount).append("text", (Object)this.m_aText).getToString();
    }
}

