/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.uictrls.datatables;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.base.clone.ICloneable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.collection.commons.CommonsHashMap;
import com.helger.collection.commons.ICommonsMap;
import com.helger.html.jscode.IJSExpression;
import com.helger.html.jscode.JSAssocArray;
import com.helger.html.jscode.JSExpr;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public class DataTablesLayout
implements ICloneable<DataTablesLayout> {
    public static final String AREA_INFO = "info";
    public static final String AREA_PAGE_LENGTH = "pageLength";
    public static final String AREA_PAGING = "paging";
    public static final String AREA_SEARCH = "search";
    public static final String AREA_DIV = "div";
    private final ICommonsMap<String, IJSExpression> m_aMap;

    public DataTablesLayout() {
        this.m_aMap = new CommonsHashMap();
    }

    public DataTablesLayout(@Nonnull DataTablesLayout dataTablesLayout) {
        ValueEnforcer.notNull((Object)dataTablesLayout, (String)"rhs");
        this.m_aMap = (ICommonsMap)dataTablesLayout.m_aMap.getClone();
    }

    @Nonnull
    public Adder adder() {
        return new Adder();
    }

    public void set(@Nonnull EPlace ePlace, @Nonnegative int n, @Nullable IJSExpression iJSExpression) {
        ValueEnforcer.notNull((Object)((Object)ePlace), (String)"Place");
        ValueEnforcer.isGE0((int)n, (String)"Index");
        String string = ePlace.getKey(n);
        if (iJSExpression == null) {
            this.m_aMap.remove((Object)string);
        } else {
            this.m_aMap.put((Object)string, (Object)iJSExpression);
        }
    }

    @Nullable
    public JSAssocArray getAsJSAssocArray() {
        if (this.m_aMap.isEmpty()) {
            return null;
        }
        JSAssocArray jSAssocArray = new JSAssocArray();
        jSAssocArray.addAll(this.m_aMap);
        return jSAssocArray;
    }

    @Nonnull
    public DataTablesLayout getClone() {
        return new DataTablesLayout(this);
    }

    public final class Adder {
        private EPlace m_ePlace = EPlace.TOP;
        private int m_nIndex = 0;

        @Nonnull
        public Adder at(@Nonnull EPlace ePlace) {
            ValueEnforcer.notNull((Object)((Object)ePlace), (String)"Place");
            this.m_ePlace = ePlace;
            return this;
        }

        @Nonnull
        public Adder at(@Nonnegative int n) {
            ValueEnforcer.isGE0((int)n, (String)"Index");
            this.m_nIndex = n;
            return this;
        }

        public void set(@Nullable String string) {
            this.set((IJSExpression)(string == null ? null : JSExpr.lit((String)string)));
        }

        public void set(@Nullable IJSExpression iJSExpression) {
            DataTablesLayout.this.set(this.m_ePlace, this.m_nIndex, iJSExpression);
        }
    }

    public static enum EPlace {
        TOP("top{}"),
        TOP_START("top{}Start"),
        TOP_END("top{}End"),
        BOTTOM("bottom{}"),
        BOTTOM_START("bottom{}Start"),
        BOTTOM_END("bottom{}End");

        private final String m_sPlaceholder;

        private EPlace(String string2) {
            this.m_sPlaceholder = string2;
        }

        @Nonnull
        @Nonempty
        public String getKey(@Nonnegative int n) {
            if (n == 0) {
                return this.m_sPlaceholder.replace("{}", "");
            }
            return this.m_sPlaceholder.replace("{}", Integer.toString(n));
        }
    }
}

