/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.userdata;

import com.helger.base.id.factory.GlobalIDFactory;
import com.helger.base.state.ISuccessIndicator;
import com.helger.base.string.StringHelper;
import com.helger.io.file.FilenameHelper;
import com.helger.json.IJsonObject;
import com.helger.json.JsonObject;
import com.helger.mime.CMimeType;
import com.helger.photon.core.userdata.TemporaryUserDataObject;
import com.helger.photon.core.userdata.UserUploadManager;
import com.helger.servlet.response.UnifiedResponse;
import com.helger.web.fileupload.IFileItem;
import com.helger.web.scope.IRequestWebScopeWithoutResponse;
import com.helger.xservlet.handler.simple.IXServletSimpleHandler;
import jakarta.annotation.Nonnull;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserUploadXServletHandler
implements IXServletSimpleHandler {
    public static final String PARAM_DIRECTORY = "dir";
    public static final String PARAM_ID = "id";
    public static final String PARAM_FILE = "file";
    private static final Logger LOGGER = LoggerFactory.getLogger(UserUploadXServletHandler.class);

    @Nonnull
    protected IJsonObject createSuccess() {
        return (IJsonObject)new JsonObject().add((Object)"success", true);
    }

    @Nonnull
    protected IJsonObject createError(@Nonnull String string) {
        LOGGER.error("User upload error: " + string);
        return (IJsonObject)((IJsonObject)((IJsonObject)new JsonObject().add((Object)"success", false)).add((Object)"error", (Object)string)).add((Object)"preventRetry", true);
    }

    private void _post(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull UnifiedResponse unifiedResponse) {
        IJsonObject iJsonObject;
        Object object = iRequestWebScopeWithoutResponse.params().getValue((Object)PARAM_FILE);
        if (!(object instanceof IFileItem)) {
            iJsonObject = this.createError("No file passed. Maybe the request is not multipart, put 'multipart/form-data' enctype for your form.");
        } else {
            IFileItem iFileItem = (IFileItem)object;
            String string = iRequestWebScopeWithoutResponse.params().getAsString((Object)PARAM_DIRECTORY);
            boolean bl = StringHelper.isNotEmpty((String)string);
            if (bl && !FilenameHelper.isValidFilenameWithPaths((String)string)) {
                iJsonObject = this.createError("The passed directory name '" + string + "' is invalid!");
            } else {
                String string2 = iRequestWebScopeWithoutResponse.params().getAsString((Object)PARAM_ID);
                if (StringHelper.isEmpty((String)string2)) {
                    iJsonObject = this.createError("No file ID passed!");
                } else {
                    LOGGER.info("Uploading " + String.valueOf(iFileItem) + " as " + string2 + " to " + string);
                    Object object2 = bl ? FilenameHelper.ensurePathEndingWithSeparator((String)string) : "/";
                    object2 = (String)object2 + GlobalIDFactory.getNewPersistentStringID();
                    String string3 = FilenameHelper.getExtension((String)iFileItem.getNameSecure());
                    if (StringHelper.isNotEmpty((String)string3)) {
                        object2 = (String)object2 + "." + string3;
                    }
                    object2 = ((String)object2).toLowerCase(Locale.US);
                    TemporaryUserDataObject temporaryUserDataObject = new TemporaryUserDataObject((String)object2);
                    try {
                        ISuccessIndicator iSuccessIndicator = iFileItem.write(temporaryUserDataObject.getAsFile());
                        if (iSuccessIndicator.isFailure()) {
                            iJsonObject = this.createError("Failed to store uploaded file " + String.valueOf(iFileItem) + " to " + String.valueOf(temporaryUserDataObject) + " - " + String.valueOf(iSuccessIndicator));
                        } else {
                            UserUploadManager.getInstance().addUploadedFile(string2, temporaryUserDataObject);
                            iJsonObject = this.createSuccess();
                        }
                    }
                    catch (Exception exception) {
                        LOGGER.error("Writing " + String.valueOf(iFileItem) + " to " + String.valueOf(temporaryUserDataObject) + " failed", (Throwable)exception);
                        iJsonObject = this.createError("Failed to store uploaded file " + String.valueOf(iFileItem) + " to " + String.valueOf(temporaryUserDataObject));
                    }
                }
            }
        }
        unifiedResponse.setMimeType(CMimeType.APPLICATION_JSON).setContentAndCharset(iJsonObject.getAsJsonString(), StandardCharsets.UTF_8);
    }

    public void handleRequest(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull UnifiedResponse unifiedResponse) throws ServletException, IOException {
        unifiedResponse.disableCaching();
        this._post(iRequestWebScopeWithoutResponse, unifiedResponse);
    }
}

